/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.stream;

import java.io.Serializable;
import java.util.List;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.MediaFormat;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.ItagItem;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.DeliveryMethod;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public abstract class Stream
implements Serializable {
    public static final int FORMAT_ID_UNKNOWN = -1;
    public static final String ID_UNKNOWN = " ";
    public static final int ITAG_NOT_AVAILABLE_OR_NOT_APPLICABLE = -1;
    private final String id;
    @Nullable
    private final MediaFormat mediaFormat;
    private final String content;
    private final boolean isUrl;
    private final DeliveryMethod deliveryMethod;
    @Nullable
    private final String manifestUrl;

    public Stream(String id2, String content, boolean isUrl, @Nullable MediaFormat format, DeliveryMethod deliveryMethod, @Nullable String manifestUrl) {
        this.id = id2;
        this.content = content;
        this.isUrl = isUrl;
        this.mediaFormat = format;
        this.deliveryMethod = deliveryMethod;
        this.manifestUrl = manifestUrl;
    }

    public static boolean containSimilarStream(@Nonnull Stream stream, List<? extends Stream> streamList) {
        if (Utils.isNullOrEmpty(streamList)) {
            return false;
        }
        for (Stream stream2 : streamList) {
            if (!stream.equalStats(stream2)) continue;
            return true;
        }
        return false;
    }

    public boolean equalStats(@Nullable Stream other) {
        return other != null && this.mediaFormat != null && other.mediaFormat != null && this.mediaFormat.id == other.mediaFormat.id && this.deliveryMethod == other.deliveryMethod && this.isUrl == other.isUrl;
    }

    public String getId() {
        return this.id;
    }

    @Deprecated
    @Nullable
    public String getUrl() {
        return this.isUrl ? this.content : null;
    }

    @Nonnull
    public String getContent() {
        return this.content;
    }

    public boolean isUrl() {
        return this.isUrl;
    }

    @Nullable
    public MediaFormat getFormat() {
        return this.mediaFormat;
    }

    public int getFormatId() {
        if (this.mediaFormat != null) {
            return this.mediaFormat.id;
        }
        return -1;
    }

    @Nonnull
    public DeliveryMethod getDeliveryMethod() {
        return this.deliveryMethod;
    }

    @Nullable
    public String getManifestUrl() {
        return this.manifestUrl;
    }

    @Nullable
    public abstract ItagItem getItagItem();
}

