/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler;

import java.net.URL;
import java.util.List;
import java.util.regex.Pattern;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public final class YoutubeChannelLinkHandlerFactory
extends ListLinkHandlerFactory {
    private static final YoutubeChannelLinkHandlerFactory INSTANCE = new YoutubeChannelLinkHandlerFactory();
    private static final Pattern EXCLUDED_SEGMENTS = Pattern.compile("playlist|watch|attribution_link|watch_popup|embed|feed|select_site|account|reporthistory|redirect");

    private YoutubeChannelLinkHandlerFactory() {
    }

    public static YoutubeChannelLinkHandlerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public String getUrl(String id2, List<String> contentFilters, String searchFilter) throws ParsingException, UnsupportedOperationException {
        return "https://www.youtube.com/" + id2;
    }

    private boolean isCustomShortChannelUrl(@Nonnull String[] splitPath) {
        return splitPath.length == 1 && !EXCLUDED_SEGMENTS.matcher(splitPath[0]).matches();
    }

    private boolean isHandle(@Nonnull String[] splitPath) {
        return splitPath.length > 0 && splitPath[0].startsWith("@");
    }

    @Override
    public String getId(String url) throws ParsingException, UnsupportedOperationException {
        try {
            URL urlObj = Utils.stringToURL(url);
            Object path = urlObj.getPath();
            if (!Utils.isHTTP(urlObj) || !YoutubeParsingHelper.isYoutubeURL(urlObj) && !YoutubeParsingHelper.isInvidiousURL(urlObj) && !YoutubeParsingHelper.isHooktubeURL(urlObj)) {
                throw new ParsingException("The URL given is not a YouTube URL");
            }
            String[] splitPath = ((String)(path = ((String)path).substring(1))).split("/");
            if (this.isHandle(splitPath)) {
                return splitPath[0];
            }
            if (this.isCustomShortChannelUrl(splitPath)) {
                path = "c/" + (String)path;
                splitPath = ((String)path).split("/");
            }
            if (!(((String)path).startsWith("user/") || ((String)path).startsWith("channel/") || ((String)path).startsWith("c/"))) {
                throw new ParsingException("The given URL is not a channel, a user or a handle URL");
            }
            String id2 = splitPath[1];
            if (Utils.isBlank(id2)) {
                throw new ParsingException("The given ID is not a YouTube channel or user ID");
            }
            return splitPath[0] + "/" + id2;
        }
        catch (Exception e) {
            throw new ParsingException("Could not parse URL :" + e.getMessage(), e);
        }
    }

    @Override
    public boolean onAcceptUrl(String url) {
        try {
            this.getId(url);
        }
        catch (ParsingException e) {
            return false;
        }
        return true;
    }
}

