/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.kiosk;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonBuilder;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonWriter;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.kiosk.KioskExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.ContentCountry;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.DateWrapper;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.Localization;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.InnertubeClientRequestInfo;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubeChannelLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubeStreamLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamType;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.JsonUtils;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

abstract class YoutubeChartsBaseKioskExtractor
extends KioskExtractor<StreamInfoItem> {
    protected static final Set<String> YT_CHARTS_SUPPORTED_COUNTRY_CODES = Set.of("AE", "AR", "AT", "AU", "BE", "BO", "BR", "CA", "CH", "CL", "CO", "CR", "CZ", "DE", "DK", "DO", "EC", "EE", "EG", "ES", "FI", "FR", "GB", "GT", "HN", "HU", "ID", "IE", "IL", "IN", "IS", "IT", "JP", "KE", "KR", "LU", "MX", "NG", "NI", "NL", "NO", "NZ", "PA", "PE", "PL", "PT", "PY", "RO", "RS", "RU", "SA", "SE", "SV", "TR", "TZ", "UA", "UG", "US", "UY", "ZA", "ZW");
    protected static final String YT_CHARTS_ENDPOINT = "https://charts.youtube.com/youtubei/v1/browse?alt=json&prettyPrint=false";
    protected final String chartType;
    protected JsonObject browseResponse;

    protected YoutubeChartsBaseKioskExtractor(StreamingService streamingService, ListLinkHandler linkHandler, String kioskId, String chartType) {
        super(streamingService, linkHandler, kioskId);
        this.chartType = chartType;
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        Localization localization = this.getExtractorLocalization();
        ContentCountry contentCountry = this.getExtractorContentCountry();
        InnertubeClientRequestInfo innertubeClientRequestInfo = InnertubeClientRequestInfo.ofWebMusicAnalyticsChartsClient();
        byte[] body = JsonWriter.string(((JsonBuilder)((JsonBuilder)YoutubeParsingHelper.prepareJsonBuilder(this.getExtractorLocalization(), contentCountry, innertubeClientRequestInfo, null).value("browseId", "FEmusic_analytics_charts_home")).value("query", "perspective=CHART_DETAILS&chart_params_country_code=" + contentCountry.getCountryCode() + "&chart_params_chart_type=" + this.chartType)).done()).getBytes(StandardCharsets.UTF_8);
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>(YoutubeParsingHelper.getOriginReferrerHeaders("https://charts.youtube.com"));
        headers.putAll(YoutubeParsingHelper.getClientHeaders(innertubeClientRequestInfo.clientInfo.clientId, innertubeClientRequestInfo.clientInfo.clientVersion));
        this.browseResponse = JsonUtils.toJsonObject(YoutubeParsingHelper.getValidJsonResponseBody(this.getDownloader().postWithContentTypeJson(YT_CHARTS_ENDPOINT, headers, body, localization)));
    }

    @Override
    @Nonnull
    public abstract String getName() throws ParsingException;

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage<StreamInfoItem> getInitialPage() throws IOException, ExtractionException {
        JsonArray videos = this.browseResponse.getObject("contents").getObject("sectionListRenderer").getArray("contents").getObject(0).getObject("musicAnalyticsSectionRenderer").getObject("content").getArray("videos").getObject(0).getArray("videoViews");
        StreamInfoItemsCollector collector = new StreamInfoItemsCollector(this.getServiceId());
        videos.streamAsJsonObjects().forEachOrdered(video -> collector.commit(new YoutubeChartsVideoInfoItemExtractor((JsonObject)video)));
        return new ListExtractor.InfoItemsPage<StreamInfoItem>(collector, null);
    }

    @Override
    public ListExtractor.InfoItemsPage<StreamInfoItem> getPage(Page page) {
        return ListExtractor.InfoItemsPage.emptyPage();
    }

    static final class YoutubeChartsVideoInfoItemExtractor
    implements StreamInfoItemExtractor {
        @Nonnull
        private final JsonObject videoObject;

        YoutubeChartsVideoInfoItemExtractor(@Nonnull JsonObject videoObject) {
            this.videoObject = videoObject;
        }

        @Override
        public StreamType getStreamType() {
            return StreamType.VIDEO_STREAM;
        }

        @Override
        public boolean isAd() {
            return false;
        }

        @Override
        public long getDuration() {
            return this.videoObject.getInt("videoDuration", -1);
        }

        @Override
        public long getViewCount() {
            return -1L;
        }

        @Override
        public String getUploaderName() {
            return this.videoObject.getString("channelName");
        }

        @Override
        public String getUploaderUrl() throws ParsingException {
            String channelId = this.videoObject.getString("externalChannelId");
            if (Utils.isNullOrEmpty(channelId)) {
                throw new ParsingException("Could not get channel ID");
            }
            return YoutubeChannelLinkHandlerFactory.getInstance().getUrl("channel/" + channelId);
        }

        @Override
        public boolean isUploaderVerified() {
            return false;
        }

        @Override
        @Nullable
        public String getTextualUploadDate() {
            return null;
        }

        @Override
        @Nonnull
        public DateWrapper getUploadDate() {
            JsonObject releaseDate = this.videoObject.getObject("releaseDate");
            LocalDate localDate = LocalDate.of(releaseDate.getInt("year"), releaseDate.getInt("month"), releaseDate.getInt("day"));
            Instant instant = localDate.atStartOfDay(ZoneOffset.UTC).toInstant();
            return new DateWrapper(instant, true);
        }

        @Override
        public String getName() {
            return this.videoObject.getString("title");
        }

        @Override
        public String getUrl() throws ParsingException {
            return YoutubeStreamLinkHandlerFactory.getInstance().getUrl(this.videoObject.getString("id"));
        }

        @Override
        @Nonnull
        public List<Image> getThumbnails() throws ParsingException {
            return YoutubeParsingHelper.getThumbnailsFromInfoItem(this.videoObject);
        }
    }
}

