/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.DateWrapper;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.TimeAgoParser;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubeChannelLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubeStreamLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamType;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.JsonUtils;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class YoutubeStreamInfoItemLockupExtractor
implements StreamInfoItemExtractor {
    private static final String NO_VIEWS_LOWERCASE = "no views";
    private static final String PREMIERES_TEXT = "Premieres ";
    private static final DateTimeFormatter PREMIERES_DATE_FORMATTER = DateTimeFormatter.ofPattern("dd/MM/yyyy, HH:mm");
    private final JsonObject lockupViewModel;
    private final TimeAgoParser timeAgoParser;
    private StreamType cachedStreamType;
    private String cachedName;
    private Optional<String> cachedDateText;
    private ChannelImageViewModel cachedChannelImageViewModel;
    private JsonArray cachedMetadataRows;

    public YoutubeStreamInfoItemLockupExtractor(JsonObject lockupViewModel, @Nullable TimeAgoParser timeAgoParser) {
        this.lockupViewModel = lockupViewModel;
        this.timeAgoParser = timeAgoParser;
    }

    @Override
    public StreamType getStreamType() throws ParsingException {
        if (this.cachedStreamType == null) {
            this.cachedStreamType = this.determineStreamType();
        }
        return this.cachedStreamType;
    }

    private StreamType determineStreamType() throws ParsingException {
        if (JsonUtils.getArray(this.lockupViewModel, "contentImage.thumbnailViewModel.overlays").streamAsJsonObjects().flatMap(overlay -> overlay.getObject("thumbnailOverlayBadgeViewModel").getArray("thumbnailBadges").streamAsJsonObjects()).map(thumbnailBadge -> thumbnailBadge.getObject("thumbnailBadgeViewModel")).anyMatch(thumbnailBadgeViewModel -> {
            if ("THUMBNAIL_OVERLAY_BADGE_STYLE_LIVE".equals(thumbnailBadgeViewModel.getString("badgeStyle"))) {
                return true;
            }
            return thumbnailBadgeViewModel.getObject("icon").getArray("sources").streamAsJsonObjects().map(source -> source.getObject("clientResource").getString("imageName")).anyMatch("LIVE"::equals);
        })) {
            return StreamType.LIVE_STREAM;
        }
        return StreamType.VIDEO_STREAM;
    }

    @Override
    public boolean isAd() throws ParsingException {
        String name = this.getName();
        return "[Private video]".equals(name) || "[Deleted video]".equals(name);
    }

    @Override
    public String getUrl() throws ParsingException {
        try {
            String videoId = this.lockupViewModel.getString("contentId");
            if (Utils.isNullOrEmpty(videoId)) {
                videoId = JsonUtils.getString(this.lockupViewModel, "rendererContext.commandContext.onTap.innertubeCommand.watchEndpoint.videoId");
            }
            return YoutubeStreamLinkHandlerFactory.getInstance().getUrl(videoId);
        }
        catch (Exception e) {
            throw new ParsingException("Could not get url", e);
        }
    }

    @Override
    public String getName() throws ParsingException {
        if (this.cachedName != null) {
            return this.cachedName;
        }
        String name = JsonUtils.getString(this.lockupViewModel, "metadata.lockupMetadataViewModel.title.content");
        if (!Utils.isNullOrEmpty(name)) {
            this.cachedName = name;
            return name;
        }
        throw new ParsingException("Could not get name");
    }

    @Override
    public long getDuration() throws ParsingException {
        if (this.isLive() || this.isPremiere()) {
            return -1L;
        }
        List potentialDurations = JsonUtils.getArray(this.lockupViewModel, "contentImage.thumbnailViewModel.overlays").streamAsJsonObjects().flatMap(jsonObject -> jsonObject.getObject("thumbnailOverlayBadgeViewModel").getArray("thumbnailBadges").streamAsJsonObjects()).map(jsonObject -> jsonObject.getObject("thumbnailBadgeViewModel").getString("text")).collect(Collectors.toList());
        if (potentialDurations.isEmpty()) {
            throw new ParsingException("Could not get duration: No parsable durations detected");
        }
        ParsingException parsingException = null;
        for (String potentialDuration : potentialDurations) {
            try {
                return YoutubeParsingHelper.parseDurationString(potentialDuration);
            }
            catch (ParsingException ex) {
                parsingException = ex;
            }
        }
        throw new ParsingException("Could not get duration", parsingException);
    }

    @Override
    public String getUploaderName() throws ParsingException {
        return this.metadataPart(0, 0).map(this::getTextContentFromMetadataPart).filter(s -> !Utils.isNullOrEmpty(s)).orElseThrow(() -> new ParsingException("Could not get uploader name"));
    }

    @Override
    public String getUploaderUrl() throws ParsingException {
        JsonObject innerTubeCommand = this.channelImageViewModel().forUploaderUrlExtraction().getObject("rendererContext").getObject("org.watermedia.shaded.commandContext").getObject("onTap").getObject("innertubeCommand");
        JsonObject browseEndpoint = innerTubeCommand.getObject("browseEndpoint");
        String channelId = browseEndpoint.getString("browseId");
        if (channelId != null && channelId.startsWith("UC")) {
            return YoutubeChannelLinkHandlerFactory.getInstance().getUrl("channel/" + channelId);
        }
        String canonicalBaseUrl = browseEndpoint.getString("canonicalBaseUrl");
        if (!Utils.isNullOrEmpty(canonicalBaseUrl)) {
            return this.resolveUploaderUrlFromRelativeUrl(canonicalBaseUrl);
        }
        String webCommandMetadataUrl = innerTubeCommand.getObject("org.watermedia.shaded.commandMetadata").getObject("webCommandMetadata").getString("url");
        if (!Utils.isNullOrEmpty(webCommandMetadataUrl)) {
            return this.resolveUploaderUrlFromRelativeUrl(webCommandMetadataUrl);
        }
        throw new ParsingException("Could not get uploader url");
    }

    private String resolveUploaderUrlFromRelativeUrl(String relativeUrl) throws ParsingException {
        return YoutubeChannelLinkHandlerFactory.getInstance().getUrl(relativeUrl.startsWith("/") ? relativeUrl.substring(1) : relativeUrl);
    }

    @Override
    @Nonnull
    public List<Image> getUploaderAvatars() throws ParsingException {
        return YoutubeParsingHelper.getImagesFromThumbnailsArray(JsonUtils.getArray(this.channelImageViewModel().forAvatarExtraction(), "avatarViewModel.image.sources"));
    }

    @Override
    public boolean isUploaderVerified() throws ParsingException {
        return this.metadataPart(0, 0).map(jsonObject -> jsonObject.getObject("text").getArray("attachmentRuns")).map(YoutubeParsingHelper::hasArtistOrVerifiedIconBadgeAttachment).orElse(false);
    }

    @Override
    @Nullable
    public String getTextualUploadDate() throws ParsingException {
        if (this.isLive()) {
            return null;
        }
        Optional<String> dateText = this.getDateText();
        if (this.isPremiere()) {
            return this.getDateFromPremiere(dateText);
        }
        return dateText.orElse(null);
    }

    @Nullable
    private String getDateFromPremiere(Optional<String> dateText) {
        return dateText.map(str -> str.replace(PREMIERES_TEXT, "")).orElse(null);
    }

    @Override
    @Nullable
    public DateWrapper getUploadDate() throws ParsingException {
        if (this.timeAgoParser == null) {
            return null;
        }
        String textualUploadDate = this.getTextualUploadDate();
        if (textualUploadDate == null) {
            return null;
        }
        if (this.isPremiere()) {
            String premiereDate = this.getDateFromPremiere(this.getDateText());
            if (premiereDate == null) {
                throw new ParsingException("Could not get upload date from premiere");
            }
            try {
                LocalDateTime dateTime = LocalDateTime.parse(premiereDate, PREMIERES_DATE_FORMATTER);
                return new DateWrapper(dateTime.atZone(ZoneOffset.UTC).toInstant(), false);
            }
            catch (DateTimeParseException e) {
                throw new ParsingException("Could not parse premiere upload date", e);
            }
        }
        return this.timeAgoParser.parse(textualUploadDate);
    }

    @Override
    public long getViewCount() throws ParsingException {
        if (this.isPremiere()) {
            return -1L;
        }
        Optional<String> optTextContent = this.metadataPart(1, 0).map(this::getTextContentFromMetadataPart);
        if (optTextContent.isPresent()) {
            return this.getViewCountFromViewCountText(optTextContent.get());
        }
        return !this.isLive() ? -1L : 0L;
    }

    private long getViewCountFromViewCountText(@Nonnull String viewCountText) throws NumberFormatException, ParsingException {
        if (viewCountText.toLowerCase().contains(NO_VIEWS_LOWERCASE)) {
            return 0L;
        }
        if (viewCountText.toLowerCase().contains("recommended")) {
            return -1L;
        }
        return Utils.mixedNumberWordToLong(viewCountText);
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        return YoutubeParsingHelper.getImagesFromThumbnailsArray(JsonUtils.getArray(this.lockupViewModel, "contentImage.thumbnailViewModel.image.sources"));
    }

    private ChannelImageViewModel channelImageViewModel() throws ParsingException {
        if (this.cachedChannelImageViewModel == null) {
            this.cachedChannelImageViewModel = this.determineChannelImageViewModel();
        }
        return this.cachedChannelImageViewModel;
    }

    private ChannelImageViewModel determineChannelImageViewModel() throws ParsingException {
        JsonObject image = this.lockupViewModel.getObject("metadata").getObject("lockupMetadataViewModel").getObject("image");
        JsonObject single = image.getObject("decoratedAvatarViewModel", null);
        if (single != null) {
            return new SingleChannelImageViewModel(single);
        }
        JsonObject multi = image.getObject("avatarStackViewModel", null);
        if (multi != null) {
            return new MultiChannelImageViewModel(multi);
        }
        throw new ParsingException("Failed to determine channel image view model");
    }

    private Optional<JsonObject> metadataPart(int rowIndex, int partIndex) throws ParsingException {
        if (this.cachedMetadataRows == null) {
            this.cachedMetadataRows = JsonUtils.getArray(this.lockupViewModel, "metadata.lockupMetadataViewModel.metadata.contentMetadataViewModel.metadataRows");
        }
        return this.cachedMetadataRows.streamAsJsonObjects().skip(rowIndex).limit(1L).flatMap(jsonObject -> jsonObject.getArray("metadataParts").streamAsJsonObjects().skip(partIndex).limit(1L)).findFirst();
    }

    private String getTextContentFromMetadataPart(JsonObject metadataPart) {
        return metadataPart.getObject("text").getString("content");
    }

    private boolean isLive() throws ParsingException {
        return this.getStreamType() != StreamType.VIDEO_STREAM;
    }

    private Optional<String> getDateText() throws ParsingException {
        if (this.cachedDateText == null) {
            this.cachedDateText = this.metadataPart(1, 1).map(this::getTextContentFromMetadataPart);
        }
        return this.cachedDateText;
    }

    private boolean isPremiere() throws ParsingException {
        return this.getDateText().map(dateText -> dateText.contains(PREMIERES_TEXT)).orElse(false);
    }

    static class MultiChannelImageViewModel
    extends ChannelImageViewModel {
        MultiChannelImageViewModel(JsonObject viewModel) {
            super(viewModel);
        }

        @Override
        public JsonObject forUploaderUrlExtraction() {
            return this.viewModel.getObject("rendererContext").getObject("org.watermedia.shaded.commandContext").getObject("onTap").getObject("innertubeCommand").getObject("showDialogCommand").getObject("panelLoadingStrategy").getObject("inlineContent").getObject("dialogViewModel").getObject("customContent").getObject("listViewModel").getArray("listItems").streamAsJsonObjects().map(item -> item.getObject("listItemViewModel")).findFirst().orElse(null);
        }

        @Override
        public JsonObject forAvatarExtraction() {
            return this.viewModel.getArray("avatars").getObject(0);
        }
    }

    static class SingleChannelImageViewModel
    extends ChannelImageViewModel {
        SingleChannelImageViewModel(JsonObject viewModel) {
            super(viewModel);
        }

        @Override
        public JsonObject forUploaderUrlExtraction() {
            return this.viewModel;
        }

        @Override
        public JsonObject forAvatarExtraction() {
            return this.viewModel.getObject("avatar");
        }
    }

    static abstract class ChannelImageViewModel {
        protected JsonObject viewModel;

        protected ChannelImageViewModel(JsonObject viewModel) {
            this.viewModel = viewModel;
        }

        public abstract JsonObject forUploaderUrlExtraction();

        public abstract JsonObject forAvatarExtraction();
    }
}

