/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.regex.Pattern;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.DateWrapper;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.TimeAgoParser;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubeStreamLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.ContentAvailability;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamType;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.JsonUtils;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Parser;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class YoutubeStreamInfoItemExtractor
implements StreamInfoItemExtractor {
    private static final Pattern ACCESSIBILITY_DATA_VIEW_COUNT_REGEX = Pattern.compile("([\\d,]+) views$");
    private static final String NO_VIEWS_LOWERCASE = "no views";
    private final JsonObject videoInfo;
    private final TimeAgoParser timeAgoParser;
    private StreamType cachedStreamType;
    private Boolean isPremiere;

    public YoutubeStreamInfoItemExtractor(JsonObject videoInfoItem, @Nullable TimeAgoParser timeAgoParser) {
        this.videoInfo = videoInfoItem;
        this.timeAgoParser = timeAgoParser;
    }

    @Override
    public StreamType getStreamType() {
        if (this.cachedStreamType != null) {
            return this.cachedStreamType;
        }
        JsonArray badges = this.videoInfo.getArray("badges");
        for (Object badge : badges) {
            JsonObject badgeRenderer;
            if (!(badge instanceof JsonObject) || !(badgeRenderer = ((JsonObject)badge).getObject("metadataBadgeRenderer")).getString("style", "").equals("BADGE_STYLE_TYPE_LIVE_NOW") && !badgeRenderer.getString("label", "").equals("LIVE NOW")) continue;
            this.cachedStreamType = StreamType.LIVE_STREAM;
            return this.cachedStreamType;
        }
        for (Object overlay : this.videoInfo.getArray("thumbnailOverlays")) {
            String style;
            if (!(overlay instanceof JsonObject) || !(style = ((JsonObject)overlay).getObject("thumbnailOverlayTimeStatusRenderer").getString("style", "")).equalsIgnoreCase("LIVE")) continue;
            this.cachedStreamType = StreamType.LIVE_STREAM;
            return this.cachedStreamType;
        }
        this.cachedStreamType = StreamType.VIDEO_STREAM;
        return this.cachedStreamType;
    }

    @Override
    public boolean isAd() throws ParsingException {
        return this.isPremium() || this.getName().equals("[Private video]") || this.getName().equals("[Deleted video]");
    }

    @Override
    public String getUrl() throws ParsingException {
        try {
            String videoId = this.videoInfo.getString("videoId");
            return YoutubeStreamLinkHandlerFactory.getInstance().getUrl(videoId);
        }
        catch (Exception e) {
            throw new ParsingException("Could not get url", e);
        }
    }

    @Override
    public String getName() throws ParsingException {
        String name = YoutubeParsingHelper.getTextFromObject(this.videoInfo.getObject("title"));
        if (!Utils.isNullOrEmpty(name)) {
            return name;
        }
        throw new ParsingException("Could not get name");
    }

    @Override
    public long getDuration() throws ParsingException {
        if (this.getStreamType() == StreamType.LIVE_STREAM) {
            return -1L;
        }
        String duration = YoutubeParsingHelper.getTextFromObject(this.videoInfo.getObject("lengthText"));
        if (Utils.isNullOrEmpty(duration)) {
            duration = this.videoInfo.getString("lengthSeconds");
            if (Utils.isNullOrEmpty(duration)) {
                JsonObject timeOverlay = this.videoInfo.getArray("thumbnailOverlays").stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).filter(thumbnailOverlay -> thumbnailOverlay.has("thumbnailOverlayTimeStatusRenderer")).findFirst().orElse(null);
                if (timeOverlay != null) {
                    duration = YoutubeParsingHelper.getTextFromObject(timeOverlay.getObject("thumbnailOverlayTimeStatusRenderer").getObject("text"));
                }
            }
            if (Utils.isNullOrEmpty(duration)) {
                if (this.isPremiere()) {
                    return -1L;
                }
                throw new ParsingException("Could not get duration");
            }
        }
        return YoutubeParsingHelper.parseDurationString(duration);
    }

    @Override
    public String getUploaderName() throws ParsingException {
        String name = YoutubeParsingHelper.getTextFromObject(this.videoInfo.getObject("longBylineText"));
        if (Utils.isNullOrEmpty(name) && Utils.isNullOrEmpty(name = YoutubeParsingHelper.getTextFromObject(this.videoInfo.getObject("ownerText"))) && Utils.isNullOrEmpty(name = YoutubeParsingHelper.getTextFromObject(this.videoInfo.getObject("shortBylineText")))) {
            throw new ParsingException("Could not get uploader name");
        }
        return name;
    }

    @Override
    public String getUploaderUrl() throws ParsingException {
        String url = YoutubeParsingHelper.getUrlFromNavigationEndpoint(this.videoInfo.getObject("longBylineText").getArray("runs").getObject(0).getObject("navigationEndpoint"));
        if (Utils.isNullOrEmpty(url) && Utils.isNullOrEmpty(url = YoutubeParsingHelper.getUrlFromNavigationEndpoint(this.videoInfo.getObject("ownerText").getArray("runs").getObject(0).getObject("navigationEndpoint"))) && Utils.isNullOrEmpty(url = YoutubeParsingHelper.getUrlFromNavigationEndpoint(this.videoInfo.getObject("shortBylineText").getArray("runs").getObject(0).getObject("navigationEndpoint")))) {
            throw new ParsingException("Could not get uploader url");
        }
        return url;
    }

    @Override
    @Nonnull
    public List<Image> getUploaderAvatars() throws ParsingException {
        if (this.videoInfo.has("channelThumbnailSupportedRenderers")) {
            return YoutubeParsingHelper.getImagesFromThumbnailsArray(JsonUtils.getArray(this.videoInfo, "channelThumbnailSupportedRenderers.channelThumbnailWithLinkRenderer.thumbnail.thumbnails"));
        }
        if (this.videoInfo.has("channelThumbnail")) {
            return YoutubeParsingHelper.getImagesFromThumbnailsArray(JsonUtils.getArray(this.videoInfo, "channelThumbnail.thumbnails"));
        }
        return List.of();
    }

    @Override
    public boolean isUploaderVerified() throws ParsingException {
        return YoutubeParsingHelper.isVerified(this.videoInfo.getArray("ownerBadges"));
    }

    @Override
    @Nullable
    public String getTextualUploadDate() throws ParsingException {
        if (this.getStreamType() == StreamType.LIVE_STREAM) {
            return null;
        }
        if (this.isPremiere()) {
            LocalDateTime localDateTime = LocalDateTime.ofInstant(this.getInstantFromPremiere(), ZoneId.systemDefault());
            return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm").format(localDateTime);
        }
        String publishedTimeText = YoutubeParsingHelper.getTextFromObject(this.videoInfo.getObject("publishedTimeText"));
        if (Utils.isNullOrEmpty(publishedTimeText) && this.videoInfo.has("videoInfo")) {
            publishedTimeText = this.videoInfo.getObject("videoInfo").getArray("runs").getObject(2).getString("text");
        }
        return Utils.isNullOrEmpty(publishedTimeText) ? null : publishedTimeText;
    }

    @Override
    @Nullable
    public DateWrapper getUploadDate() throws ParsingException {
        if (this.getStreamType() == StreamType.LIVE_STREAM) {
            return null;
        }
        if (this.isPremiere()) {
            return new DateWrapper(this.getInstantFromPremiere());
        }
        String textualUploadDate = this.getTextualUploadDate();
        if (this.timeAgoParser != null && !Utils.isNullOrEmpty(textualUploadDate)) {
            try {
                return this.timeAgoParser.parse(textualUploadDate);
            }
            catch (ParsingException e) {
                throw new ParsingException("Could not get upload date", e);
            }
        }
        return null;
    }

    @Override
    public long getViewCount() throws ParsingException {
        if (this.isPremium() || this.isPremiere()) {
            return -1L;
        }
        String viewCountText = YoutubeParsingHelper.getTextFromObject(this.videoInfo.getObject("viewCountText"));
        if (!Utils.isNullOrEmpty(viewCountText)) {
            try {
                return this.getViewCountFromViewCountText(viewCountText, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.getStreamType() != StreamType.LIVE_STREAM) {
            try {
                return this.getViewCountFromAccessibilityData();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.videoInfo.has("videoInfo")) {
            try {
                return this.getViewCountFromViewCountText(this.videoInfo.getObject("videoInfo").getArray("runs").getObject(0).getString("text", ""), true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.videoInfo.has("shortViewCountText")) {
            try {
                String shortViewCountText = YoutubeParsingHelper.getTextFromObject(this.videoInfo.getObject("shortViewCountText"));
                if (!Utils.isNullOrEmpty(shortViewCountText)) {
                    return this.getViewCountFromViewCountText(shortViewCountText, true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1L;
    }

    private long getViewCountFromViewCountText(@Nonnull String viewCountText, boolean isMixedNumber) throws NumberFormatException, ParsingException {
        if (viewCountText.toLowerCase().contains(NO_VIEWS_LOWERCASE)) {
            return 0L;
        }
        if (viewCountText.toLowerCase().contains("recommended")) {
            return -1L;
        }
        return isMixedNumber ? Utils.mixedNumberWordToLong(viewCountText) : Long.parseLong(Utils.removeNonDigitCharacters(viewCountText));
    }

    private long getViewCountFromAccessibilityData() throws NumberFormatException, Parser.RegexException {
        String videoInfoTitleAccessibilityData = this.videoInfo.getObject("title").getObject("accessibility").getObject("accessibilityData").getString("label", "");
        if (videoInfoTitleAccessibilityData.toLowerCase().endsWith(NO_VIEWS_LOWERCASE)) {
            return 0L;
        }
        return Long.parseLong(Utils.removeNonDigitCharacters(Parser.matchGroup1(ACCESSIBILITY_DATA_VIEW_COUNT_REGEX, videoInfoTitleAccessibilityData)));
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        return YoutubeParsingHelper.getThumbnailsFromInfoItem(this.videoInfo);
    }

    private boolean isPremium() {
        JsonArray badges = this.videoInfo.getArray("badges");
        for (Object badge : badges) {
            if (!((JsonObject)badge).getObject("metadataBadgeRenderer").getString("label", "").equals("Premium")) continue;
            return true;
        }
        return false;
    }

    private boolean isPremiere() {
        if (this.isPremiere == null) {
            this.isPremiere = this.videoInfo.has("upcomingEventData");
        }
        return this.isPremiere;
    }

    private Instant getInstantFromPremiere() throws ParsingException {
        JsonObject upcomingEventData = this.videoInfo.getObject("upcomingEventData");
        String startTime = upcomingEventData.getString("startTime");
        try {
            return Instant.ofEpochSecond(Long.parseLong(startTime));
        }
        catch (Exception e) {
            String message = "Could not parse date from premiere: \"" + startTime + "\"";
            throw new ParsingException(message, e);
        }
    }

    @Override
    @Nullable
    public String getShortDescription() throws ParsingException {
        if (this.videoInfo.has("detailedMetadataSnippets")) {
            return YoutubeParsingHelper.getTextFromObject(this.videoInfo.getArray("detailedMetadataSnippets").getObject(0).getObject("snippetText"));
        }
        if (this.videoInfo.has("descriptionSnippet")) {
            return YoutubeParsingHelper.getTextFromObject(this.videoInfo.getObject("descriptionSnippet"));
        }
        return null;
    }

    @Override
    public boolean isShortFormContent() throws ParsingException {
        try {
            boolean isShort;
            String webPageType = this.videoInfo.getObject("navigationEndpoint").getObject("org.watermedia.shaded.commandMetadata").getObject("webCommandMetadata").getString("webPageType");
            boolean bl = isShort = !Utils.isNullOrEmpty(webPageType) && webPageType.equals("WEB_PAGE_TYPE_SHORTS");
            if (!isShort) {
                isShort = this.videoInfo.getObject("navigationEndpoint").has("reelWatchEndpoint");
            }
            if (!isShort) {
                JsonObject thumbnailTimeOverlay = this.videoInfo.getArray("thumbnailOverlays").stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).filter(thumbnailOverlay -> thumbnailOverlay.has("thumbnailOverlayTimeStatusRenderer")).map(thumbnailOverlay -> thumbnailOverlay.getObject("thumbnailOverlayTimeStatusRenderer")).findFirst().orElse(null);
                if (!Utils.isNullOrEmpty(thumbnailTimeOverlay)) {
                    isShort = thumbnailTimeOverlay.getString("style", "").equalsIgnoreCase("SHORTS") || thumbnailTimeOverlay.getObject("icon").getString("iconType", "").toLowerCase().contains("shorts");
                }
            }
            return isShort;
        }
        catch (Exception e) {
            throw new ParsingException("Could not determine if this is short-form content", e);
        }
    }

    private boolean isMembersOnly() throws ParsingException {
        return this.videoInfo.getArray("badges").stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(badge -> badge.getObject("metadataBadgeRenderer").getString("style")).anyMatch("BADGE_STYLE_TYPE_MEMBERS_ONLY"::equals);
    }

    @Override
    @Nonnull
    public ContentAvailability getContentAvailability() throws ParsingException {
        if (this.isPremiere()) {
            return ContentAvailability.UPCOMING;
        }
        if (this.isMembersOnly()) {
            return ContentAvailability.MEMBERSHIP;
        }
        if (this.isPremium()) {
            return ContentAvailability.PAID;
        }
        return ContentAvailability.AVAILABLE;
    }
}

