/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors;

import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.DateWrapper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubeStreamLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamType;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

class YoutubeShortsLockupInfoItemExtractor
implements StreamInfoItemExtractor {
    @Nonnull
    private final JsonObject shortsLockupViewModel;

    YoutubeShortsLockupInfoItemExtractor(@Nonnull JsonObject shortsLockupViewModel) {
        this.shortsLockupViewModel = shortsLockupViewModel;
    }

    @Override
    public String getName() throws ParsingException {
        return this.shortsLockupViewModel.getObject("overlayMetadata").getObject("primaryText").getString("content");
    }

    @Override
    public String getUrl() throws ParsingException {
        String videoId = this.shortsLockupViewModel.getObject("onTap").getObject("innertubeCommand").getObject("reelWatchEndpoint").getString("videoId");
        if (Utils.isNullOrEmpty(videoId)) {
            videoId = this.shortsLockupViewModel.getObject("inlinePlayerData").getObject("onVisible").getObject("innertubeCommand").getObject("watchEndpoint").getString("videoId");
        }
        if (Utils.isNullOrEmpty(videoId)) {
            throw new ParsingException("Could not get video ID");
        }
        try {
            return YoutubeStreamLinkHandlerFactory.getInstance().getUrl(videoId);
        }
        catch (Exception e) {
            throw new ParsingException("Could not get URL", e);
        }
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        if (this.shortsLockupViewModel.has("thumbnail")) {
            return YoutubeParsingHelper.getImagesFromThumbnailsArray(this.shortsLockupViewModel.getObject("thumbnail").getArray("sources"));
        }
        return YoutubeParsingHelper.getImagesFromThumbnailsArray(this.shortsLockupViewModel.getObject("thumbnailViewModel").getObject("thumbnailViewModel").getObject("image").getArray("sources"));
    }

    @Override
    public StreamType getStreamType() throws ParsingException {
        return StreamType.VIDEO_STREAM;
    }

    @Override
    public long getViewCount() throws ParsingException {
        String viewCountText = this.shortsLockupViewModel.getObject("overlayMetadata").getObject("secondaryText").getString("content");
        if (!Utils.isNullOrEmpty(viewCountText)) {
            if (viewCountText.contains("\u272a")) {
                return -1L;
            }
            if (viewCountText.toLowerCase().contains("no views")) {
                return 0L;
            }
            return Utils.mixedNumberWordToLong(viewCountText);
        }
        throw new ParsingException("Could not get short view count");
    }

    @Override
    public boolean isShortFormContent() {
        return true;
    }

    @Override
    public boolean isAd() throws ParsingException {
        return false;
    }

    @Override
    public long getDuration() throws ParsingException {
        return -1L;
    }

    @Override
    public String getUploaderName() throws ParsingException {
        return null;
    }

    @Override
    public String getUploaderUrl() throws ParsingException {
        return null;
    }

    @Override
    public boolean isUploaderVerified() throws ParsingException {
        return false;
    }

    @Override
    @Nullable
    public String getTextualUploadDate() throws ParsingException {
        return null;
    }

    @Override
    @Nullable
    public DateWrapper getUploadDate() throws ParsingException {
        return null;
    }
}

