/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors;

import java.util.List;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.jsoup.nodes.Element;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.DateWrapper;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamType;

public class YoutubeFeedInfoItemExtractor
implements StreamInfoItemExtractor {
    private final Element entryElement;

    public YoutubeFeedInfoItemExtractor(Element entryElement) {
        this.entryElement = entryElement;
    }

    @Override
    public StreamType getStreamType() {
        return StreamType.VIDEO_STREAM;
    }

    @Override
    public boolean isAd() {
        return false;
    }

    @Override
    public long getDuration() {
        return -1L;
    }

    @Override
    public long getViewCount() {
        return Long.parseLong(this.entryElement.getElementsByTag("media:statistics").first().attr("views"));
    }

    @Override
    public String getUploaderName() {
        return this.entryElement.select("author > name").first().text();
    }

    @Override
    public String getUploaderUrl() {
        return this.entryElement.select("author > uri").first().text();
    }

    @Override
    public boolean isUploaderVerified() throws ParsingException {
        return false;
    }

    @Override
    @Nullable
    public String getTextualUploadDate() {
        return this.entryElement.getElementsByTag("published").first().text();
    }

    @Override
    @Nullable
    public DateWrapper getUploadDate() throws ParsingException {
        return DateWrapper.fromOffsetDateTime(this.getTextualUploadDate());
    }

    @Override
    public String getName() {
        return this.entryElement.getElementsByTag("title").first().text();
    }

    @Override
    public String getUrl() {
        return this.entryElement.getElementsByTag("link").first().attr("href");
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() {
        int width;
        int height;
        Element thumbnailElement = this.entryElement.getElementsByTag("media:thumbnail").first();
        if (thumbnailElement == null) {
            return List.of();
        }
        String feedThumbnailUrl = thumbnailElement.attr("url");
        if (feedThumbnailUrl.isEmpty()) {
            return List.of();
        }
        String newFeedThumbnailUrl = feedThumbnailUrl.replace("hqdefault", "mqdefault");
        if (newFeedThumbnailUrl.equals(feedThumbnailUrl)) {
            try {
                height = Integer.parseInt(thumbnailElement.attr("height"));
            }
            catch (NumberFormatException e) {
                height = -1;
            }
            try {
                width = Integer.parseInt(thumbnailElement.attr("width"));
            }
            catch (NumberFormatException e) {
                width = -1;
            }
        } else {
            height = 320;
            width = 180;
        }
        return List.of(new Image(newFeedThumbnailUrl, height, width, Image.ResolutionLevel.fromHeight(height)));
    }
}

