/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.JavaScript;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Pair;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Parser;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.jsextractor.JavaScriptExtractor;

final class YoutubeSignatureUtils {
    static final String DEOBFUSCATION_FUNCTION_NAME = "deobfuscate";
    private static final Pattern[] FUNCTION_REGEXES = new Pattern[]{Pattern.compile("\\b(?:[a-zA-Z0-9_$]+)&&\\((?:[a-zA-Z0-9_$]+)=([a-zA-Z0-9_$]{2,})\\((\\d+,)decodeURIComponent\\((?:[a-zA-Z0-9_$]+)\\)\\)"), Pattern.compile("\\b(?:[a-zA-Z0-9_$]+)&&\\((?:[a-zA-Z0-9_$]+)=([a-zA-Z0-9_$]{2,})\\(decodeURIComponent\\((?:[a-zA-Z0-9_$]+)\\)\\)"), Pattern.compile("\\bm=([a-zA-Z0-9$]{2,})\\(decodeURIComponent\\(h\\.s\\)\\)"), Pattern.compile("\\bc&&\\(c=([a-zA-Z0-9$]{2,})\\(decodeURIComponent\\(c\\)\\)"), Pattern.compile("(?:\\b|[^a-zA-Z0-9$])([a-zA-Z0-9$]{2,})\\s*=\\s*function\\(\\s*a\\s*\\)\\s*\\{\\s*a\\s*=\\s*a\\.split\\(\\s*\"\"\\s*\\)"), Pattern.compile("([\\w$]+)\\s*=\\s*function\\((\\w+)\\)\\{\\s*\\2=\\s*\\2\\.split\\(\"\"\\)\\s*;")};
    private static final String STS_REGEX = "signatureTimestamp[=:](\\d+)";
    private static final String DEOBF_FUNC_REGEX_START = "(";
    private static final String DEOBF_FUNC_REGEX_END = "=function\\([a-zA-Z0-9_]+\\)\\{.+?\\})";
    private static final Pattern SIG_DEOBF_GLOBAL_ARRAY_REGEX = Pattern.compile("(var [A-z]=['\"].*['\"].split\\(\"[;{]\"\\))");
    private static final Pattern SIG_DEOBF_HELPER_OBJ_NAME_REGEX = Pattern.compile("[;,]([A-Za-z0-9_$]{2,})\\[..");
    private static final String SIG_DEOBF_HELPER_OBJ_REGEX_START = "(var ";
    private static final String SIG_DEOBF_HELPER_OBJ_REGEX_END = "=\\{(?>.|\\n)+?\\}\\};)";

    private YoutubeSignatureUtils() {
    }

    @Nonnull
    static String getSignatureTimestamp(@Nonnull String javaScriptPlayerCode) throws ParsingException {
        try {
            return Parser.matchGroup1(STS_REGEX, javaScriptPlayerCode);
        }
        catch (ParsingException e) {
            throw new ParsingException("Could not extract signature timestamp from JavaScript code", e);
        }
    }

    @Nonnull
    static String getDeobfuscationCode(@Nonnull String javaScriptPlayerCode) throws ParsingException {
        try {
            String deobfuscationFunction;
            Pair<String, String> deobfuscationFunctionNameAndParams = YoutubeSignatureUtils.getDeobfuscationFunctionNameAndParams(javaScriptPlayerCode);
            String deobfuscationFunctionName = deobfuscationFunctionNameAndParams.getFirst();
            String functionAdditionalParams = deobfuscationFunctionNameAndParams.getSecond();
            try {
                deobfuscationFunction = YoutubeSignatureUtils.getDeobfuscateFunctionWithLexer(javaScriptPlayerCode, deobfuscationFunctionName);
            }
            catch (Exception e) {
                deobfuscationFunction = YoutubeSignatureUtils.getDeobfuscateFunctionWithRegex(javaScriptPlayerCode, deobfuscationFunctionName);
            }
            JavaScript.compileOrThrow(deobfuscationFunction);
            String globalVar = Parser.matchGroup1(SIG_DEOBF_GLOBAL_ARRAY_REGEX, javaScriptPlayerCode);
            String helperObjectName = Parser.matchGroup1(SIG_DEOBF_HELPER_OBJ_NAME_REGEX, deobfuscationFunction);
            String helperObject = YoutubeSignatureUtils.getHelperObject(javaScriptPlayerCode, helperObjectName);
            String callerFunction = "function deobfuscate(a){return " + deobfuscationFunctionName + DEOBF_FUNC_REGEX_START + functionAdditionalParams + "a);}";
            return globalVar + ";" + helperObject + deobfuscationFunction + ";" + callerFunction;
        }
        catch (Exception e) {
            throw new ParsingException("Could not parse deobfuscation function", e);
        }
    }

    @Nonnull
    private static Pair<String, String> getDeobfuscationFunctionNameAndParams(@Nonnull String javaScriptPlayerCode) throws ParsingException {
        try {
            Matcher m = Parser.matchMultiplePatterns(FUNCTION_REGEXES, javaScriptPlayerCode);
            String functionName = m.group(1);
            String functionAdditionalParams = m.groupCount() > 1 ? m.group(2) : "";
            return new Pair<String, String>(functionName, functionAdditionalParams);
        }
        catch (Parser.RegexException e) {
            throw new ParsingException("Could not find deobfuscation function with any of the known patterns", e);
        }
    }

    @Nonnull
    private static String getDeobfuscateFunctionWithLexer(@Nonnull String javaScriptPlayerCode, @Nonnull String deobfuscationFunctionName) throws ParsingException {
        String functionBase = deobfuscationFunctionName + "=function";
        return functionBase + JavaScriptExtractor.matchToClosingBrace(javaScriptPlayerCode, functionBase);
    }

    @Nonnull
    private static String getDeobfuscateFunctionWithRegex(@Nonnull String javaScriptPlayerCode, @Nonnull String deobfuscationFunctionName) throws ParsingException {
        String functionPattern = DEOBF_FUNC_REGEX_START + Pattern.quote(deobfuscationFunctionName) + DEOBF_FUNC_REGEX_END;
        return "var " + Parser.matchGroup1(functionPattern, javaScriptPlayerCode);
    }

    @Nonnull
    private static String getHelperObject(@Nonnull String javaScriptPlayerCode, @Nonnull String helperObjectName) throws ParsingException {
        String helperPattern = SIG_DEOBF_HELPER_OBJ_REGEX_START + Pattern.quote(helperObjectName) + SIG_DEOBF_HELPER_OBJ_REGEX_END;
        return Parser.matchGroup1(helperPattern, javaScriptPlayerCode).replace("\n", "");
    }
}

