/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonBuilder;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.com.grack.nanojson.JsonSink;
import org.watermedia.shaded.com.grack.nanojson.JsonStringWriter;
import org.watermedia.shaded.com.grack.nanojson.JsonWriter;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.jsoup.nodes.Entities;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.NewPipe;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Response;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.AccountTerminatedException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ContentNotAvailableException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ReCaptchaException;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.ContentCountry;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.Localization;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistInfo;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.InnertubeClientRequestInfo;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.AudioTrackType;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.JsonUtils;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Parser;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.RandomStringFromAlphabetGenerator;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public final class YoutubeParsingHelper {
    public static final String YOUTUBEI_V1_URL = "https://www.youtube.com/youtubei/v1/";
    public static final String YOUTUBEI_V1_GAPIS_URL = "https://youtubei.googleapis.com/youtubei/v1/";
    private static final String YOUTUBE_MUSIC_URL = "https://music.youtube.com";
    public static final String DISABLE_PRETTY_PRINT_PARAMETER = "prettyPrint=false";
    public static final String CPN = "cpn";
    public static final String VIDEO_ID = "videoId";
    public static final String CONTENT_CHECK_OK = "contentCheckOk";
    public static final String RACY_CHECK_OK = "racyCheckOk";
    private static String clientVersion;
    private static String youtubeMusicClientVersion;
    private static boolean clientVersionExtracted;
    private static Optional<Boolean> hardcodedClientVersionValid;
    private static final String[] INNERTUBE_CONTEXT_CLIENT_VERSION_REGEXES;
    private static final String[] INITIAL_DATA_REGEXES;
    private static final String CONTENT_PLAYBACK_NONCE_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_";
    private static Random numberGenerator;
    private static final String FEED_BASE_CHANNEL_ID = "https://www.youtube.com/feeds/videos.xml?channel_id=";
    private static final String FEED_BASE_USER = "https://www.youtube.com/feeds/videos.xml?user=";
    private static final Pattern C_WEB_PATTERN;
    private static final Pattern C_WEB_EMBEDDED_PLAYER_PATTERN;
    private static final Pattern C_ANDROID_PATTERN;
    private static final Pattern C_IOS_PATTERN;
    private static final Set<String> GOOGLE_URLS;
    private static final Set<String> INVIDIOUS_URLS;
    private static final Set<String> YOUTUBE_URLS;
    private static boolean consentAccepted;

    private YoutubeParsingHelper() {
    }

    public static boolean isGoogleURL(String url) {
        String cachedUrl = YoutubeParsingHelper.extractCachedUrlIfNeeded(url);
        try {
            URL u = new URL(cachedUrl);
            return GOOGLE_URLS.stream().anyMatch(item -> u.getHost().startsWith((String)item));
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static boolean isYoutubeURL(@Nonnull URL url) {
        return YOUTUBE_URLS.contains(url.getHost().toLowerCase(Locale.ROOT));
    }

    public static boolean isYoutubeServiceURL(@Nonnull URL url) {
        String host = url.getHost();
        return host.equalsIgnoreCase("www.youtube-nocookie.com") || host.equalsIgnoreCase("youtu.be");
    }

    public static boolean isHooktubeURL(@Nonnull URL url) {
        String host = url.getHost();
        return host.equalsIgnoreCase("hooktube.com");
    }

    public static boolean isInvidiousURL(@Nonnull URL url) {
        return INVIDIOUS_URLS.contains(url.getHost().toLowerCase(Locale.ROOT));
    }

    public static boolean isY2ubeURL(@Nonnull URL url) {
        return url.getHost().equalsIgnoreCase("y2u.be");
    }

    public static int parseDurationString(@Nonnull String input) throws ParsingException, NumberFormatException {
        int[] units = new int[]{24, 60, 60, 1};
        String[] splitInput = input.contains(":") ? input.split(":") : input.split("\\.");
        int offset = units.length - splitInput.length;
        if (offset < 0) {
            throw new ParsingException("Error duration string with unknown format: " + input);
        }
        int duration = 0;
        for (int i = 0; i < splitInput.length; ++i) {
            duration = units[i + offset] * (duration + YoutubeParsingHelper.convertDurationToInt(splitInput[i]));
        }
        return duration;
    }

    private static int convertDurationToInt(String input) {
        if (input == null || input.isEmpty()) {
            return 0;
        }
        String clearedInput = Utils.removeNonDigitCharacters(input);
        try {
            return Integer.parseInt(clearedInput);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    @Nonnull
    public static String getFeedUrlFrom(@Nonnull String channelIdOrUser) {
        if (channelIdOrUser.startsWith("user/")) {
            return FEED_BASE_USER + channelIdOrUser.replace("user/", "");
        }
        if (channelIdOrUser.startsWith("channel/")) {
            return FEED_BASE_CHANNEL_ID + channelIdOrUser.replace("channel/", "");
        }
        return FEED_BASE_CHANNEL_ID + channelIdOrUser;
    }

    public static boolean isYoutubeMixId(@Nonnull String playlistId) {
        return playlistId.startsWith("RD");
    }

    public static boolean isYoutubeMyMixId(@Nonnull String playlistId) {
        return playlistId.startsWith("RDMM");
    }

    public static boolean isYoutubeMusicMixId(@Nonnull String playlistId) {
        return playlistId.startsWith("RDAMVM") || playlistId.startsWith("RDCLAK");
    }

    public static boolean isYoutubeGenreMixId(@Nonnull String playlistId) {
        return playlistId.startsWith("RDGMEM");
    }

    @Nonnull
    public static String extractVideoIdFromMixId(String playlistId) throws ParsingException {
        if (Utils.isNullOrEmpty(playlistId)) {
            throw new ParsingException("Video id could not be determined from empty playlist id");
        }
        if (YoutubeParsingHelper.isYoutubeMyMixId(playlistId)) {
            return playlistId.substring(4);
        }
        if (YoutubeParsingHelper.isYoutubeMusicMixId(playlistId)) {
            return playlistId.substring(6);
        }
        if (YoutubeParsingHelper.isYoutubeGenreMixId(playlistId)) {
            throw new ParsingException("Video id could not be determined from genre mix id: " + playlistId);
        }
        if (YoutubeParsingHelper.isYoutubeMixId(playlistId)) {
            if (playlistId.length() != 13) {
                throw new ParsingException("Video id could not be determined from mix id: " + playlistId);
            }
            return playlistId.substring(2);
        }
        throw new ParsingException("Video id could not be determined from playlist id: " + playlistId);
    }

    @Nonnull
    public static PlaylistInfo.PlaylistType extractPlaylistTypeFromPlaylistId(String playlistId) throws ParsingException {
        if (Utils.isNullOrEmpty(playlistId)) {
            throw new ParsingException("Could not extract playlist type from empty playlist id");
        }
        if (YoutubeParsingHelper.isYoutubeMusicMixId(playlistId)) {
            return PlaylistInfo.PlaylistType.MIX_MUSIC;
        }
        if (YoutubeParsingHelper.isYoutubeGenreMixId(playlistId)) {
            return PlaylistInfo.PlaylistType.MIX_GENRE;
        }
        if (YoutubeParsingHelper.isYoutubeMixId(playlistId)) {
            return PlaylistInfo.PlaylistType.MIX_STREAM;
        }
        return PlaylistInfo.PlaylistType.NORMAL;
    }

    public static PlaylistInfo.PlaylistType extractPlaylistTypeFromPlaylistUrl(String playlistUrl) throws ParsingException {
        try {
            return YoutubeParsingHelper.extractPlaylistTypeFromPlaylistId(Utils.getQueryValue(Utils.stringToURL(playlistUrl), "list"));
        }
        catch (MalformedURLException e) {
            throw new ParsingException("Could not extract playlist type from malformed url", e);
        }
    }

    private static JsonObject getInitialData(String html) throws ParsingException {
        try {
            return JsonParser.object().from(Utils.getStringResultFromRegexArray(html, INITIAL_DATA_REGEXES, 1));
        }
        catch (JsonParserException | Parser.RegexException e) {
            throw new ParsingException("Could not get ytInitialData", e);
        }
    }

    public static boolean isHardcodedClientVersionValid() throws IOException, ExtractionException {
        if (hardcodedClientVersionValid.isPresent()) {
            return hardcodedClientVersionValid.get();
        }
        byte[] body = ((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)JsonWriter.string().object()).object("context")).object("client")).value("hl", "en-GB")).value("gl", "GB")).value("clientName", "WEB")).value("clientVersion", "2.20260120.01.00")).value("platform", "DESKTOP")).value("utcOffsetMinutes", 0)).end()).object("request")).array("internalExperimentFlags")).end()).value("useSsl", true)).end()).object("user")).value("lockedSafetyMode", false)).end()).end()).value("fetchLiveState", true)).end()).done().getBytes(StandardCharsets.UTF_8);
        Map<String, List<String>> headers = YoutubeParsingHelper.getClientHeaders("1", "2.20260120.01.00");
        Response response = NewPipe.getDownloader().postWithContentTypeJson("https://www.youtube.com/youtubei/v1/guide?prettyPrint=false", headers, body);
        String responseBody = response.responseBody();
        int responseCode = response.responseCode();
        hardcodedClientVersionValid = Optional.of(responseBody.length() > 5000 && responseCode == 200);
        return hardcodedClientVersionValid.get();
    }

    private static void extractClientVersionFromSwJs() throws IOException, ExtractionException {
        if (clientVersionExtracted) {
            return;
        }
        String url = "https://www.youtube.com/sw.js";
        Map<String, List<String>> headers = YoutubeParsingHelper.getOriginReferrerHeaders("https://www.youtube.com");
        String response = NewPipe.getDownloader().get("https://www.youtube.com/sw.js", headers).responseBody();
        try {
            clientVersion = Utils.getStringResultFromRegexArray(response, INNERTUBE_CONTEXT_CLIENT_VERSION_REGEXES, 1);
        }
        catch (Parser.RegexException e) {
            throw new ParsingException("Could not extract YouTube WEB InnerTube client version from sw.js", e);
        }
        clientVersionExtracted = true;
    }

    private static void extractClientVersionFromHtmlSearchResultsPage() throws IOException, ExtractionException {
        if (clientVersionExtracted) {
            return;
        }
        String url = "https://www.youtube.com/results?search_query=&ucbcb=1";
        String html = NewPipe.getDownloader().get("https://www.youtube.com/results?search_query=&ucbcb=1", YoutubeParsingHelper.getCookieHeader()).responseBody();
        JsonObject initialData = YoutubeParsingHelper.getInitialData(html);
        JsonArray serviceTrackingParams = initialData.getObject("responseContext").getArray("serviceTrackingParams");
        Stream<JsonObject> serviceTrackingParamsStream = serviceTrackingParams.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast);
        clientVersion = YoutubeParsingHelper.getClientVersionFromServiceTrackingParam(serviceTrackingParamsStream, "CSI", "cver");
        if (clientVersion == null) {
            try {
                clientVersion = Utils.getStringResultFromRegexArray(html, INNERTUBE_CONTEXT_CLIENT_VERSION_REGEXES, 1);
            }
            catch (Parser.RegexException regexException) {
                // empty catch block
            }
        }
        if (Utils.isNullOrEmpty(clientVersion)) {
            clientVersion = YoutubeParsingHelper.getClientVersionFromServiceTrackingParam(serviceTrackingParamsStream, "ECATCHER", "client.version");
        }
        if (clientVersion == null) {
            throw new ParsingException("Could not extract YouTube WEB InnerTube client version from HTML search results page");
        }
        clientVersionExtracted = true;
    }

    @Nullable
    private static String getClientVersionFromServiceTrackingParam(@Nonnull Stream<JsonObject> serviceTrackingParamsStream, @Nonnull String serviceName, @Nonnull String clientVersionKey) {
        return serviceTrackingParamsStream.filter(serviceTrackingParam -> serviceTrackingParam.getString("service", "").equals(serviceName)).flatMap(serviceTrackingParam -> serviceTrackingParam.getArray("params").stream()).filter(JsonObject.class::isInstance).map(JsonObject.class::cast).filter(param -> param.getString("key", "").equals(clientVersionKey)).map(param -> param.getString("value")).filter(paramValue -> !Utils.isNullOrEmpty(paramValue)).findFirst().orElse(null);
    }

    public static String getClientVersion() throws IOException, ExtractionException {
        if (!Utils.isNullOrEmpty(clientVersion)) {
            return clientVersion;
        }
        try {
            YoutubeParsingHelper.extractClientVersionFromSwJs();
        }
        catch (Exception e) {
            YoutubeParsingHelper.extractClientVersionFromHtmlSearchResultsPage();
        }
        if (clientVersionExtracted) {
            return clientVersion;
        }
        if (YoutubeParsingHelper.isHardcodedClientVersionValid()) {
            clientVersion = "2.20260120.01.00";
            return clientVersion;
        }
        throw new ExtractionException("Could not get YouTube WEB client version");
    }

    public static void resetClientVersion() {
        clientVersion = null;
        clientVersionExtracted = false;
    }

    public static void setNumberGenerator(Random random) {
        numberGenerator = random;
    }

    public static boolean isHardcodedYoutubeMusicClientVersionValid() throws IOException, ReCaptchaException {
        String url = "https://music.youtube.com/youtubei/v1/music/get_search_suggestions?prettyPrint=false";
        byte[] json = ((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)JsonWriter.string().object()).object("context")).object("client")).value("clientName", "WEB_REMIX")).value("clientVersion", "1.20260121.03.00")).value("hl", "en-GB")).value("gl", "GB")).value("platform", "DESKTOP")).value("utcOffsetMinutes", 0)).end()).object("request")).array("internalExperimentFlags")).end()).value("useSsl", true)).end()).object("user")).value("lockedSafetyMode", false)).end()).end()).value("input", "")).end()).done().getBytes(StandardCharsets.UTF_8);
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>(YoutubeParsingHelper.getOriginReferrerHeaders(YOUTUBE_MUSIC_URL));
        headers.putAll(YoutubeParsingHelper.getClientHeaders("67", "2.20260120.01.00"));
        Response response = NewPipe.getDownloader().postWithContentTypeJson("https://music.youtube.com/youtubei/v1/music/get_search_suggestions?prettyPrint=false", headers, json);
        return response.responseBody().length() > 500 && response.responseCode() == 200;
    }

    public static String getYoutubeMusicClientVersion() throws IOException, ReCaptchaException, Parser.RegexException {
        if (!Utils.isNullOrEmpty(youtubeMusicClientVersion)) {
            return youtubeMusicClientVersion;
        }
        if (YoutubeParsingHelper.isHardcodedYoutubeMusicClientVersionValid()) {
            youtubeMusicClientVersion = "1.20260121.03.00";
            return youtubeMusicClientVersion;
        }
        try {
            String url = "https://music.youtube.com/sw.js";
            Map<String, List<String>> headers = YoutubeParsingHelper.getOriginReferrerHeaders(YOUTUBE_MUSIC_URL);
            String response = NewPipe.getDownloader().get("https://music.youtube.com/sw.js", headers).responseBody();
            youtubeMusicClientVersion = Utils.getStringResultFromRegexArray(response, INNERTUBE_CONTEXT_CLIENT_VERSION_REGEXES, 1);
        }
        catch (Exception e) {
            String url = "https://music.youtube.com/?ucbcb=1";
            String html = NewPipe.getDownloader().get("https://music.youtube.com/?ucbcb=1", YoutubeParsingHelper.getCookieHeader()).responseBody();
            youtubeMusicClientVersion = Utils.getStringResultFromRegexArray(html, INNERTUBE_CONTEXT_CLIENT_VERSION_REGEXES, 1);
        }
        return youtubeMusicClientVersion;
    }

    @Nullable
    public static String getUrlFromNavigationEndpoint(@Nonnull JsonObject navigationEndpoint) {
        JsonObject metadata;
        if (navigationEndpoint.has("urlEndpoint")) {
            String internUrl = navigationEndpoint.getObject("urlEndpoint").getString("url");
            if (internUrl.startsWith("https://www.youtube.com/redirect?")) {
                internUrl = internUrl.substring(23);
            }
            if (internUrl.startsWith("/redirect?")) {
                String[] params;
                internUrl = internUrl.substring(10);
                for (String param : params = internUrl.split("&")) {
                    if (!param.split("=")[0].equals("q")) continue;
                    return Utils.decodeUrlUtf8(param.split("=")[1]);
                }
            } else {
                if (internUrl.startsWith("http")) {
                    return internUrl;
                }
                if (internUrl.startsWith("/channel") || internUrl.startsWith("/user") || internUrl.startsWith("/watch")) {
                    return "https://www.youtube.com" + internUrl;
                }
            }
        }
        if (navigationEndpoint.has("browseEndpoint")) {
            JsonObject browseEndpoint = navigationEndpoint.getObject("browseEndpoint");
            String canonicalBaseUrl = browseEndpoint.getString("canonicalBaseUrl");
            String browseId = browseEndpoint.getString("browseId");
            if (browseId != null) {
                if (browseId.startsWith("UC")) {
                    return "https://www.youtube.com/channel/" + browseId;
                }
                if (browseId.startsWith("VL")) {
                    return "https://www.youtube.com/playlist?list=" + browseId.substring(2);
                }
            }
            if (!Utils.isNullOrEmpty(canonicalBaseUrl)) {
                return "https://www.youtube.com" + canonicalBaseUrl;
            }
        }
        if (navigationEndpoint.has("watchEndpoint")) {
            StringBuilder url = new StringBuilder();
            url.append("https://www.youtube.com/watch?v=").append(navigationEndpoint.getObject("watchEndpoint").getString(VIDEO_ID));
            if (navigationEndpoint.getObject("watchEndpoint").has("playlistId")) {
                url.append("&list=").append(navigationEndpoint.getObject("watchEndpoint").getString("playlistId"));
            }
            if (navigationEndpoint.getObject("watchEndpoint").has("startTimeSeconds")) {
                url.append("&t=").append(navigationEndpoint.getObject("watchEndpoint").getInt("startTimeSeconds"));
            }
            return url.toString();
        }
        if (navigationEndpoint.has("watchPlaylistEndpoint")) {
            return "https://www.youtube.com/playlist?list=" + navigationEndpoint.getObject("watchPlaylistEndpoint").getString("playlistId");
        }
        if (navigationEndpoint.has("showDialogCommand")) {
            try {
                JsonArray listItems = JsonUtils.getArray(navigationEndpoint, "showDialogCommand.panelLoadingStrategy.inlineContent.dialogViewModel.customContent.listViewModel.listItems");
                JsonObject command = JsonUtils.getObject(listItems.getObject(0), "listItemViewModel.rendererContext.commandContext.onTap.innertubeCommand");
                return YoutubeParsingHelper.getUrlFromNavigationEndpoint(command);
            }
            catch (ParsingException listItems) {
                // empty catch block
            }
        }
        if (navigationEndpoint.has("org.watermedia.shaded.commandMetadata") && (metadata = navigationEndpoint.getObject("org.watermedia.shaded.commandMetadata").getObject("webCommandMetadata")).has("url")) {
            return "https://www.youtube.com" + metadata.getString("url");
        }
        return null;
    }

    @Nullable
    public static String getTextFromObject(JsonObject textObject, boolean html) {
        if (Utils.isNullOrEmpty(textObject)) {
            return null;
        }
        if (textObject.has("simpleText")) {
            return textObject.getString("simpleText");
        }
        JsonArray runs = textObject.getArray("runs");
        if (runs.isEmpty()) {
            return null;
        }
        StringBuilder textBuilder = new StringBuilder();
        for (Object o : runs) {
            JsonObject run = (JsonObject)o;
            Object text = run.getString("text");
            if (html) {
                boolean strikethrough;
                String url;
                if (run.has("navigationEndpoint") && !Utils.isNullOrEmpty(url = YoutubeParsingHelper.getUrlFromNavigationEndpoint(run.getObject("navigationEndpoint")))) {
                    text = "<a href=\"" + Entities.escape(url) + "\">" + Entities.escape((String)text) + "</a>";
                }
                boolean bold = run.has("bold") && run.getBoolean("bold");
                boolean italic = run.has("italics") && run.getBoolean("italics");
                boolean bl = strikethrough = run.has("strikethrough") && run.getBoolean("strikethrough");
                if (bold) {
                    textBuilder.append("<b>");
                }
                if (italic) {
                    textBuilder.append("<i>");
                }
                if (strikethrough) {
                    textBuilder.append("<s>");
                }
                textBuilder.append((String)text);
                if (strikethrough) {
                    textBuilder.append("</s>");
                }
                if (italic) {
                    textBuilder.append("</i>");
                }
                if (!bold) continue;
                textBuilder.append("</b>");
                continue;
            }
            textBuilder.append((String)text);
        }
        String text = textBuilder.toString();
        if (html) {
            text = text.replaceAll("\\n", "<br>");
            text = text.replaceAll(" {2}", " &nbsp;");
        }
        return text;
    }

    @Nonnull
    public static String getTextFromObjectOrThrow(JsonObject textObject, String error) throws ParsingException {
        String result = YoutubeParsingHelper.getTextFromObject(textObject);
        if (result == null) {
            throw new ParsingException("Could not extract text: " + error);
        }
        return result;
    }

    @Nullable
    public static String getTextFromObject(JsonObject textObject) {
        return YoutubeParsingHelper.getTextFromObject(textObject, false);
    }

    @Nullable
    public static String getUrlFromObject(JsonObject textObject) {
        if (Utils.isNullOrEmpty(textObject)) {
            return null;
        }
        JsonArray runs = textObject.getArray("runs");
        if (runs.isEmpty()) {
            return null;
        }
        for (Object textPart : runs) {
            String url = YoutubeParsingHelper.getUrlFromNavigationEndpoint(((JsonObject)textPart).getObject("navigationEndpoint"));
            if (Utils.isNullOrEmpty(url)) continue;
            return url;
        }
        return null;
    }

    @Nullable
    public static String getTextAtKey(@Nonnull JsonObject jsonObject, String theKey) {
        if (jsonObject.isString(theKey)) {
            return jsonObject.getString(theKey);
        }
        return YoutubeParsingHelper.getTextFromObject(jsonObject.getObject(theKey));
    }

    public static String fixThumbnailUrl(@Nonnull String thumbnailUrl) {
        Object result = thumbnailUrl;
        if (((String)result).startsWith("//")) {
            result = ((String)result).substring(2);
        }
        if (((String)result).startsWith("http://")) {
            result = Utils.replaceHttpWithHttps((String)result);
        } else if (!((String)result).startsWith("https://")) {
            result = "https://" + (String)result;
        }
        return result;
    }

    @Nonnull
    public static List<Image> getThumbnailsFromInfoItem(@Nonnull JsonObject infoItem) throws ParsingException {
        try {
            return YoutubeParsingHelper.getImagesFromThumbnailsArray(infoItem.getObject("thumbnail").getArray("thumbnails"));
        }
        catch (Exception e) {
            throw new ParsingException("Could not get thumbnails from InfoItem", e);
        }
    }

    @Nonnull
    public static List<Image> getImagesFromThumbnailsArray(@Nonnull JsonArray thumbnails) {
        return thumbnails.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).filter(thumbnail -> !Utils.isNullOrEmpty(thumbnail.getString("url"))).map(thumbnail -> {
            int height = thumbnail.getInt("height", -1);
            return new Image(YoutubeParsingHelper.fixThumbnailUrl(thumbnail.getString("url")), height, thumbnail.getInt("width", -1), Image.ResolutionLevel.fromHeight(height));
        }).collect(Collectors.toUnmodifiableList());
    }

    @Nonnull
    public static String getValidJsonResponseBody(@Nonnull Response response) throws ParsingException, MalformedURLException {
        String path;
        if (response.responseCode() == 404) {
            throw new ContentNotAvailableException("Not found (\"" + response.responseCode() + " " + response.responseMessage() + "\")");
        }
        String responseBody = response.responseBody();
        if (responseBody.length() < 50) {
            throw new ParsingException("JSON response is too short");
        }
        URL latestUrl = new URL(response.latestUrl());
        if (latestUrl.getHost().equalsIgnoreCase("www.youtube.com") && ((path = latestUrl.getPath()).equalsIgnoreCase("/oops") || path.equalsIgnoreCase("/error"))) {
            throw new ContentNotAvailableException("Content unavailable");
        }
        String responseContentType = response.getHeader("Content-Type");
        if (responseContentType != null && responseContentType.toLowerCase().contains("text/html")) {
            throw new ParsingException("Got HTML document, expected JSON response (latest url was: \"" + response.latestUrl() + "\")");
        }
        return responseBody;
    }

    public static JsonObject getJsonPostResponse(@Nonnull String endpoint, byte[] body, @Nonnull Localization localization) throws IOException, ExtractionException {
        Map<String, List<String>> headers = YoutubeParsingHelper.getYouTubeHeaders();
        return JsonUtils.toJsonObject(YoutubeParsingHelper.getValidJsonResponseBody(NewPipe.getDownloader().postWithContentTypeJson(YOUTUBEI_V1_URL + endpoint + "?prettyPrint=false", headers, body, localization)));
    }

    public static JsonObject getJsonPostResponse(@Nonnull String endpoint, @Nonnull List<String> queryParameters, byte[] body, @Nonnull Localization localization) throws IOException, ExtractionException {
        Map<String, List<String>> headers = YoutubeParsingHelper.getYouTubeHeaders();
        Object queryParametersString = queryParameters.isEmpty() ? "?prettyPrint=false" : "?" + String.join((CharSequence)"&", queryParameters) + "&prettyPrint=false";
        return JsonUtils.toJsonObject(YoutubeParsingHelper.getValidJsonResponseBody(NewPipe.getDownloader().postWithContentTypeJson(YOUTUBEI_V1_URL + endpoint + (String)queryParametersString, headers, body, localization)));
    }

    @Nonnull
    public static JsonBuilder<JsonObject> prepareDesktopJsonBuilder(@Nonnull Localization localization, @Nonnull ContentCountry contentCountry) throws IOException, ExtractionException {
        return ((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)JsonObject.builder().object("context")).object("client")).value("hl", localization.getLocalizationCode())).value("gl", contentCountry.getCountryCode())).value("clientName", "WEB")).value("clientVersion", YoutubeParsingHelper.getClientVersion())).value("originalUrl", "https://www.youtube.com")).value("platform", "DESKTOP")).value("utcOffsetMinutes", 0)).end()).object("request")).array("internalExperimentFlags")).end()).value("useSsl", true)).end()).object("user")).value("lockedSafetyMode", false)).end()).end();
    }

    @Nonnull
    public static String getAndroidUserAgent(@Nullable Localization localization) {
        return "org/watermedia/shaded/com.google.android.youtube/21.03.36 (Linux; U; Android 15; " + (localization != null ? localization : Localization.DEFAULT).getCountryCode() + ") gzip";
    }

    @Nonnull
    public static String getIosUserAgent(@Nullable Localization localization) {
        return "org/watermedia/shaded/com.google.ios.youtube/21.03.2(iPhone16,2; U; CPU iOS 18_7_2 like Mac OS X; " + (localization != null ? localization : Localization.DEFAULT).getCountryCode() + ")";
    }

    @Nonnull
    public static Map<String, List<String>> getYoutubeMusicHeaders() {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>(YoutubeParsingHelper.getOriginReferrerHeaders(YOUTUBE_MUSIC_URL));
        headers.putAll(YoutubeParsingHelper.getClientHeaders("67", youtubeMusicClientVersion));
        return headers;
    }

    public static Map<String, List<String>> getYouTubeHeaders() throws ExtractionException, IOException {
        Map<String, List<String>> headers = YoutubeParsingHelper.getClientInfoHeaders();
        headers.put("Cookie", List.of(YoutubeParsingHelper.generateConsentCookie()));
        return headers;
    }

    public static Map<String, List<String>> getClientInfoHeaders() throws ExtractionException, IOException {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>(YoutubeParsingHelper.getOriginReferrerHeaders("https://www.youtube.com"));
        headers.putAll(YoutubeParsingHelper.getClientHeaders("1", YoutubeParsingHelper.getClientVersion()));
        return headers;
    }

    public static Map<String, List<String>> getOriginReferrerHeaders(@Nonnull String url) {
        List<String> urlList = List.of(url);
        return Map.of("Origin", urlList, "Referer", urlList);
    }

    public static Map<String, List<String>> getClientHeaders(@Nonnull String name, @Nonnull String version) {
        return Map.of("X-YouTube-Client-Name", List.of(name), "X-YouTube-Client-Version", List.of(version));
    }

    public static Map<String, List<String>> getCookieHeader() {
        return Map.of("Cookie", List.of(YoutubeParsingHelper.generateConsentCookie()));
    }

    @Nonnull
    public static String generateConsentCookie() {
        return "SOCS=" + (YoutubeParsingHelper.isConsentAccepted() ? "CAISAiAD" : "CAE=");
    }

    public static String extractCookieValue(String cookieName, @Nonnull Response response) {
        List<String> cookies = response.responseHeaders().get("set-cookie");
        if (cookies == null) {
            return "";
        }
        String result = "";
        for (String cookie : cookies) {
            int startIndex = cookie.indexOf(cookieName);
            if (startIndex == -1) continue;
            result = cookie.substring(startIndex + cookieName.length() + "=".length(), cookie.indexOf(";", startIndex));
        }
        return result;
    }

    public static void defaultAlertsCheck(@Nonnull JsonObject initialData) throws ParsingException {
        JsonArray alerts = initialData.getArray("alerts");
        if (!Utils.isNullOrEmpty(alerts)) {
            JsonObject alertRenderer = alerts.getObject(0).getObject("alertRenderer");
            String alertText = YoutubeParsingHelper.getTextFromObject(alertRenderer.getObject("text"));
            String alertType = alertRenderer.getString("type", "");
            if (alertType.equalsIgnoreCase("ERROR")) {
                if (alertText != null && (alertText.contains("This account has been terminated") || alertText.contains("This channel was removed"))) {
                    if (alertText.matches(".*violat(ed|ion|ing).*") || alertText.contains("infringement")) {
                        throw new AccountTerminatedException(alertText, AccountTerminatedException.Reason.VIOLATION);
                    }
                    throw new AccountTerminatedException(alertText);
                }
                throw new ContentNotAvailableException("Got error: \"" + alertText + "\"");
            }
        }
    }

    public static String extractCachedUrlIfNeeded(String url) {
        if (url == null) {
            return null;
        }
        if (url.contains("webcache.googleusercontent.com")) {
            return url.split("cache:")[1];
        }
        return url;
    }

    public static boolean isVerified(JsonArray badges) {
        if (Utils.isNullOrEmpty(badges)) {
            return false;
        }
        for (Object badge : badges) {
            String style = ((JsonObject)badge).getObject("metadataBadgeRenderer").getString("style");
            if (style == null || !style.equals("BADGE_STYLE_TYPE_VERIFIED") && !style.equals("BADGE_STYLE_TYPE_VERIFIED_ARTIST")) continue;
            return true;
        }
        return false;
    }

    public static boolean hasArtistOrVerifiedIconBadgeAttachment(@Nonnull JsonArray attachmentRuns) {
        return attachmentRuns.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).anyMatch(attachmentRun -> attachmentRun.getObject("element").getObject("type").getObject("imageType").getObject("image").getArray("sources").stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).anyMatch(source -> {
            String imageName = source.getObject("clientResource").getString("imageName");
            return "CHECK_CIRCLE_FILLED".equals(imageName) || "AUDIO_BADGE".equals(imageName) || "MUSIC_FILLED".equals(imageName);
        }));
    }

    @Nonnull
    public static String generateContentPlaybackNonce() {
        return RandomStringFromAlphabetGenerator.generate(CONTENT_PLAYBACK_NONCE_ALPHABET, 16, numberGenerator);
    }

    @Nonnull
    public static String generateTParameter() {
        return RandomStringFromAlphabetGenerator.generate(CONTENT_PLAYBACK_NONCE_ALPHABET, 12, numberGenerator);
    }

    public static boolean isWebStreamingUrl(@Nonnull String url) {
        return Parser.isMatch(C_WEB_PATTERN, url);
    }

    public static boolean isWebEmbeddedPlayerStreamingUrl(@Nonnull String url) {
        return Parser.isMatch(C_WEB_EMBEDDED_PLAYER_PATTERN, url);
    }

    public static boolean isAndroidStreamingUrl(@Nonnull String url) {
        return Parser.isMatch(C_ANDROID_PATTERN, url);
    }

    public static boolean isIosStreamingUrl(@Nonnull String url) {
        return Parser.isMatch(C_IOS_PATTERN, url);
    }

    public static void setConsentAccepted(boolean accepted) {
        consentAccepted = accepted;
    }

    public static boolean isConsentAccepted() {
        return consentAccepted;
    }

    @Nullable
    public static AudioTrackType extractAudioTrackType(String streamUrl) {
        String xtags;
        try {
            xtags = Utils.getQueryValue(new URL(streamUrl), "xtags");
        }
        catch (MalformedURLException e) {
            return null;
        }
        if (xtags == null) {
            return null;
        }
        String atype = null;
        for (String param : xtags.split(":")) {
            String[] kv = param.split("=", 2);
            if (kv.length <= 1 || !kv[0].equals("acont")) continue;
            atype = kv[1];
            break;
        }
        if (atype == null) {
            return null;
        }
        switch (atype) {
            case "original": {
                return AudioTrackType.ORIGINAL;
            }
            case "dubbed": 
            case "dubbed-auto": {
                return AudioTrackType.DUBBED;
            }
            case "descriptive": {
                return AudioTrackType.DESCRIPTIVE;
            }
            case "secondary": {
                return AudioTrackType.SECONDARY;
            }
        }
        return null;
    }

    @Nonnull
    public static String getVisitorDataFromInnertube(@Nonnull InnertubeClientRequestInfo innertubeClientRequestInfo, @Nonnull Localization localization, @Nonnull ContentCountry contentCountry, @Nonnull Map<String, List<String>> httpHeaders, @Nonnull String innertubeDomainAndVersionEndpoint, @Nullable String embedUrl, boolean useGuideEndpoint) throws IOException, ExtractionException {
        JsonBuilder<JsonObject> builder = YoutubeParsingHelper.prepareJsonBuilder(localization, contentCountry, innertubeClientRequestInfo, embedUrl);
        byte[] body = JsonWriter.string(builder.done()).getBytes(StandardCharsets.UTF_8);
        String visitorData = JsonUtils.toJsonObject(YoutubeParsingHelper.getValidJsonResponseBody(NewPipe.getDownloader().postWithContentTypeJson(innertubeDomainAndVersionEndpoint + (useGuideEndpoint ? "guide" : "visitor_id") + "?prettyPrint=false", httpHeaders, body))).getObject("responseContext").getString("visitorData");
        if (Utils.isNullOrEmpty(visitorData)) {
            throw new ParsingException("Could not get visitorData");
        }
        return visitorData;
    }

    @Nonnull
    public static JsonBuilder<JsonObject> prepareJsonBuilder(@Nonnull Localization localization, @Nonnull ContentCountry contentCountry, @Nonnull InnertubeClientRequestInfo innertubeClientRequestInfo, @Nullable String embedUrl) {
        JsonSink builder = ((JsonBuilder)((JsonBuilder)((JsonBuilder)JsonObject.builder().object("context")).object("client")).value("clientName", innertubeClientRequestInfo.clientInfo.clientName)).value("clientVersion", innertubeClientRequestInfo.clientInfo.clientVersion);
        if (innertubeClientRequestInfo.clientInfo.clientScreen != null) {
            ((JsonBuilder)builder).value("clientScreen", innertubeClientRequestInfo.clientInfo.clientScreen);
        }
        if (innertubeClientRequestInfo.deviceInfo.platform != null) {
            ((JsonBuilder)builder).value("platform", innertubeClientRequestInfo.deviceInfo.platform);
        }
        if (innertubeClientRequestInfo.clientInfo.visitorData != null) {
            ((JsonBuilder)builder).value("visitorData", innertubeClientRequestInfo.clientInfo.visitorData);
        }
        if (innertubeClientRequestInfo.deviceInfo.deviceMake != null) {
            ((JsonBuilder)builder).value("deviceMake", innertubeClientRequestInfo.deviceInfo.deviceMake);
        }
        if (innertubeClientRequestInfo.deviceInfo.deviceModel != null) {
            ((JsonBuilder)builder).value("deviceModel", innertubeClientRequestInfo.deviceInfo.deviceModel);
        }
        if (innertubeClientRequestInfo.deviceInfo.osName != null) {
            ((JsonBuilder)builder).value("osName", innertubeClientRequestInfo.deviceInfo.osName);
        }
        if (innertubeClientRequestInfo.deviceInfo.osVersion != null) {
            ((JsonBuilder)builder).value("osVersion", innertubeClientRequestInfo.deviceInfo.osVersion);
        }
        if (innertubeClientRequestInfo.deviceInfo.androidSdkVersion > 0) {
            ((JsonBuilder)builder).value("androidSdkVersion", innertubeClientRequestInfo.deviceInfo.androidSdkVersion);
        }
        ((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)builder).value("hl", localization.getLocalizationCode())).value("gl", contentCountry.getCountryCode())).value("utcOffsetMinutes", 0)).end();
        if (embedUrl != null) {
            ((JsonBuilder)((JsonBuilder)((JsonBuilder)builder).object("thirdParty")).value("embedUrl", embedUrl)).end();
        }
        ((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)builder).object("request")).array("internalExperimentFlags")).end()).value("useSsl", true)).end()).object("user")).value("lockedSafetyMode", false)).end()).end();
        return builder;
    }

    @Nullable
    public static JsonObject getFirstCollaborator(JsonObject navigationEndpoint) throws ParsingException {
        try {
            JsonArray listItems = JsonUtils.getArray(navigationEndpoint, "showDialogCommand.panelLoadingStrategy.inlineContent.dialogViewModel.customContent.listViewModel.listItems");
            return listItems.getObject(0).getObject("listItemViewModel");
        }
        catch (ParsingException e) {
            return null;
        }
    }

    static {
        clientVersionExtracted = false;
        hardcodedClientVersionValid = Optional.empty();
        INNERTUBE_CONTEXT_CLIENT_VERSION_REGEXES = new String[]{"INNERTUBE_CONTEXT_CLIENT_VERSION\":\"([0-9\\.]+?)\"", "innertube_context_client_version\":\"([0-9\\.]+?)\"", "client.version=([0-9\\.]+)"};
        INITIAL_DATA_REGEXES = new String[]{"window\\[\"ytInitialData\"\\]\\s*=\\s*(\\{.*?\\});", "var\\s*ytInitialData\\s*=\\s*(\\{.*?\\});"};
        numberGenerator = new Random();
        C_WEB_PATTERN = Pattern.compile("&c=WEB");
        C_WEB_EMBEDDED_PLAYER_PATTERN = Pattern.compile("&c=WEB_EMBEDDED_PLAYER");
        C_ANDROID_PATTERN = Pattern.compile("&c=ANDROID");
        C_IOS_PATTERN = Pattern.compile("&c=IOS");
        GOOGLE_URLS = Set.of("google.", "m.google.", "www.google.");
        INVIDIOUS_URLS = Set.of("invidio.us", "dev.invidio.us", "www.invidio.us", "redirect.invidious.io", "invidious.snopyta.org", "yewtu.be", "tube.connect.cafe", "tubus.eduvid.org", "invidious.kavin.rocks", "invidious.site", "invidious-us.kavin.rocks", "piped.kavin.rocks", "vid.mint.lgbt", "invidiou.site", "invidious.fdn.fr", "invidious.048596.xyz", "invidious.zee.li", "vid.puffyan.us", "ytprivate.com", "invidious.namazso.eu", "invidious.silkky.cloud", "ytb.trom.tf", "invidious.exonip.de", "inv.riverside.rocks", "invidious.blamefran.net", "y.com.cm", "invidious.moomoo.me", "yt.cyberhost.uk");
        YOUTUBE_URLS = Set.of("youtube.com", "www.youtube.com", "m.youtube.com", "music.youtube.com");
        consentAccepted = false;
    }
}

