/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.MetaInfo;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Description;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public final class YoutubeMetaInfoHelper {
    private YoutubeMetaInfoHelper() {
    }

    @Nonnull
    public static List<MetaInfo> getMetaInfo(@Nonnull JsonArray contents) throws ParsingException {
        ArrayList<MetaInfo> metaInfo = new ArrayList<MetaInfo>();
        for (Object content : contents) {
            JsonObject resultObject = (JsonObject)content;
            if (!resultObject.has("itemSectionRenderer")) continue;
            for (Object sectionContentObject : resultObject.getObject("itemSectionRenderer").getArray("contents")) {
                JsonObject sectionContent = (JsonObject)sectionContentObject;
                if (sectionContent.has("infoPanelContentRenderer")) {
                    metaInfo.add(YoutubeMetaInfoHelper.getInfoPanelContent(sectionContent.getObject("infoPanelContentRenderer")));
                }
                if (sectionContent.has("clarificationRenderer")) {
                    metaInfo.add(YoutubeMetaInfoHelper.getClarificationRenderer(sectionContent.getObject("clarificationRenderer")));
                }
                if (!sectionContent.has("emergencyOneboxRenderer")) continue;
                YoutubeMetaInfoHelper.getEmergencyOneboxRenderer(sectionContent.getObject("emergencyOneboxRenderer"), metaInfo::add);
            }
        }
        return metaInfo;
    }

    @Nonnull
    private static MetaInfo getInfoPanelContent(@Nonnull JsonObject infoPanelContentRenderer) throws ParsingException {
        MetaInfo metaInfo = new MetaInfo();
        StringBuilder sb = new StringBuilder();
        for (Object paragraph : infoPanelContentRenderer.getArray("paragraphs")) {
            if (sb.length() != 0) {
                sb.append("<br>");
            }
            sb.append(YoutubeParsingHelper.getTextFromObject((JsonObject)paragraph));
        }
        metaInfo.setContent(new Description(sb.toString(), 1));
        if (infoPanelContentRenderer.has("sourceEndpoint")) {
            String metaInfoLinkUrl = YoutubeParsingHelper.getUrlFromNavigationEndpoint(infoPanelContentRenderer.getObject("sourceEndpoint"));
            try {
                metaInfo.addUrl(new URL(Objects.requireNonNull(YoutubeParsingHelper.extractCachedUrlIfNeeded(metaInfoLinkUrl))));
            }
            catch (NullPointerException | MalformedURLException e) {
                throw new ParsingException("Could not get metadata info URL", e);
            }
            String metaInfoLinkText = YoutubeParsingHelper.getTextFromObject(infoPanelContentRenderer.getObject("inlineSource"));
            if (Utils.isNullOrEmpty(metaInfoLinkText)) {
                throw new ParsingException("Could not get metadata info link text.");
            }
            metaInfo.addUrlText(metaInfoLinkText);
        }
        return metaInfo;
    }

    @Nonnull
    private static MetaInfo getClarificationRenderer(@Nonnull JsonObject clarificationRenderer) throws ParsingException {
        String url;
        MetaInfo metaInfo = new MetaInfo();
        String title = YoutubeParsingHelper.getTextFromObject(clarificationRenderer.getObject("contentTitle"));
        String text = YoutubeParsingHelper.getTextFromObject(clarificationRenderer.getObject("text"));
        if (title == null || text == null) {
            throw new ParsingException("Could not extract clarification renderer content");
        }
        metaInfo.setTitle(title);
        metaInfo.setContent(new Description(text, 3));
        if (clarificationRenderer.has("actionButton")) {
            JsonObject actionButton = clarificationRenderer.getObject("actionButton").getObject("buttonRenderer");
            try {
                String url2 = YoutubeParsingHelper.getUrlFromNavigationEndpoint(actionButton.getObject("org.watermedia.shaded.command"));
                metaInfo.addUrl(new URL(Objects.requireNonNull(YoutubeParsingHelper.extractCachedUrlIfNeeded(url2))));
            }
            catch (NullPointerException | MalformedURLException e) {
                throw new ParsingException("Could not get metadata info URL", e);
            }
            String metaInfoLinkText = YoutubeParsingHelper.getTextFromObject(actionButton.getObject("text"));
            if (Utils.isNullOrEmpty(metaInfoLinkText)) {
                throw new ParsingException("Could not get metadata info link text.");
            }
            metaInfo.addUrlText(metaInfoLinkText);
        }
        if (clarificationRenderer.has("secondaryEndpoint") && clarificationRenderer.has("secondarySource") && (url = YoutubeParsingHelper.getUrlFromNavigationEndpoint(clarificationRenderer.getObject("secondaryEndpoint"))) != null && !YoutubeParsingHelper.isGoogleURL(url)) {
            try {
                metaInfo.addUrl(new URL(url));
                String description = YoutubeParsingHelper.getTextFromObject(clarificationRenderer.getObject("secondarySource"));
                metaInfo.addUrlText(description == null ? url : description);
            }
            catch (MalformedURLException e) {
                throw new ParsingException("Could not get metadata info secondary URL", e);
            }
        }
        return metaInfo;
    }

    private static void getEmergencyOneboxRenderer(@Nonnull JsonObject emergencyOneboxRenderer, Consumer<MetaInfo> addMetaInfo) throws ParsingException {
        List supportRenderers = emergencyOneboxRenderer.values().stream().filter(o -> o instanceof JsonObject && ((JsonObject)o).has("singleActionEmergencySupportRenderer")).map(o -> ((JsonObject)o).getObject("singleActionEmergencySupportRenderer")).collect(Collectors.toList());
        if (supportRenderers.isEmpty()) {
            throw new ParsingException("Could not extract any meta info from emergency renderer");
        }
        for (JsonObject r : supportRenderers) {
            Object action;
            MetaInfo metaInfo = new MetaInfo();
            String title = YoutubeParsingHelper.getTextFromObjectOrThrow(r.getObject("title"), "title");
            if (r.has("actionText")) {
                action = "\n" + YoutubeParsingHelper.getTextFromObjectOrThrow(r.getObject("actionText"), "action");
            } else if (r.has("contacts")) {
                JsonArray contacts = r.getArray("contacts");
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < contacts.size(); ++i) {
                    stringBuilder.append("\n");
                    stringBuilder.append(YoutubeParsingHelper.getTextFromObjectOrThrow(contacts.getObject(i).getObject("actionText"), "contacts.actionText"));
                }
                action = stringBuilder.toString();
            } else {
                action = "";
            }
            String details = YoutubeParsingHelper.getTextFromObjectOrThrow(r.getObject("detailsText"), "details");
            String urlText = YoutubeParsingHelper.getTextFromObjectOrThrow(r.getObject("navigationText"), "urlText");
            metaInfo.setTitle(title);
            metaInfo.setContent(new Description(details + (String)action, 3));
            metaInfo.addUrlText(urlText);
            String url = YoutubeParsingHelper.getUrlFromNavigationEndpoint(r.getObject("navigationEndpoint"));
            if (url == null) {
                throw new ParsingException("Could not extract emergency renderer url");
            }
            try {
                metaInfo.addUrl(new URL(Utils.replaceHttpWithHttps(url)));
            }
            catch (MalformedURLException e) {
                throw new ParsingException("Could not parse emergency renderer url", e);
            }
            addMetaInfo.accept(metaInfo);
        }
    }
}

