/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeJavaScriptExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeSignatureUtils;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeThrottlingParameterUtils;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.JavaScript;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public final class YoutubeJavaScriptPlayerManager {
    @Nonnull
    private static final Map<String, String> CACHED_THROTTLING_PARAMETERS = new HashMap<String, String>();
    private static String cachedJavaScriptPlayerCode;
    @Nullable
    private static Integer cachedSignatureTimestamp;
    @Nullable
    private static String cachedSignatureDeobfuscationFunction;
    @Nullable
    private static String cachedThrottlingDeobfuscationFunctionName;
    @Nullable
    private static String cachedThrottlingDeobfuscationFunction;
    @Nullable
    private static ParsingException throttlingDeobfFuncExtractionEx;
    @Nullable
    private static ParsingException sigDeobFuncExtractionEx;
    @Nullable
    private static ParsingException sigTimestampExtractionEx;

    private YoutubeJavaScriptPlayerManager() {
    }

    @Nonnull
    public static Integer getSignatureTimestamp(@Nonnull String videoId) throws ParsingException {
        if (cachedSignatureTimestamp != null) {
            return cachedSignatureTimestamp;
        }
        if (sigTimestampExtractionEx != null) {
            throw sigTimestampExtractionEx;
        }
        YoutubeJavaScriptPlayerManager.extractJavaScriptCodeIfNeeded(videoId);
        try {
            cachedSignatureTimestamp = Integer.valueOf(YoutubeSignatureUtils.getSignatureTimestamp(cachedJavaScriptPlayerCode));
        }
        catch (ParsingException e) {
            sigTimestampExtractionEx = e;
            throw e;
        }
        catch (NumberFormatException e) {
            sigTimestampExtractionEx = new ParsingException("Could not convert signature timestamp to a number", e);
        }
        catch (Exception e) {
            sigTimestampExtractionEx = new ParsingException("Could not get signature timestamp", e);
            throw e;
        }
        return cachedSignatureTimestamp;
    }

    @Nonnull
    public static String deobfuscateSignature(@Nonnull String videoId, @Nonnull String obfuscatedSignature) throws ParsingException {
        if (sigDeobFuncExtractionEx != null) {
            throw sigDeobFuncExtractionEx;
        }
        YoutubeJavaScriptPlayerManager.extractJavaScriptCodeIfNeeded(videoId);
        if (cachedSignatureDeobfuscationFunction == null) {
            try {
                cachedSignatureDeobfuscationFunction = YoutubeSignatureUtils.getDeobfuscationCode(cachedJavaScriptPlayerCode);
            }
            catch (ParsingException e) {
                sigDeobFuncExtractionEx = e;
                throw e;
            }
            catch (Exception e) {
                sigDeobFuncExtractionEx = new ParsingException("Could not get signature parameter deobfuscation JavaScript function", e);
                throw e;
            }
        }
        try {
            return Objects.requireNonNullElse(JavaScript.run(cachedSignatureDeobfuscationFunction, "deobfuscate", obfuscatedSignature), "");
        }
        catch (Exception e) {
            throw new ParsingException("Could not run signature parameter deobfuscation JavaScript function", e);
        }
    }

    @Nonnull
    public static String getUrlWithThrottlingParameterDeobfuscated(@Nonnull String videoId, @Nonnull String streamingUrl) throws ParsingException {
        String obfuscatedThrottlingParameter = YoutubeThrottlingParameterUtils.getThrottlingParameterFromStreamingUrl(streamingUrl);
        if (obfuscatedThrottlingParameter == null) {
            return streamingUrl;
        }
        String cacheResult = CACHED_THROTTLING_PARAMETERS.get(obfuscatedThrottlingParameter);
        if (cacheResult != null) {
            return streamingUrl.replace(obfuscatedThrottlingParameter, cacheResult);
        }
        YoutubeJavaScriptPlayerManager.extractJavaScriptCodeIfNeeded(videoId);
        if (throttlingDeobfFuncExtractionEx != null) {
            throw throttlingDeobfFuncExtractionEx;
        }
        if (cachedThrottlingDeobfuscationFunction == null) {
            try {
                cachedThrottlingDeobfuscationFunctionName = YoutubeThrottlingParameterUtils.getDeobfuscationFunctionName(cachedJavaScriptPlayerCode);
                cachedThrottlingDeobfuscationFunction = YoutubeThrottlingParameterUtils.getDeobfuscationFunction(cachedJavaScriptPlayerCode, cachedThrottlingDeobfuscationFunctionName);
            }
            catch (ParsingException e) {
                throttlingDeobfFuncExtractionEx = e;
                throw e;
            }
            catch (Exception e) {
                throttlingDeobfFuncExtractionEx = new ParsingException("Could not get throttling parameter deobfuscation JavaScript function", e);
                throw e;
            }
        }
        try {
            String deobfuscatedThrottlingParameter = JavaScript.run(cachedThrottlingDeobfuscationFunction, cachedThrottlingDeobfuscationFunctionName, obfuscatedThrottlingParameter);
            if (Utils.isNullOrEmpty(deobfuscatedThrottlingParameter)) {
                throw new IllegalStateException("Extracted n-parameter is empty");
            }
            CACHED_THROTTLING_PARAMETERS.put(obfuscatedThrottlingParameter, deobfuscatedThrottlingParameter);
            return streamingUrl.replace(obfuscatedThrottlingParameter, deobfuscatedThrottlingParameter);
        }
        catch (Exception e) {
            throw new ParsingException("Could not run throttling parameter deobfuscation JavaScript function", e);
        }
    }

    public static int getThrottlingParametersCacheSize() {
        return CACHED_THROTTLING_PARAMETERS.size();
    }

    public static void clearAllCaches() {
        cachedJavaScriptPlayerCode = null;
        cachedSignatureDeobfuscationFunction = null;
        cachedThrottlingDeobfuscationFunctionName = null;
        cachedThrottlingDeobfuscationFunction = null;
        cachedSignatureTimestamp = null;
        YoutubeJavaScriptPlayerManager.clearThrottlingParametersCache();
        throttlingDeobfFuncExtractionEx = null;
        sigDeobFuncExtractionEx = null;
        sigTimestampExtractionEx = null;
    }

    public static void clearThrottlingParametersCache() {
        CACHED_THROTTLING_PARAMETERS.clear();
    }

    private static void extractJavaScriptCodeIfNeeded(@Nonnull String videoId) throws ParsingException {
        if (cachedJavaScriptPlayerCode == null) {
            cachedJavaScriptPlayerCode = YoutubeJavaScriptExtractor.extractJavaScriptPlayerCode(videoId);
        }
    }
}

