/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube;

import java.io.Serializable;
import java.util.Locale;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.MediaFormat;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.AudioTrackType;

public class ItagItem
implements Serializable {
    private static final ItagItem[] ITAG_LIST = new ItagItem[]{new ItagItem(17, ItagType.VIDEO, MediaFormat.v3GPP, "144p"), new ItagItem(36, ItagType.VIDEO, MediaFormat.v3GPP, "240p"), new ItagItem(18, ItagType.VIDEO, MediaFormat.MPEG_4, "360p"), new ItagItem(34, ItagType.VIDEO, MediaFormat.MPEG_4, "360p"), new ItagItem(35, ItagType.VIDEO, MediaFormat.MPEG_4, "480p"), new ItagItem(59, ItagType.VIDEO, MediaFormat.MPEG_4, "480p"), new ItagItem(78, ItagType.VIDEO, MediaFormat.MPEG_4, "480p"), new ItagItem(22, ItagType.VIDEO, MediaFormat.MPEG_4, "720p"), new ItagItem(37, ItagType.VIDEO, MediaFormat.MPEG_4, "1080p"), new ItagItem(38, ItagType.VIDEO, MediaFormat.MPEG_4, "1080p"), new ItagItem(43, ItagType.VIDEO, MediaFormat.WEBM, "360p"), new ItagItem(44, ItagType.VIDEO, MediaFormat.WEBM, "480p"), new ItagItem(45, ItagType.VIDEO, MediaFormat.WEBM, "720p"), new ItagItem(46, ItagType.VIDEO, MediaFormat.WEBM, "1080p"), new ItagItem(171, ItagType.AUDIO, MediaFormat.WEBMA, 128), new ItagItem(172, ItagType.AUDIO, MediaFormat.WEBMA, 256), new ItagItem(599, ItagType.AUDIO, MediaFormat.M4A, 32), new ItagItem(139, ItagType.AUDIO, MediaFormat.M4A, 48), new ItagItem(140, ItagType.AUDIO, MediaFormat.M4A, 128), new ItagItem(141, ItagType.AUDIO, MediaFormat.M4A, 256), new ItagItem(600, ItagType.AUDIO, MediaFormat.WEBMA_OPUS, 35), new ItagItem(249, ItagType.AUDIO, MediaFormat.WEBMA_OPUS, 50), new ItagItem(250, ItagType.AUDIO, MediaFormat.WEBMA_OPUS, 70), new ItagItem(251, ItagType.AUDIO, MediaFormat.WEBMA_OPUS, 160), new ItagItem(160, ItagType.VIDEO_ONLY, MediaFormat.MPEG_4, "144p"), new ItagItem(394, ItagType.VIDEO_ONLY, MediaFormat.MPEG_4, "144p"), new ItagItem(133, ItagType.VIDEO_ONLY, MediaFormat.MPEG_4, "240p"), new ItagItem(395, ItagType.VIDEO_ONLY, MediaFormat.MPEG_4, "240p"), new ItagItem(134, ItagType.VIDEO_ONLY, MediaFormat.MPEG_4, "360p"), new ItagItem(396, ItagType.VIDEO_ONLY, MediaFormat.MPEG_4, "360p"), new ItagItem(135, ItagType.VIDEO_ONLY, MediaFormat.MPEG_4, "480p"), new ItagItem(212, ItagType.VIDEO_ONLY, MediaFormat.MPEG_4, "480p"), new ItagItem(397, ItagType.VIDEO_ONLY, MediaFormat.MPEG_4, "480p"), new ItagItem(136, ItagType.VIDEO_ONLY, MediaFormat.MPEG_4, "720p"), new ItagItem(398, ItagType.VIDEO_ONLY, MediaFormat.MPEG_4, "720p"), new ItagItem(298, ItagType.VIDEO_ONLY, MediaFormat.MPEG_4, "720p60", 60), new ItagItem(137, ItagType.VIDEO_ONLY, MediaFormat.MPEG_4, "1080p"), new ItagItem(399, ItagType.VIDEO_ONLY, MediaFormat.MPEG_4, "1080p"), new ItagItem(299, ItagType.VIDEO_ONLY, MediaFormat.MPEG_4, "1080p60", 60), new ItagItem(400, ItagType.VIDEO_ONLY, MediaFormat.MPEG_4, "1440p"), new ItagItem(266, ItagType.VIDEO_ONLY, MediaFormat.MPEG_4, "2160p"), new ItagItem(401, ItagType.VIDEO_ONLY, MediaFormat.MPEG_4, "2160p"), new ItagItem(278, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "144p"), new ItagItem(242, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "240p"), new ItagItem(243, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "360p"), new ItagItem(244, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "480p"), new ItagItem(245, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "480p"), new ItagItem(246, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "480p"), new ItagItem(247, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "720p"), new ItagItem(248, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "1080p"), new ItagItem(271, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "1440p"), new ItagItem(272, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "2160p"), new ItagItem(302, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "720p60", 60), new ItagItem(303, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "1080p60", 60), new ItagItem(308, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "1440p60", 60), new ItagItem(313, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "2160p"), new ItagItem(315, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "2160p60", 60)};
    public static final int AVERAGE_BITRATE_UNKNOWN = -1;
    public static final int SAMPLE_RATE_UNKNOWN = -1;
    public static final int FPS_NOT_APPLICABLE_OR_UNKNOWN = -1;
    public static final int TARGET_DURATION_SEC_UNKNOWN = -1;
    public static final int AUDIO_CHANNELS_NOT_APPLICABLE_OR_UNKNOWN = -1;
    public static final long CONTENT_LENGTH_UNKNOWN = -1L;
    public static final long APPROX_DURATION_MS_UNKNOWN = -1L;
    public static final long LAST_MODIFIED_UNKOWN = -1L;
    private final MediaFormat mediaFormat;
    public final int id;
    public final ItagType itagType;
    @Deprecated
    public int avgBitrate = -1;
    private int sampleRate = -1;
    private int audioChannels = -1;
    @Deprecated
    public String resolutionString;
    @Deprecated
    public int fps = -1;
    private int bitrate;
    private int width;
    private int height;
    private int initStart;
    private int initEnd;
    private int indexStart;
    private int indexEnd;
    private String quality;
    private String codec;
    private int targetDurationSec = -1;
    private long approxDurationMs = -1L;
    private long contentLength = -1L;
    private String audioTrackId;
    private String audioTrackName;
    @Nullable
    private AudioTrackType audioTrackType;
    @Nullable
    private Locale audioLocale;
    private boolean isDrc;
    private long lastModified;
    private String xtags;

    public static boolean isSupported(int itag) {
        for (ItagItem item : ITAG_LIST) {
            if (itag != item.id) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public static ItagItem getItag(int itagId) throws ParsingException {
        for (ItagItem item : ITAG_LIST) {
            if (itagId != item.id) continue;
            return new ItagItem(item);
        }
        throw new ParsingException("itag " + itagId + " is not supported");
    }

    public ItagItem(int id2, ItagType type, MediaFormat format, String resolution) {
        this.id = id2;
        this.itagType = type;
        this.mediaFormat = format;
        this.resolutionString = resolution;
        this.fps = 30;
    }

    public ItagItem(int id2, ItagType type, MediaFormat format, String resolution, int fps) {
        this.id = id2;
        this.itagType = type;
        this.mediaFormat = format;
        this.resolutionString = resolution;
        this.fps = fps;
    }

    public ItagItem(int id2, ItagType type, MediaFormat format, int avgBitrate) {
        this.id = id2;
        this.itagType = type;
        this.mediaFormat = format;
        this.avgBitrate = avgBitrate;
    }

    public ItagItem(@Nonnull ItagItem itagItem) {
        this.mediaFormat = itagItem.mediaFormat;
        this.id = itagItem.id;
        this.itagType = itagItem.itagType;
        this.avgBitrate = itagItem.avgBitrate;
        this.sampleRate = itagItem.sampleRate;
        this.audioChannels = itagItem.audioChannels;
        this.resolutionString = itagItem.resolutionString;
        this.fps = itagItem.fps;
        this.bitrate = itagItem.bitrate;
        this.width = itagItem.width;
        this.height = itagItem.height;
        this.initStart = itagItem.initStart;
        this.initEnd = itagItem.initEnd;
        this.indexStart = itagItem.indexStart;
        this.indexEnd = itagItem.indexEnd;
        this.quality = itagItem.quality;
        this.codec = itagItem.codec;
        this.targetDurationSec = itagItem.targetDurationSec;
        this.approxDurationMs = itagItem.approxDurationMs;
        this.contentLength = itagItem.contentLength;
        this.audioTrackId = itagItem.audioTrackId;
        this.audioTrackName = itagItem.audioTrackName;
        this.audioTrackType = itagItem.audioTrackType;
        this.audioLocale = itagItem.audioLocale;
    }

    public MediaFormat getMediaFormat() {
        return this.mediaFormat;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public void setBitrate(int bitrate) {
        this.bitrate = bitrate;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getFps() {
        return this.fps;
    }

    public void setFps(int fps) {
        this.fps = fps > 0 ? fps : -1;
    }

    public int getInitStart() {
        return this.initStart;
    }

    public void setInitStart(int initStart) {
        this.initStart = initStart;
    }

    public int getInitEnd() {
        return this.initEnd;
    }

    public void setInitEnd(int initEnd) {
        this.initEnd = initEnd;
    }

    public int getIndexStart() {
        return this.indexStart;
    }

    public void setIndexStart(int indexStart) {
        this.indexStart = indexStart;
    }

    public int getIndexEnd() {
        return this.indexEnd;
    }

    public void setIndexEnd(int indexEnd) {
        this.indexEnd = indexEnd;
    }

    public String getQuality() {
        return this.quality;
    }

    public void setQuality(String quality) {
        this.quality = quality;
    }

    @Nullable
    public String getResolutionString() {
        return this.resolutionString;
    }

    public String getCodec() {
        return this.codec;
    }

    public void setCodec(String codec) {
        this.codec = codec;
    }

    public int getAverageBitrate() {
        return this.avgBitrate;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate > 0 ? sampleRate : -1;
    }

    public int getAudioChannels() {
        return this.audioChannels;
    }

    public void setAudioChannels(int audioChannels) {
        this.audioChannels = audioChannels > 0 ? audioChannels : -1;
    }

    public int getTargetDurationSec() {
        return this.targetDurationSec;
    }

    public void setTargetDurationSec(int targetDurationSec) {
        this.targetDurationSec = targetDurationSec > 0 ? targetDurationSec : -1;
    }

    public long getApproxDurationMs() {
        return this.approxDurationMs;
    }

    public void setApproxDurationMs(long approxDurationMs) {
        this.approxDurationMs = approxDurationMs > 0L ? approxDurationMs : -1L;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength > 0L ? contentLength : -1L;
    }

    @Nullable
    public String getAudioTrackId() {
        return this.audioTrackId;
    }

    public void setAudioTrackId(@Nullable String audioTrackId) {
        this.audioTrackId = audioTrackId;
    }

    @Nullable
    public String getAudioTrackName() {
        return this.audioTrackName;
    }

    public void setAudioTrackName(@Nullable String audioTrackName) {
        this.audioTrackName = audioTrackName;
    }

    @Nullable
    public AudioTrackType getAudioTrackType() {
        return this.audioTrackType;
    }

    public void setAudioTrackType(@Nullable AudioTrackType audioTrackType) {
        this.audioTrackType = audioTrackType;
    }

    @Nullable
    public Locale getAudioLocale() {
        return this.audioLocale;
    }

    public void setAudioLocale(@Nullable Locale audioLocale) {
        this.audioLocale = audioLocale;
    }

    public Boolean isDrc() {
        return this.isDrc;
    }

    public void setIsDrc(Boolean isDrc) {
        this.isDrc = isDrc;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public String getXtags() {
        return this.xtags;
    }

    public void setXtags(String xtags) {
        this.xtags = xtags;
    }

    public static enum ItagType {
        AUDIO,
        VIDEO,
        VIDEO_ONLY;

    }
}

