/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube;

import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;

public final class InnertubeClientRequestInfo {
    @Nonnull
    public ClientInfo clientInfo;
    @Nonnull
    public DeviceInfo deviceInfo;

    private InnertubeClientRequestInfo(@Nonnull ClientInfo clientInfo, @Nonnull DeviceInfo deviceInfo) {
        this.clientInfo = clientInfo;
        this.deviceInfo = deviceInfo;
    }

    @Nonnull
    public static InnertubeClientRequestInfo ofWebClient() {
        return new InnertubeClientRequestInfo(new ClientInfo("WEB", "2.20260120.01.00", "1", "WATCH", null), new DeviceInfo("DESKTOP", null, null, null, null, -1));
    }

    @Nonnull
    public static InnertubeClientRequestInfo ofWebEmbeddedPlayerClient() {
        return new InnertubeClientRequestInfo(new ClientInfo("WEB_EMBEDDED_PLAYER", "1.20260122.01.00", "56", "EMBED", null), new DeviceInfo("DESKTOP", null, null, null, null, -1));
    }

    @Nonnull
    public static InnertubeClientRequestInfo ofWebMusicAnalyticsChartsClient() {
        return new InnertubeClientRequestInfo(new ClientInfo("WEB_MUSIC_ANALYTICS", "2.0", "31", null, null), new DeviceInfo(null, null, null, null, null, -1));
    }

    @Nonnull
    public static InnertubeClientRequestInfo ofAndroidClient() {
        return new InnertubeClientRequestInfo(new ClientInfo("ANDROID", "21.03.36", "3", "WATCH", null), new DeviceInfo("MOBILE", null, null, "Android", "16", 36));
    }

    @Nonnull
    public static InnertubeClientRequestInfo ofIosClient() {
        return new InnertubeClientRequestInfo(new ClientInfo("IOS", "21.03.2", "5", "WATCH", null), new DeviceInfo("MOBILE", "Apple", "iPhone16,2", "iOS", "18.7.2.22H124", -1));
    }

    public static final class DeviceInfo {
        @Nullable
        public String platform;
        @Nullable
        public String deviceMake;
        @Nullable
        public String deviceModel;
        @Nullable
        public String osName;
        @Nullable
        public String osVersion;
        public int androidSdkVersion;

        private DeviceInfo(@Nullable String platform, @Nullable String deviceMake, @Nullable String deviceModel, @Nullable String osName, @Nullable String osVersion, int androidSdkVersion) {
            this.platform = platform;
            this.deviceMake = deviceMake;
            this.deviceModel = deviceModel;
            this.osName = osName;
            this.osVersion = osVersion;
            this.androidSdkVersion = androidSdkVersion;
        }
    }

    public static final class ClientInfo {
        @Nonnull
        public String clientName;
        @Nonnull
        public String clientVersion;
        @Nonnull
        public String clientId;
        @Nullable
        public String clientScreen;
        @Nullable
        public String visitorData;

        private ClientInfo(@Nonnull String clientName, @Nonnull String clientVersion, @Nonnull String clientId, @Nullable String clientScreen, @Nullable String visitorData) {
            this.clientName = clientName;
            this.clientVersion = clientVersion;
            this.clientId = clientId;
            this.clientScreen = clientScreen;
            this.visitorData = visitorData;
        }
    }
}

