/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.linkHandler;

import java.util.List;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.UnsupportedTabException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.linkHandler.SoundcloudChannelLinkHandlerFactory;

public final class SoundcloudChannelTabLinkHandlerFactory
extends ListLinkHandlerFactory {
    private static final SoundcloudChannelTabLinkHandlerFactory INSTANCE = new SoundcloudChannelTabLinkHandlerFactory();

    private SoundcloudChannelTabLinkHandlerFactory() {
    }

    public static SoundcloudChannelTabLinkHandlerFactory getInstance() {
        return INSTANCE;
    }

    @Nonnull
    public static String getUrlSuffix(String tab) throws UnsupportedOperationException {
        switch (tab) {
            case "tracks": {
                return "/tracks";
            }
            case "playlists": {
                return "/sets";
            }
            case "albums": {
                return "/albums";
            }
            case "likes": {
                return "/likes";
            }
        }
        throw new UnsupportedTabException(tab);
    }

    @Override
    public String getId(String url) throws ParsingException {
        return SoundcloudChannelLinkHandlerFactory.getInstance().getId(url);
    }

    @Override
    public String getUrl(String id2, List<String> contentFilter, String sortFilter) throws ParsingException {
        return SoundcloudChannelLinkHandlerFactory.getInstance().getUrl(id2) + SoundcloudChannelTabLinkHandlerFactory.getUrlSuffix(contentFilter.get(0));
    }

    @Override
    public boolean onAcceptUrl(String url) throws ParsingException {
        return SoundcloudChannelLinkHandlerFactory.getInstance().onAcceptUrl(url);
    }

    @Override
    public String[] getAvailableContentFilter() {
        return new String[]{"tracks", "playlists", "albums", "likes"};
    }
}

