/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.extractors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.MediaFormat;
import org.watermedia.shaded.schabi.newpipe.extractor.NewPipe;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ContentNotAvailableException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.GeographicRestrictionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.SoundCloudGoPlusContentException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.LinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.DateWrapper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.SoundcloudParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.AudioStream;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.DeliveryMethod;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Description;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Stream;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamType;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.VideoStream;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class SoundcloudStreamExtractor
extends StreamExtractor {
    private JsonObject track;
    private boolean isAvailable = true;

    public SoundcloudStreamExtractor(StreamingService service, LinkHandler linkHandler) {
        super(service, linkHandler);
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        this.track = SoundcloudParsingHelper.resolveFor(downloader, this.getUrl());
        String policy = this.track.getString("policy", "");
        if (!policy.equals("ALLOW") && !policy.equals("MONETIZE")) {
            this.isAvailable = false;
            if (policy.equals("SNIP")) {
                throw new SoundCloudGoPlusContentException();
            }
            if (policy.equals("BLOCK")) {
                throw new GeographicRestrictionException("This track is not available in user's country");
            }
            throw new ContentNotAvailableException("Content not available: policy " + policy);
        }
    }

    @Override
    @Nonnull
    public String getId() {
        return String.valueOf(this.track.getInt("id"));
    }

    @Override
    @Nonnull
    public String getName() {
        return this.track.getString("title");
    }

    @Override
    @Nullable
    public String getTextualUploadDate() {
        return this.track.getString("created_at");
    }

    @Override
    @Nullable
    public DateWrapper getUploadDate() throws ParsingException {
        return SoundcloudParsingHelper.parseDate(this.getTextualUploadDate());
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        return SoundcloudParsingHelper.getAllImagesFromTrackObject(this.track);
    }

    @Override
    @Nonnull
    public Description getDescription() {
        return new Description(this.track.getString("description"), 3);
    }

    @Override
    public long getLength() {
        return this.track.getLong("duration") / 1000L;
    }

    @Override
    public long getTimeStamp() throws ParsingException {
        long timestamp = this.getTimestampSeconds("(#t=\\d{0,3}h?\\d{0,3}m?\\d{1,3}s?)");
        return timestamp == -2L ? 0L : timestamp;
    }

    @Override
    public long getViewCount() {
        return this.track.getLong("playback_count");
    }

    @Override
    public long getLikeCount() {
        return this.track.getLong("likes_count", -1L);
    }

    @Override
    @Nonnull
    public String getUploaderUrl() {
        return SoundcloudParsingHelper.getUploaderUrl(this.track);
    }

    @Override
    @Nonnull
    public String getUploaderName() {
        return SoundcloudParsingHelper.getUploaderName(this.track);
    }

    @Override
    public boolean isUploaderVerified() throws ParsingException {
        return this.track.getObject("user").getBoolean("verified");
    }

    @Override
    @Nonnull
    public List<Image> getUploaderAvatars() {
        return SoundcloudParsingHelper.getAllImagesFromArtworkOrAvatarUrl(SoundcloudParsingHelper.getAvatarUrl(this.track));
    }

    @Override
    public List<AudioStream> getAudioStreams() throws ExtractionException {
        ArrayList<AudioStream> audioStreams = new ArrayList<AudioStream>();
        if (!this.track.getBoolean("streamable") || !this.isAvailable) {
            return audioStreams;
        }
        try {
            JsonArray transcodings = this.track.getObject("media").getArray("transcodings");
            if (!Utils.isNullOrEmpty(transcodings)) {
                this.extractAudioStreams(transcodings, audioStreams);
            }
        }
        catch (NullPointerException e) {
            throw new ExtractionException("Could not get audio streams", e);
        }
        return audioStreams;
    }

    @Nonnull
    private String getTranscodingUrl(String endpointUrl) throws IOException, ExtractionException {
        JsonObject urlObject;
        String apiStreamUrl = endpointUrl + "?client_id=" + SoundcloudParsingHelper.clientId();
        String trackAuthorization = this.track.getString("track_authorization");
        if (!Utils.isNullOrEmpty(trackAuthorization)) {
            apiStreamUrl = apiStreamUrl + "&track_authorization=" + trackAuthorization;
        }
        String response = NewPipe.getDownloader().get(apiStreamUrl).responseBody();
        try {
            urlObject = JsonParser.object().from(response);
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse streamable URL", e);
        }
        return urlObject.getString("url");
    }

    private void extractAudioStreams(@Nonnull JsonArray transcodings, List<AudioStream> audioStreams) {
        transcodings.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).forEachOrdered(transcoding -> {
            String url = transcoding.getString("url");
            if (Utils.isNullOrEmpty(url)) {
                return;
            }
            try {
                String preset = transcoding.getString("preset", " ");
                String protocol = transcoding.getObject("format").getString("protocol");
                if (protocol.contains("encrypted")) {
                    return;
                }
                AudioStream.Builder builder = new AudioStream.Builder().setId(preset);
                if (protocol.equals("hls")) {
                    builder.setDeliveryMethod(DeliveryMethod.HLS);
                }
                builder.setContent(this.getTranscodingUrl(url), true);
                if (preset.contains("mp3")) {
                    builder.setMediaFormat(MediaFormat.MP3);
                    builder.setAverageBitrate(128);
                } else if (preset.contains("opus")) {
                    builder.setMediaFormat(MediaFormat.OPUS);
                    builder.setAverageBitrate(64);
                } else if (preset.contains("aac_160k")) {
                    builder.setMediaFormat(MediaFormat.M4A);
                    builder.setAverageBitrate(160);
                } else {
                    return;
                }
                AudioStream audioStream = builder.build();
                if (!Stream.containSimilarStream(audioStream, audioStreams)) {
                    audioStreams.add(audioStream);
                }
            }
            catch (IOException | ExtractionException exception) {
                // empty catch block
            }
        });
    }

    @Override
    public List<VideoStream> getVideoStreams() {
        return Collections.emptyList();
    }

    @Override
    public List<VideoStream> getVideoOnlyStreams() {
        return Collections.emptyList();
    }

    @Override
    public StreamType getStreamType() {
        return StreamType.AUDIO_STREAM;
    }

    @Nullable
    public StreamInfoItemsCollector getRelatedItems() throws IOException, ExtractionException {
        StreamInfoItemsCollector collector = new StreamInfoItemsCollector(this.getServiceId());
        String apiUrl = "https://api-v2.soundcloud.com/tracks/" + Utils.encodeUrlUtf8(this.getId()) + "/related?client_id=" + Utils.encodeUrlUtf8(SoundcloudParsingHelper.clientId());
        SoundcloudParsingHelper.getStreamsFromApi(collector, apiUrl);
        return collector;
    }

    @Override
    public StreamExtractor.Privacy getPrivacy() {
        return this.track.getString("sharing").equals("public") ? StreamExtractor.Privacy.PUBLIC : StreamExtractor.Privacy.PRIVATE;
    }

    @Override
    @Nonnull
    public String getCategory() {
        return this.track.getString("genre");
    }

    @Override
    @Nonnull
    public String getLicence() {
        return this.track.getString("license");
    }

    @Override
    @Nonnull
    public List<String> getTags() {
        String[] tagList = this.track.getString("tag_list").split(" ");
        ArrayList<String> tags = new ArrayList<String>();
        StringBuilder escapedTag = new StringBuilder();
        boolean isEscaped = false;
        for (String tag : tagList) {
            if (tag.startsWith("\"")) {
                escapedTag.append(tag.replace("\"", ""));
                isEscaped = true;
                continue;
            }
            if (isEscaped) {
                if (tag.endsWith("\"")) {
                    escapedTag.append(" ").append(tag.replace("\"", ""));
                    isEscaped = false;
                    tags.add(escapedTag.toString());
                    continue;
                }
                escapedTag.append(" ").append(tag);
                continue;
            }
            if (tag.isEmpty()) continue;
            tags.add(tag);
        }
        return tags;
    }
}

