/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.linkHandler;

import java.util.List;
import org.watermedia.shaded.schabi.newpipe.extractor.ServiceList;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.SearchQueryHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public final class PeertubeSearchQueryHandlerFactory
extends SearchQueryHandlerFactory {
    private static final PeertubeSearchQueryHandlerFactory INSTANCE = new PeertubeSearchQueryHandlerFactory();
    public static final String VIDEOS = "videos";
    public static final String SEPIA_VIDEOS = "sepia_videos";
    public static final String PLAYLISTS = "playlists";
    public static final String CHANNELS = "channels";
    public static final String SEPIA_BASE_URL = "https://sepiasearch.org";
    public static final String SEARCH_ENDPOINT_PLAYLISTS = "/api/v1/search/video-playlists";
    public static final String SEARCH_ENDPOINT_VIDEOS = "/api/v1/search/videos";
    public static final String SEARCH_ENDPOINT_CHANNELS = "/api/v1/search/video-channels";

    private PeertubeSearchQueryHandlerFactory() {
    }

    public static PeertubeSearchQueryHandlerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public String getUrl(String searchString, List<String> contentFilters, String sortFilter) throws ParsingException, UnsupportedOperationException {
        String baseUrl = !contentFilters.isEmpty() && contentFilters.get(0).startsWith("sepia_") ? SEPIA_BASE_URL : ServiceList.PeerTube.getBaseUrl();
        return this.getUrl(searchString, contentFilters, sortFilter, baseUrl);
    }

    @Override
    public String getUrl(String searchString, List<String> contentFilters, String sortFilter, String baseUrl) throws ParsingException, UnsupportedOperationException {
        String endpoint = contentFilters.isEmpty() || contentFilters.get(0).equals(VIDEOS) || contentFilters.get(0).equals(SEPIA_VIDEOS) ? SEARCH_ENDPOINT_VIDEOS : (contentFilters.get(0).equals(CHANNELS) ? SEARCH_ENDPOINT_CHANNELS : SEARCH_ENDPOINT_PLAYLISTS);
        return baseUrl + endpoint + "?search=" + Utils.encodeUrlUtf8(searchString);
    }

    @Override
    public String[] getAvailableContentFilter() {
        return new String[]{VIDEOS, PLAYLISTS, CHANNELS, SEPIA_VIDEOS};
    }
}

