/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.extractors;

import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.ServiceList;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.DateWrapper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.PeertubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamType;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.JsonUtils;

public class PeertubeStreamInfoItemExtractor
implements StreamInfoItemExtractor {
    protected final JsonObject item;
    private String baseUrl;

    public PeertubeStreamInfoItemExtractor(JsonObject item, String baseUrl) {
        this.item = item;
        this.baseUrl = baseUrl;
    }

    @Override
    public String getUrl() throws ParsingException {
        String uuid = JsonUtils.getString(this.item, "uuid");
        return ServiceList.PeerTube.getStreamLHFactory().fromId(uuid, this.baseUrl).getUrl();
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        return PeertubeParsingHelper.getThumbnailsFromPlaylistOrVideoItem(this.baseUrl, this.item);
    }

    @Override
    public String getName() throws ParsingException {
        return JsonUtils.getString(this.item, "name");
    }

    @Override
    public boolean isAd() {
        return false;
    }

    @Override
    public long getViewCount() {
        return this.item.getLong("views");
    }

    @Override
    public String getUploaderUrl() throws ParsingException {
        String name = JsonUtils.getString(this.item, "account.name");
        String host = JsonUtils.getString(this.item, "account.host");
        return ServiceList.PeerTube.getChannelLHFactory().fromId("accounts/" + name + "@" + host, this.baseUrl).getUrl();
    }

    @Override
    @Nonnull
    public List<Image> getUploaderAvatars() {
        return PeertubeParsingHelper.getAvatarsFromOwnerAccountOrVideoChannelObject(this.baseUrl, this.item.getObject("account"));
    }

    @Override
    public boolean isUploaderVerified() throws ParsingException {
        return false;
    }

    @Override
    public String getUploaderName() throws ParsingException {
        return JsonUtils.getString(this.item, "account.displayName");
    }

    @Override
    public String getTextualUploadDate() throws ParsingException {
        return JsonUtils.getString(this.item, "publishedAt");
    }

    @Override
    public DateWrapper getUploadDate() throws ParsingException {
        return DateWrapper.fromInstant(this.getTextualUploadDate());
    }

    @Override
    public StreamType getStreamType() {
        return this.item.getBoolean("isLive") ? StreamType.LIVE_STREAM : StreamType.VIDEO_STREAM;
    }

    @Override
    public long getDuration() {
        return this.item.getLong("duration");
    }

    protected void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }
}

