/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.extractors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.MediaFormat;
import org.watermedia.shaded.schabi.newpipe.extractor.NewPipe;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Response;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ReCaptchaException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.LinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.DateWrapper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.PeertubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.extractors.PeertubeStreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.AudioStream;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.DeliveryMethod;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Description;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Frameset;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Stream;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamSegment;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamType;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.SubtitlesStream;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.VideoStream;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.JsonUtils;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class PeertubeStreamExtractor
extends StreamExtractor {
    private static final String ACCOUNT_HOST = "account.host";
    private static final String ACCOUNT_NAME = "account.name";
    private static final String FILES = "files";
    private static final String FILE_DOWNLOAD_URL = "fileDownloadUrl";
    private static final String FILE_URL = "fileUrl";
    private static final String PLAYLIST_URL = "playlistUrl";
    private static final String RESOLUTION_ID = "resolution.id";
    private static final String STREAMING_PLAYLISTS = "streamingPlaylists";
    private final String baseUrl;
    private JsonObject json;
    private final List<SubtitlesStream> subtitles = new ArrayList<SubtitlesStream>();
    private final List<AudioStream> audioStreams = new ArrayList<AudioStream>();
    private final List<VideoStream> videoStreams = new ArrayList<VideoStream>();
    private ParsingException subtitlesException = null;

    public PeertubeStreamExtractor(StreamingService service, LinkHandler linkHandler) throws ParsingException {
        super(service, linkHandler);
        this.baseUrl = this.getBaseUrl();
    }

    @Override
    public String getTextualUploadDate() throws ParsingException {
        return JsonUtils.getString(this.json, "publishedAt");
    }

    @Override
    public DateWrapper getUploadDate() throws ParsingException {
        return DateWrapper.fromInstant(this.getTextualUploadDate());
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        return PeertubeParsingHelper.getThumbnailsFromPlaylistOrVideoItem(this.baseUrl, this.json);
    }

    @Override
    @Nonnull
    public Description getDescription() throws ParsingException {
        String text;
        try {
            text = JsonUtils.getString(this.json, "description");
        }
        catch (ParsingException e) {
            return Description.EMPTY_DESCRIPTION;
        }
        if (text.length() == 250 && text.substring(247).equals("...")) {
            Downloader dl = NewPipe.getDownloader();
            try {
                Response response = dl.get(this.baseUrl + "/api/v1/videos/" + this.getId() + "/description");
                JsonObject jsonObject = JsonParser.object().from(response.responseBody());
                text = JsonUtils.getString(jsonObject, "description");
            }
            catch (IOException | JsonParserException | ReCaptchaException exception) {
                // empty catch block
            }
        }
        return new Description(text, 2);
    }

    @Override
    public int getAgeLimit() throws ParsingException {
        boolean isNSFW = JsonUtils.getBoolean(this.json, "nsfw");
        if (isNSFW) {
            return 18;
        }
        return 0;
    }

    @Override
    public long getLength() {
        return this.json.getLong("duration");
    }

    @Override
    public long getTimeStamp() throws ParsingException {
        long timestamp = this.getTimestampSeconds("((#|&|\\?)start=\\d{0,3}h?\\d{0,3}m?\\d{1,3}s?)");
        if (timestamp == -2L) {
            return 0L;
        }
        return timestamp;
    }

    @Override
    public long getViewCount() {
        return this.json.getLong("views");
    }

    @Override
    public long getLikeCount() {
        return this.json.getLong("likes");
    }

    @Override
    public long getDislikeCount() {
        return this.json.getLong("dislikes");
    }

    @Override
    @Nonnull
    public String getUploaderUrl() throws ParsingException {
        String name = JsonUtils.getString(this.json, ACCOUNT_NAME);
        String host = JsonUtils.getString(this.json, ACCOUNT_HOST);
        return this.getService().getChannelLHFactory().fromId("accounts/" + name + "@" + host, this.baseUrl).getUrl();
    }

    @Override
    @Nonnull
    public String getUploaderName() throws ParsingException {
        return JsonUtils.getString(this.json, "account.displayName");
    }

    @Override
    @Nonnull
    public List<Image> getUploaderAvatars() {
        return PeertubeParsingHelper.getAvatarsFromOwnerAccountOrVideoChannelObject(this.baseUrl, this.json.getObject("account"));
    }

    @Override
    @Nonnull
    public String getSubChannelUrl() throws ParsingException {
        return JsonUtils.getString(this.json, "channel.url");
    }

    @Override
    @Nonnull
    public String getSubChannelName() throws ParsingException {
        return JsonUtils.getString(this.json, "channel.displayName");
    }

    @Override
    @Nonnull
    public List<Image> getSubChannelAvatars() {
        return PeertubeParsingHelper.getAvatarsFromOwnerAccountOrVideoChannelObject(this.baseUrl, this.json.getObject("channel"));
    }

    @Override
    @Nonnull
    public String getHlsUrl() {
        this.assertPageFetched();
        if (this.getStreamType() == StreamType.VIDEO_STREAM && !Utils.isNullOrEmpty(this.json.getObject(FILES))) {
            return this.json.getObject(FILES).getString(PLAYLIST_URL, "");
        }
        return this.json.getArray(STREAMING_PLAYLISTS).getObject(0).getString(PLAYLIST_URL, "");
    }

    @Override
    public List<AudioStream> getAudioStreams() throws ParsingException {
        this.assertPageFetched();
        if (this.audioStreams.isEmpty() && this.videoStreams.isEmpty() && this.getStreamType() == StreamType.VIDEO_STREAM) {
            this.getStreams();
        }
        return this.audioStreams;
    }

    @Override
    public List<VideoStream> getVideoStreams() throws ExtractionException {
        this.assertPageFetched();
        if (this.videoStreams.isEmpty()) {
            if (this.getStreamType() == StreamType.VIDEO_STREAM) {
                this.getStreams();
            } else {
                this.extractLiveVideoStreams();
            }
        }
        return this.videoStreams;
    }

    @Override
    public List<VideoStream> getVideoOnlyStreams() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public List<SubtitlesStream> getSubtitlesDefault() throws ParsingException {
        if (this.subtitlesException != null) {
            throw this.subtitlesException;
        }
        return this.subtitles;
    }

    @Override
    @Nonnull
    public List<SubtitlesStream> getSubtitles(MediaFormat format) throws ParsingException {
        if (this.subtitlesException != null) {
            throw this.subtitlesException;
        }
        return this.subtitles.stream().filter(sub -> sub.getFormat() == format).collect(Collectors.toList());
    }

    @Override
    public StreamType getStreamType() {
        return this.json.getBoolean("isLive") ? StreamType.LIVE_STREAM : StreamType.VIDEO_STREAM;
    }

    @Nullable
    public StreamInfoItemsCollector getRelatedItems() throws IOException, ExtractionException {
        List<String> tags = this.getTags();
        Object apiUrl = tags.isEmpty() ? this.baseUrl + "/api/v1/accounts/" + JsonUtils.getString(this.json, ACCOUNT_NAME) + "@" + JsonUtils.getString(this.json, ACCOUNT_HOST) + "/videos?start=0&count=8" : this.getRelatedItemsUrl(tags);
        if (Utils.isBlank((String)apiUrl)) {
            return null;
        }
        StreamInfoItemsCollector collector = new StreamInfoItemsCollector(this.getServiceId());
        this.getStreamsFromApi(collector, (String)apiUrl);
        return collector;
    }

    @Override
    @Nonnull
    public List<String> getTags() {
        return JsonUtils.getStringListFromJsonArray(this.json.getArray("tags"));
    }

    @Override
    @Nonnull
    public String getSupportInfo() {
        try {
            return JsonUtils.getString(this.json, "support");
        }
        catch (ParsingException e) {
            return "";
        }
    }

    @Override
    @Nonnull
    public List<StreamSegment> getStreamSegments() throws ParsingException {
        JsonObject segmentsJson;
        ArrayList<StreamSegment> segments = new ArrayList<StreamSegment>();
        try {
            segmentsJson = this.fetchSubApiContent("chapters");
        }
        catch (IOException | ReCaptchaException e) {
            throw new ParsingException("Could not get stream segments", e);
        }
        if (segmentsJson != null && segmentsJson.has("chapters")) {
            JsonArray segmentsArray = segmentsJson.getArray("chapters");
            for (int i = 0; i < segmentsArray.size(); ++i) {
                JsonObject segmentObject = segmentsArray.getObject(i);
                segments.add(new StreamSegment(segmentObject.getString("title"), segmentObject.getInt("timecode")));
            }
        }
        return segments;
    }

    @Override
    @Nonnull
    public List<Frameset> getFrames() throws ExtractionException {
        JsonObject storyboards;
        ArrayList<Frameset> framesets = new ArrayList<Frameset>();
        try {
            storyboards = this.fetchSubApiContent("storyboards");
        }
        catch (IOException | ReCaptchaException e) {
            throw new ExtractionException("Could not get frames", e);
        }
        if (storyboards != null && storyboards.has("storyboards")) {
            JsonArray storyboardsArray = storyboards.getArray("storyboards");
            for (Object storyboard : storyboardsArray) {
                if (!(storyboard instanceof JsonObject)) continue;
                JsonObject storyboardObject = (JsonObject)storyboard;
                String url = storyboardObject.getString("storyboardPath");
                int width = storyboardObject.getInt("spriteWidth");
                int height = storyboardObject.getInt("spriteHeight");
                int totalWidth = storyboardObject.getInt("totalWidth");
                int totalHeight = storyboardObject.getInt("totalHeight");
                int framesPerPageX = totalWidth / width;
                int framesPerPageY = totalHeight / height;
                int count = framesPerPageX * framesPerPageY;
                int durationPerFrame = storyboardObject.getInt("spriteDuration") * 1000;
                framesets.add(new Frameset(List.of(this.baseUrl + url), width, height, count, durationPerFrame, framesPerPageX, framesPerPageY));
            }
        }
        return framesets;
    }

    @Nonnull
    private String getRelatedItemsUrl(@Nonnull List<String> tags) {
        String url = this.baseUrl + "/api/v1/search/videos";
        StringBuilder params = new StringBuilder();
        params.append("start=0&count=8&sort=-createdAt");
        for (String tag : tags) {
            params.append("&tagsOneOf=").append(Utils.encodeUrlUtf8(tag));
        }
        return url + "?" + params;
    }

    private void getStreamsFromApi(StreamInfoItemsCollector collector, String apiUrl) throws IOException, ReCaptchaException, ParsingException {
        Response response = this.getDownloader().get(apiUrl);
        JsonObject relatedVideosJson = null;
        if (response != null && !Utils.isBlank(response.responseBody())) {
            try {
                relatedVideosJson = JsonParser.object().from(response.responseBody());
            }
            catch (JsonParserException e) {
                throw new ParsingException("Could not parse json data for related videos", e);
            }
        }
        if (relatedVideosJson != null) {
            this.collectStreamsFrom(collector, relatedVideosJson);
        }
    }

    private void collectStreamsFrom(StreamInfoItemsCollector collector, JsonObject jsonObject) throws ParsingException {
        JsonArray contents;
        try {
            contents = (JsonArray)JsonUtils.getValue(jsonObject, "data");
        }
        catch (Exception e) {
            throw new ParsingException("Could not extract related videos", e);
        }
        for (Object c : contents) {
            JsonObject item;
            PeertubeStreamInfoItemExtractor extractor;
            if (!(c instanceof JsonObject) || (extractor = new PeertubeStreamInfoItemExtractor(item = (JsonObject)c, this.baseUrl)).getUrl().equals(this.getUrl())) continue;
            collector.commit(extractor);
        }
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        Response response = downloader.get(this.baseUrl + "/api/v1/videos/" + this.getId());
        if (response == null) {
            throw new ExtractionException("Could not extract PeerTube channel data");
        }
        this.setInitialData(response.responseBody());
        this.loadSubtitles();
    }

    private void setInitialData(String responseBody) throws ExtractionException {
        try {
            this.json = JsonParser.object().from(responseBody);
        }
        catch (JsonParserException e) {
            throw new ExtractionException("Could not extract PeerTube stream data", e);
        }
        if (this.json == null) {
            throw new ExtractionException("Could not extract PeerTube stream data");
        }
        PeertubeParsingHelper.validate(this.json);
    }

    private void loadSubtitles() {
        if (this.subtitles.isEmpty()) {
            try {
                Response response = this.getDownloader().get(this.baseUrl + "/api/v1/videos/" + this.getId() + "/captions");
                JsonObject captionsJson = JsonParser.object().from(response.responseBody());
                JsonArray captions = JsonUtils.getArray(captionsJson, "data");
                for (Object c : captions) {
                    if (!(c instanceof JsonObject)) continue;
                    JsonObject caption = (JsonObject)c;
                    String url = this.baseUrl + JsonUtils.getString(caption, "captionPath");
                    String languageCode = JsonUtils.getString(caption, "language.id");
                    String ext = url.substring(url.lastIndexOf(".") + 1);
                    MediaFormat fmt = MediaFormat.getFromSuffix(ext);
                    if (fmt == null || Utils.isNullOrEmpty(languageCode)) continue;
                    this.subtitles.add(new SubtitlesStream.Builder().setContent(url, true).setMediaFormat(fmt).setLanguageCode(languageCode).setAutoGenerated(false).build());
                }
            }
            catch (Exception e) {
                this.subtitlesException = new ParsingException("Could not get subtitles", e);
            }
        }
    }

    private void extractLiveVideoStreams() throws ParsingException {
        try {
            JsonArray streamingPlaylists = this.json.getArray(STREAMING_PLAYLISTS);
            streamingPlaylists.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(stream -> new VideoStream.Builder().setId(String.valueOf(stream.getInt("id", -1))).setContent(stream.getString(PLAYLIST_URL, ""), true).setIsVideoOnly(false).setResolution("").setMediaFormat(MediaFormat.MPEG_4).setDeliveryMethod(DeliveryMethod.HLS).build()).forEachOrdered(this.videoStreams::add);
        }
        catch (Exception e) {
            throw new ParsingException("Could not get video streams", e);
        }
    }

    private void getStreams() throws ParsingException {
        this.getStreamsFromArray(this.json.getArray(FILES), "");
        try {
            for (JsonObject playlist : this.json.getArray(STREAMING_PLAYLISTS).stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).collect(Collectors.toList())) {
                this.getStreamsFromArray(playlist.getArray(FILES), playlist.getString(PLAYLIST_URL));
            }
        }
        catch (Exception e) {
            throw new ParsingException("Could not get streams", e);
        }
    }

    private void getStreamsFromArray(@Nonnull JsonArray streams, String playlistUrl) throws ParsingException {
        try {
            boolean isInstanceUsingRandomUuidsForHlsStreams = !Utils.isNullOrEmpty(playlistUrl) && playlistUrl.endsWith("-master.m3u8");
            Iterator iterator = streams.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).collect(Collectors.toList()).iterator();
            while (iterator.hasNext()) {
                String idSuffix;
                JsonObject stream;
                String url = JsonUtils.getString(stream, (stream = (JsonObject)iterator.next()).has(FILE_URL) ? FILE_URL : FILE_DOWNLOAD_URL);
                if (Utils.isNullOrEmpty(url)) {
                    return;
                }
                String resolution = JsonUtils.getString(stream, "resolution.label");
                String string = idSuffix = stream.has(FILE_URL) ? FILE_URL : FILE_DOWNLOAD_URL;
                if (resolution.toLowerCase().contains("audio")) {
                    this.addNewAudioStream(stream, isInstanceUsingRandomUuidsForHlsStreams, resolution, idSuffix, url, playlistUrl);
                    continue;
                }
                this.addNewVideoStream(stream, isInstanceUsingRandomUuidsForHlsStreams, resolution, idSuffix, url, playlistUrl);
            }
        }
        catch (Exception e) {
            throw new ParsingException("Could not get streams from array", e);
        }
    }

    @Nonnull
    private String getHlsPlaylistUrlFromFragmentedFileUrl(@Nonnull JsonObject streamJsonObject, @Nonnull String idSuffix, @Nonnull String format, @Nonnull String url) throws ParsingException {
        String streamUrl = FILE_DOWNLOAD_URL.equals(idSuffix) ? JsonUtils.getString(streamJsonObject, FILE_URL) : url;
        return streamUrl.replace("-fragmented." + format, ".m3u8");
    }

    @Nonnull
    private String getHlsPlaylistUrlFromMasterPlaylist(@Nonnull JsonObject streamJsonObject, @Nonnull String playlistUrl) throws ParsingException {
        return playlistUrl.replace("master", JsonUtils.getNumber(streamJsonObject, RESOLUTION_ID).toString());
    }

    private void addNewAudioStream(@Nonnull JsonObject streamJsonObject, boolean isInstanceUsingRandomUuidsForHlsStreams, @Nonnull String resolution, @Nonnull String idSuffix, @Nonnull String url, @Nullable String playlistUrl) throws ParsingException {
        String torrentUrl;
        String extension = url.substring(url.lastIndexOf(".") + 1);
        MediaFormat format = MediaFormat.getFromSuffix(extension);
        String id2 = resolution + "-" + extension;
        this.audioStreams.add(new AudioStream.Builder().setId(id2 + "-" + idSuffix + "-" + DeliveryMethod.PROGRESSIVE_HTTP).setContent(url, true).setMediaFormat(format).setAverageBitrate(-1).build());
        if (!Utils.isNullOrEmpty(playlistUrl)) {
            String hlsStreamUrl = isInstanceUsingRandomUuidsForHlsStreams ? this.getHlsPlaylistUrlFromFragmentedFileUrl(streamJsonObject, idSuffix, extension, url) : this.getHlsPlaylistUrlFromMasterPlaylist(streamJsonObject, playlistUrl);
            AudioStream audioStream = new AudioStream.Builder().setId(id2 + "-" + DeliveryMethod.HLS).setContent(hlsStreamUrl, true).setDeliveryMethod(DeliveryMethod.HLS).setMediaFormat(format).setAverageBitrate(-1).setManifestUrl(playlistUrl).build();
            if (!Stream.containSimilarStream(audioStream, this.audioStreams)) {
                this.audioStreams.add(audioStream);
            }
        }
        if (!Utils.isNullOrEmpty(torrentUrl = JsonUtils.getString(streamJsonObject, "torrentUrl"))) {
            this.audioStreams.add(new AudioStream.Builder().setId(id2 + "-" + idSuffix + "-" + DeliveryMethod.TORRENT).setContent(torrentUrl, true).setDeliveryMethod(DeliveryMethod.TORRENT).setMediaFormat(format).setAverageBitrate(-1).build());
        }
    }

    private void addNewVideoStream(@Nonnull JsonObject streamJsonObject, boolean isInstanceUsingRandomUuidsForHlsStreams, @Nonnull String resolution, @Nonnull String idSuffix, @Nonnull String url, @Nullable String playlistUrl) throws ParsingException {
        String torrentUrl;
        String extension = url.substring(url.lastIndexOf(".") + 1);
        MediaFormat format = MediaFormat.getFromSuffix(extension);
        String id2 = resolution + "-" + extension;
        boolean isVideoOnly = streamJsonObject.has("hasAudio") && !streamJsonObject.getBoolean("hasAudio");
        this.videoStreams.add(new VideoStream.Builder().setId(id2 + "-" + idSuffix + "-" + DeliveryMethod.PROGRESSIVE_HTTP).setContent(url, true).setIsVideoOnly(isVideoOnly).setResolution(resolution).setMediaFormat(format).build());
        if (!Utils.isNullOrEmpty(playlistUrl)) {
            String hlsStreamUrl = isInstanceUsingRandomUuidsForHlsStreams ? this.getHlsPlaylistUrlFromFragmentedFileUrl(streamJsonObject, idSuffix, extension, url) : this.getHlsPlaylistUrlFromMasterPlaylist(streamJsonObject, playlistUrl);
            VideoStream videoStream = new VideoStream.Builder().setId(id2 + "-" + DeliveryMethod.HLS).setContent(hlsStreamUrl, true).setIsVideoOnly(isVideoOnly).setDeliveryMethod(DeliveryMethod.HLS).setResolution(resolution).setMediaFormat(format).setManifestUrl(playlistUrl).build();
            if (!Stream.containSimilarStream(videoStream, this.videoStreams)) {
                this.videoStreams.add(videoStream);
            }
        }
        if (!Utils.isNullOrEmpty(torrentUrl = JsonUtils.getString(streamJsonObject, "torrentUrl"))) {
            this.videoStreams.add(new VideoStream.Builder().setId(id2 + "-" + idSuffix + "-" + DeliveryMethod.TORRENT).setContent(torrentUrl, true).setIsVideoOnly(isVideoOnly).setDeliveryMethod(DeliveryMethod.TORRENT).setResolution(resolution).setMediaFormat(format).build());
        }
    }

    @Nullable
    private JsonObject fetchSubApiContent(@Nonnull String subPath) throws ParsingException, IOException, ReCaptchaException {
        String apiUrl = this.baseUrl + "/api/v1/videos/" + this.getId() + "/" + subPath;
        Response response = this.getDownloader().get(apiUrl);
        if (response == null) {
            throw new ParsingException("Could not get segments from API.");
        }
        if (response.responseCode() == 400) {
            return null;
        }
        if (response.responseCode() != 200) {
            throw new ParsingException("Could not get segments from API. Response code: " + response.responseCode());
        }
        try {
            return JsonParser.object().from(response.responseBody());
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse json data for segments", e);
        }
    }

    @Override
    @Nonnull
    public String getName() throws ParsingException {
        return JsonUtils.getString(this.json, "name");
    }

    @Override
    @Nonnull
    public String getHost() throws ParsingException {
        return JsonUtils.getString(this.json, ACCOUNT_HOST);
    }

    @Override
    @Nonnull
    public StreamExtractor.Privacy getPrivacy() {
        switch (this.json.getObject("privacy").getInt("id")) {
            case 1: {
                return StreamExtractor.Privacy.PUBLIC;
            }
            case 2: {
                return StreamExtractor.Privacy.UNLISTED;
            }
            case 3: {
                return StreamExtractor.Privacy.PRIVATE;
            }
            case 4: {
                return StreamExtractor.Privacy.INTERNAL;
            }
        }
        return StreamExtractor.Privacy.OTHER;
    }

    @Override
    @Nonnull
    public String getCategory() throws ParsingException {
        return JsonUtils.getString(this.json, "category.label");
    }

    @Override
    @Nonnull
    public String getLicence() throws ParsingException {
        return JsonUtils.getString(this.json, "licence.label");
    }

    @Override
    public Locale getLanguageInfo() {
        try {
            return new Locale(JsonUtils.getString(this.json, "language.id"));
        }
        catch (ParsingException e) {
            return null;
        }
    }
}

