/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.media_ccc.extractors.infoItems;

import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.DateWrapper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.media_ccc.extractors.MediaCCCParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamType;

public class MediaCCCStreamInfoItemExtractor
implements StreamInfoItemExtractor {
    private final JsonObject event;

    public MediaCCCStreamInfoItemExtractor(JsonObject event) {
        this.event = event;
    }

    @Override
    public StreamType getStreamType() {
        return StreamType.VIDEO_STREAM;
    }

    @Override
    public boolean isAd() {
        return false;
    }

    @Override
    public long getDuration() {
        return this.event.getInt("length");
    }

    @Override
    public long getViewCount() {
        return this.event.getInt("view_count");
    }

    @Override
    public String getUploaderName() {
        return this.event.getString("conference_title");
    }

    @Override
    public String getUploaderUrl() {
        return this.event.getString("conference_url");
    }

    @Override
    public boolean isUploaderVerified() throws ParsingException {
        return false;
    }

    @Override
    @Nullable
    public String getTextualUploadDate() {
        return this.event.getString("release_date");
    }

    @Override
    @Nullable
    public DateWrapper getUploadDate() throws ParsingException {
        return DateWrapper.fromOffsetDateTime(this.getTextualUploadDate());
    }

    @Override
    public String getName() throws ParsingException {
        return this.event.getString("title");
    }

    @Override
    public String getUrl() throws ParsingException {
        return "https://media.ccc.de/public/events/" + this.event.getString("guid");
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() {
        return MediaCCCParsingHelper.getThumbnailsFromStreamItem(this.event);
    }
}

