/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.media_ccc.extractors;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.DateWrapper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.media_ccc.extractors.MediaCCCParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.media_ccc.linkHandler.MediaCCCConferenceLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamType;

public class MediaCCCRecentKioskExtractor
implements StreamInfoItemExtractor {
    private final JsonObject event;

    public MediaCCCRecentKioskExtractor(JsonObject event) {
        this.event = event;
    }

    @Override
    public String getName() throws ParsingException {
        return this.event.getString("title");
    }

    @Override
    public String getUrl() throws ParsingException {
        return this.event.getString("frontend_link");
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        return MediaCCCParsingHelper.getImageListFromLogoImageUrl(this.event.getString("poster_url"));
    }

    @Override
    public StreamType getStreamType() throws ParsingException {
        return StreamType.VIDEO_STREAM;
    }

    @Override
    public boolean isAd() {
        return false;
    }

    @Override
    public long getDuration() {
        return this.event.getInt("duration");
    }

    @Override
    public long getViewCount() throws ParsingException {
        return this.event.getInt("view_count");
    }

    @Override
    public String getUploaderName() throws ParsingException {
        return this.event.getString("conference_title");
    }

    @Override
    public String getUploaderUrl() throws ParsingException {
        return MediaCCCConferenceLinkHandlerFactory.getInstance().fromUrl(this.event.getString("conference_url")).getUrl();
    }

    @Override
    public boolean isUploaderVerified() throws ParsingException {
        return false;
    }

    @Override
    @Nullable
    public String getTextualUploadDate() throws ParsingException {
        return this.event.getString("date");
    }

    @Override
    @Nullable
    public DateWrapper getUploadDate() throws ParsingException {
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(this.event.getString("date"), DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSzzzz"));
        return new DateWrapper(zonedDateTime.toInstant());
    }
}

