/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors;

import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.BandcampExtractorHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class BandcampPlaylistInfoItemFeaturedExtractor
implements PlaylistInfoItemExtractor {
    private final JsonObject featuredStory;

    public BandcampPlaylistInfoItemFeaturedExtractor(JsonObject featuredStory) {
        this.featuredStory = featuredStory;
    }

    @Override
    public String getUploaderName() {
        return this.featuredStory.getString("band_name");
    }

    @Override
    public String getUploaderUrl() {
        return null;
    }

    @Override
    public boolean isUploaderVerified() {
        return false;
    }

    @Override
    public long getStreamCount() {
        return this.featuredStory.getInt("num_streamable_tracks");
    }

    @Override
    public String getName() {
        return this.featuredStory.getString("album_title");
    }

    @Override
    public String getUrl() {
        return Utils.replaceHttpWithHttps(this.featuredStory.getString("item_url"));
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() {
        return this.featuredStory.has("art_id") ? BandcampExtractorHelper.getImagesFromImageId(this.featuredStory.getLong("art_id"), true) : BandcampExtractorHelper.getImagesFromImageId(this.featuredStory.getLong("item_art_id"), true);
    }
}

