/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.localization;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.DateWrapper;
import org.watermedia.shaded.schabi.newpipe.extractor.timeago.PatternsHolder;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Parser;

public class TimeAgoParser {
    private final PatternsHolder patternsHolder;
    private final LocalDateTime now;

    public TimeAgoParser(PatternsHolder patternsHolder, LocalDateTime now) {
        this.patternsHolder = patternsHolder;
        this.now = now;
    }

    public DateWrapper parse(String textualDate) throws ParsingException {
        for (Map.Entry<ChronoUnit, Map<String, Integer>> caseUnitEntry : this.patternsHolder.specialCases().entrySet()) {
            ChronoUnit chronoUnit = caseUnitEntry.getKey();
            for (Map.Entry<String, Integer> caseMapToAmountEntry : caseUnitEntry.getValue().entrySet()) {
                String caseText = caseMapToAmountEntry.getKey();
                int caseAmount = caseMapToAmountEntry.getValue();
                if (!this.textualDateMatches(textualDate, caseText)) continue;
                return this.getResultFor(caseAmount, chronoUnit);
            }
        }
        return this.getResultFor(this.parseTimeAgoAmount(textualDate), this.parseChronoUnit(textualDate));
    }

    private int parseTimeAgoAmount(String textualDate) {
        try {
            return Integer.parseInt(textualDate.replaceAll("\\D+", ""));
        }
        catch (NumberFormatException ignored) {
            return 1;
        }
    }

    private ChronoUnit parseChronoUnit(String textualDate) throws ParsingException {
        return this.patternsHolder.asMap().entrySet().stream().filter(e -> ((Collection)e.getValue()).stream().anyMatch(agoPhrase -> this.textualDateMatches(textualDate, (String)agoPhrase))).map(Map.Entry::getKey).findFirst().orElseThrow(() -> new ParsingException("Unable to parse the date: " + textualDate));
    }

    private boolean textualDateMatches(String textualDate, String agoPhrase) {
        if (textualDate.equals(agoPhrase)) {
            return true;
        }
        if (this.patternsHolder.wordSeparator().isEmpty()) {
            return textualDate.toLowerCase().contains(agoPhrase.toLowerCase());
        }
        String escapedPhrase = Pattern.quote(agoPhrase.toLowerCase());
        String escapedSeparator = this.patternsHolder.wordSeparator().equals(" ") ? "[ \\t\\xA0\\u1680\\u180e\\u2000-\\u200a\\u202f\\u205f\\u3000\\d]" : Pattern.quote(this.patternsHolder.wordSeparator());
        String pattern = "(^|" + escapedSeparator + ")" + escapedPhrase + "($|" + escapedSeparator + ")";
        return Parser.isMatch(pattern, textualDate.toLowerCase());
    }

    private DateWrapper getResultFor(int timeAgoAmount, ChronoUnit chronoUnit) {
        LocalDateTime localDateTime = chronoUnit == ChronoUnit.YEARS ? this.now.minusYears(timeAgoAmount).minusDays(1L) : this.now.minus(timeAgoAmount, chronoUnit);
        boolean isApproximate = chronoUnit.isDateBased();
        LocalDateTime resolvedDateTime = isApproximate ? localDateTime.truncatedTo(ChronoUnit.DAYS) : localDateTime;
        return new DateWrapper(resolvedDateTime, isApproximate);
    }
}

