/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.localization;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;

public class DateWrapper
implements Serializable {
    @Nonnull
    private final Instant instant;
    private final boolean isApproximation;

    public DateWrapper(@Nonnull OffsetDateTime offsetDateTime) {
        this(offsetDateTime, false);
    }

    public DateWrapper(@Nonnull OffsetDateTime offsetDateTime, boolean isApproximation) {
        this(offsetDateTime.toInstant(), isApproximation);
    }

    public DateWrapper(@Nonnull Instant instant) {
        this(instant, false);
    }

    public DateWrapper(@Nonnull Instant instant, boolean isApproximation) {
        this.instant = instant;
        this.isApproximation = isApproximation;
    }

    public DateWrapper(@Nonnull LocalDateTime dateTime, boolean isApproximation) {
        this(dateTime.atZone(ZoneId.systemDefault()).toInstant(), isApproximation);
    }

    @Nonnull
    public Instant getInstant() {
        return this.instant;
    }

    @Nonnull
    public OffsetDateTime offsetDateTime() {
        return this.instant.atOffset(ZoneOffset.UTC);
    }

    @Nonnull
    public LocalDateTime getLocalDateTime() {
        return this.getLocalDateTime(ZoneId.systemDefault());
    }

    @Nonnull
    public LocalDateTime getLocalDateTime(@Nonnull ZoneId zoneId) {
        return LocalDateTime.ofInstant(this.instant, zoneId);
    }

    public boolean isApproximation() {
        return this.isApproximation;
    }

    public String toString() {
        return "DateWrapper{instant=" + this.instant + ", isApproximation=" + this.isApproximation + "}";
    }

    @Nullable
    public static DateWrapper fromOffsetDateTime(String date) throws ParsingException {
        try {
            return date != null ? new DateWrapper(OffsetDateTime.parse(date)) : null;
        }
        catch (DateTimeParseException e) {
            throw new ParsingException("Could not parse date: \"" + date + "\"", e);
        }
    }

    @Nullable
    public static DateWrapper fromInstant(String date) throws ParsingException {
        try {
            return date != null ? new DateWrapper(Instant.parse(date)) : null;
        }
        catch (DateTimeParseException e) {
            throw new ParsingException("Could not parse date: \"" + date + "\"", e);
        }
    }
}

