/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.jsoup.select;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.watermedia.shaded.jsoup.helper.Regex;
import org.watermedia.shaded.jsoup.helper.Validate;
import org.watermedia.shaded.jsoup.internal.Normalizer;
import org.watermedia.shaded.jsoup.internal.StringUtil;
import org.watermedia.shaded.jsoup.nodes.CDataNode;
import org.watermedia.shaded.jsoup.nodes.Comment;
import org.watermedia.shaded.jsoup.nodes.DataNode;
import org.watermedia.shaded.jsoup.nodes.LeafNode;
import org.watermedia.shaded.jsoup.nodes.Node;
import org.watermedia.shaded.jsoup.nodes.TextNode;
import org.watermedia.shaded.jsoup.parser.TokenQueue;
import org.watermedia.shaded.jsoup.select.CombiningEvaluator;
import org.watermedia.shaded.jsoup.select.Evaluator;
import org.watermedia.shaded.jsoup.select.NodeEvaluator;
import org.watermedia.shaded.jsoup.select.Selector;
import org.watermedia.shaded.jsoup.select.StructuralEvaluator;

public class QueryParser
implements AutoCloseable {
    private static final char[] Combinators = new char[]{'>', '+', '~'};
    private static final String[] AttributeEvals = new String[]{"=", "!=", "^=", "$=", "*=", "~="};
    private static final char[] SequenceEnders = new char[]{',', ')'};
    private final TokenQueue tq;
    private final String query;
    private boolean inNodeContext;
    private static final Pattern NthStepOffset = Pattern.compile("(([+-])?(\\d+)?)n(\\s*([+-])?\\s*\\d+)?", 2);
    private static final Pattern NthOffset = Pattern.compile("([+-])?(\\d+)");

    private QueryParser(String query) {
        Validate.notEmpty(query);
        this.query = query = query.trim();
        this.tq = new TokenQueue(query);
    }

    public static Evaluator parse(String query) {
        QueryParser p = new QueryParser(query);
        try {
            Evaluator evaluator = p.parse();
            p.close();
            return evaluator;
        }
        catch (Throwable throwable) {
            try {
                try {
                    p.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IllegalArgumentException e) {
                throw new Selector.SelectorParseException(e.getMessage());
            }
        }
    }

    Evaluator parse() {
        Evaluator eval = this.parseSelectorGroup();
        this.tq.consumeWhitespace();
        if (!this.tq.isEmpty()) {
            throw new Selector.SelectorParseException("Could not parse query '%s': unexpected token at '%s'", this.query, this.tq.remainder());
        }
        return eval;
    }

    Evaluator parseSelectorGroup() {
        Evaluator left = this.parseSelector();
        while (this.tq.matchChomp(',')) {
            Evaluator right = this.parseSelector();
            left = QueryParser.or(left, right);
        }
        return left;
    }

    Evaluator parseSelector() {
        this.tq.consumeWhitespace();
        Evaluator left = this.tq.matchesAny(Combinators) ? new StructuralEvaluator.Root() : this.parseSimpleSequence();
        while (true) {
            char combinator = '\u0000';
            if (this.tq.consumeWhitespace()) {
                combinator = ' ';
            }
            if (this.tq.matchesAny(Combinators)) {
                combinator = this.tq.consume();
            } else if (this.tq.matchesAny(SequenceEnders)) break;
            if (combinator == '\u0000') break;
            Evaluator right = this.parseSimpleSequence();
            left = QueryParser.combinator(left, combinator, right);
        }
        return left;
    }

    Evaluator parseSimpleSequence() {
        Evaluator right;
        Evaluator left = null;
        this.tq.consumeWhitespace();
        if (this.tq.matchesWord() || this.tq.matches("*|")) {
            left = this.byTag();
        } else if (this.tq.matchChomp('*')) {
            left = new Evaluator.AllElements();
        }
        while ((right = this.parseSubclass()) != null) {
            left = QueryParser.and(left, right);
        }
        if (left == null) {
            throw new Selector.SelectorParseException("Could not parse query '%s': unexpected token at '%s'", this.query, this.tq.remainder());
        }
        return left;
    }

    static Evaluator combinator(Evaluator left, char combinator, Evaluator right) {
        switch (combinator) {
            case '>': {
                StructuralEvaluator.ImmediateParentRun run = left instanceof StructuralEvaluator.ImmediateParentRun ? (StructuralEvaluator.ImmediateParentRun)left : new StructuralEvaluator.ImmediateParentRun(left);
                run.add(right);
                return run;
            }
            case ' ': {
                return QueryParser.and(new StructuralEvaluator.Ancestor(left), right);
            }
            case '+': {
                return QueryParser.and(new StructuralEvaluator.ImmediatePreviousSibling(left), right);
            }
            case '~': {
                return QueryParser.and(new StructuralEvaluator.PreviousSibling(left), right);
            }
        }
        throw new Selector.SelectorParseException("Unknown combinator '%s'", Character.valueOf(combinator));
    }

    @Nullable Evaluator parseSubclass() {
        if (this.tq.matchChomp('#')) {
            return this.byId();
        }
        if (this.tq.matchChomp('.')) {
            return this.byClass();
        }
        if (this.tq.matches('[')) {
            return this.byAttribute();
        }
        if (this.tq.matchChomp("::")) {
            return this.parseNodeSelector();
        }
        if (this.tq.matchChomp(':')) {
            return this.parsePseudoSelector();
        }
        return null;
    }

    static Evaluator or(Evaluator left, Evaluator right) {
        if (left instanceof CombiningEvaluator.Or) {
            ((CombiningEvaluator.Or)left).add(right);
            return left;
        }
        return new CombiningEvaluator.Or(left, right);
    }

    static Evaluator and(@Nullable Evaluator left, Evaluator right) {
        if (left == null) {
            return right;
        }
        if (left instanceof CombiningEvaluator.And) {
            ((CombiningEvaluator.And)left).add(right);
            return left;
        }
        return new CombiningEvaluator.And(left, right);
    }

    private Evaluator parsePseudoSelector() {
        String pseudo;
        switch (pseudo = this.tq.consumeCssIdentifier()) {
            case "lt": {
                return new Evaluator.IndexLessThan(this.consumeIndex());
            }
            case "gt": {
                return new Evaluator.IndexGreaterThan(this.consumeIndex());
            }
            case "eq": {
                return new Evaluator.IndexEquals(this.consumeIndex());
            }
            case "has": {
                return this.has();
            }
            case "is": {
                return this.is();
            }
            case "contains": {
                return this.contains(false);
            }
            case "containsOwn": {
                return this.contains(true);
            }
            case "containsWholeText": {
                return this.containsWholeText(false);
            }
            case "containsWholeOwnText": {
                return this.containsWholeText(true);
            }
            case "containsData": {
                return this.containsData();
            }
            case "matches": {
                return this.matches(false);
            }
            case "matchesOwn": {
                return this.matches(true);
            }
            case "matchesWholeText": {
                return this.matchesWholeText(false);
            }
            case "matchesWholeOwnText": {
                return this.matchesWholeText(true);
            }
            case "not": {
                return this.not();
            }
            case "nth-child": {
                return this.cssNthChild(false, false);
            }
            case "nth-last-child": {
                return this.cssNthChild(true, false);
            }
            case "nth-of-type": {
                return this.cssNthChild(false, true);
            }
            case "nth-last-of-type": {
                return this.cssNthChild(true, true);
            }
            case "first-child": {
                return new Evaluator.IsFirstChild();
            }
            case "last-child": {
                return new Evaluator.IsLastChild();
            }
            case "first-of-type": {
                return new Evaluator.IsFirstOfType();
            }
            case "last-of-type": {
                return new Evaluator.IsLastOfType();
            }
            case "only-child": {
                return new Evaluator.IsOnlyChild();
            }
            case "only-of-type": {
                return new Evaluator.IsOnlyOfType();
            }
            case "empty": {
                return new Evaluator.IsEmpty();
            }
            case "blank": {
                return new NodeEvaluator.BlankValue();
            }
            case "root": {
                return new Evaluator.IsRoot();
            }
            case "matchText": {
                return new Evaluator.MatchText();
            }
        }
        throw new Selector.SelectorParseException("Could not parse query '%s': unexpected token at '%s'", this.query, this.tq.remainder());
    }

    private Evaluator parseNodeSelector() {
        Evaluator right;
        Evaluator left;
        String pseudo = this.tq.consumeCssIdentifier();
        this.inNodeContext = true;
        switch (pseudo) {
            case "node": {
                left = new NodeEvaluator.InstanceType(Node.class, pseudo);
                break;
            }
            case "leafnode": {
                left = new NodeEvaluator.InstanceType(LeafNode.class, pseudo);
                break;
            }
            case "text": {
                left = new NodeEvaluator.InstanceType(TextNode.class, pseudo);
                break;
            }
            case "org.watermedia.shaded.comment": {
                left = new NodeEvaluator.InstanceType(Comment.class, pseudo);
                break;
            }
            case "data": {
                left = new NodeEvaluator.InstanceType(DataNode.class, pseudo);
                break;
            }
            case "cdata": {
                left = new NodeEvaluator.InstanceType(CDataNode.class, pseudo);
                break;
            }
            default: {
                throw new Selector.SelectorParseException("Could not parse query '%s': unknown node type '::%s'", this.query, pseudo);
            }
        }
        while ((right = this.parseSubclass()) != null) {
            left = QueryParser.and(left, right);
        }
        this.inNodeContext = false;
        return left;
    }

    private Evaluator byId() {
        String id2 = this.tq.consumeCssIdentifier();
        Validate.notEmpty(id2);
        return new Evaluator.Id(id2);
    }

    private Evaluator byClass() {
        String className = this.tq.consumeCssIdentifier();
        Validate.notEmpty(className);
        return new Evaluator.Class(className.trim());
    }

    private Evaluator byTag() {
        String tagName = Normalizer.normalize(this.tq.consumeElementSelector());
        Validate.notEmpty(tagName);
        if (tagName.startsWith("*|")) {
            String plainTag = tagName.substring(2);
            return new CombiningEvaluator.Or(new Evaluator.Tag(plainTag), new Evaluator.TagEndsWith(":" + plainTag));
        }
        if (tagName.endsWith("|*")) {
            String ns = tagName.substring(0, tagName.length() - 2) + ":";
            return new Evaluator.TagStartsWith(ns);
        }
        if (tagName.contains("|")) {
            tagName = tagName.replace("|", ":");
        }
        return new Evaluator.Tag(tagName);
    }

    private Evaluator byAttribute() {
        try (TokenQueue cq = new TokenQueue(this.tq.chompBalanced('[', ']'));){
            Evaluator evaluator = this.evaluatorForAttribute(cq);
            return evaluator;
        }
    }

    private Evaluator evaluatorForAttribute(TokenQueue cq) {
        Evaluator eval;
        String key = cq.consumeToAny(AttributeEvals);
        key = Normalizer.normalize(key);
        Validate.notEmpty(key);
        Validate.isFalse(key.equals("abs:"), "Absolute attribute key must have a name");
        cq.consumeWhitespace();
        if (cq.isEmpty()) {
            eval = key.startsWith("^") ? new Evaluator.AttributeStarting(key.substring(1)) : (key.equals("*") ? new Evaluator.AttributeStarting("") : new Evaluator.Attribute(key));
        } else if (cq.matchChomp('=')) {
            eval = new Evaluator.AttributeWithValue(key, cq.remainder());
        } else if (cq.matchChomp("!=")) {
            eval = new Evaluator.AttributeWithValueNot(key, cq.remainder());
        } else if (cq.matchChomp("^=")) {
            eval = new Evaluator.AttributeWithValueStarting(key, cq.remainder());
        } else if (cq.matchChomp("$=")) {
            eval = new Evaluator.AttributeWithValueEnding(key, cq.remainder());
        } else if (cq.matchChomp("*=")) {
            eval = new Evaluator.AttributeWithValueContaining(key, cq.remainder());
        } else if (cq.matchChomp("~=")) {
            eval = new Evaluator.AttributeWithValueMatching(key, Regex.compile(cq.remainder()));
        } else {
            throw new Selector.SelectorParseException("Could not parse attribute query '%s': unexpected token at '%s'", this.query, cq.remainder());
        }
        return eval;
    }

    private Evaluator cssNthChild(boolean last, boolean ofType) {
        int offset;
        int step;
        String arg = Normalizer.normalize(this.consumeParens());
        if ("odd".equals(arg)) {
            step = 2;
            offset = 1;
        } else if ("even".equals(arg)) {
            step = 2;
            offset = 0;
        } else {
            Matcher stepOffsetM = NthStepOffset.matcher(arg);
            if (stepOffsetM.matches()) {
                step = stepOffsetM.group(3) != null ? Integer.parseInt(stepOffsetM.group(1).replaceFirst("^\\+", "")) : ("-".equals(stepOffsetM.group(2)) ? -1 : 1);
                offset = stepOffsetM.group(4) != null ? Integer.parseInt(stepOffsetM.group(4).replaceFirst("^\\+", "")) : 0;
            } else {
                Matcher stepM = NthOffset.matcher(arg);
                if (stepM.matches()) {
                    step = 0;
                    offset = Integer.parseInt(stepM.group().replaceFirst("^\\+", ""));
                } else {
                    throw new Selector.SelectorParseException("Could not parse nth-index '%s': unexpected format", arg);
                }
            }
        }
        return ofType ? (last ? new Evaluator.IsNthLastOfType(step, offset) : new Evaluator.IsNthOfType(step, offset)) : (last ? new Evaluator.IsNthLastChild(step, offset) : new Evaluator.IsNthChild(step, offset));
    }

    private String consumeParens() {
        return this.tq.chompBalanced('(', ')');
    }

    private int consumeIndex() {
        String index = this.consumeParens().trim();
        Validate.isTrue(StringUtil.isNumeric(index), "Index must be numeric");
        return Integer.parseInt(index);
    }

    private Evaluator has() {
        return this.parseNested(StructuralEvaluator.Has::new, ":has() must have a selector");
    }

    private Evaluator is() {
        return this.parseNested(StructuralEvaluator.Is::new, ":is() must have a selector");
    }

    private Evaluator parseNested(Function<Evaluator, Evaluator> func, String err) {
        Validate.isTrue(this.tq.matchChomp('('), err);
        Evaluator eval = this.parseSelectorGroup();
        Validate.isTrue(this.tq.matchChomp(')'), err);
        return func.apply(eval);
    }

    private Evaluator contains(boolean own) {
        String query = own ? ":containsOwn" : ":contains";
        String searchText = TokenQueue.unescape(this.consumeParens());
        Validate.notEmpty(searchText, query + "(text) query must not be empty");
        if (this.inNodeContext) {
            return new NodeEvaluator.ContainsValue(searchText);
        }
        return own ? new Evaluator.ContainsOwnText(searchText) : new Evaluator.ContainsText(searchText);
    }

    private Evaluator containsWholeText(boolean own) {
        String query = own ? ":containsWholeOwnText" : ":containsWholeText";
        String searchText = TokenQueue.unescape(this.consumeParens());
        Validate.notEmpty(searchText, query + "(text) query must not be empty");
        return own ? new Evaluator.ContainsWholeOwnText(searchText) : new Evaluator.ContainsWholeText(searchText);
    }

    private Evaluator containsData() {
        String searchText = TokenQueue.unescape(this.consumeParens());
        Validate.notEmpty(searchText, ":containsData(text) query must not be empty");
        return new Evaluator.ContainsData(searchText);
    }

    private Evaluator matches(boolean own) {
        String query = own ? ":matchesOwn" : ":matches";
        String regex = this.consumeParens();
        Validate.notEmpty(regex, query + "(regex) query must not be empty");
        Regex pattern = Regex.compile(regex);
        if (this.inNodeContext) {
            return new NodeEvaluator.MatchesValue(pattern);
        }
        return own ? new Evaluator.MatchesOwn(pattern) : new Evaluator.Matches(pattern);
    }

    private Evaluator matchesWholeText(boolean own) {
        String query = own ? ":matchesWholeOwnText" : ":matchesWholeText";
        String regex = this.consumeParens();
        Validate.notEmpty(regex, query + "(regex) query must not be empty");
        Regex pattern = Regex.compile(regex);
        return own ? new Evaluator.MatchesWholeOwnText(pattern) : new Evaluator.MatchesWholeText(pattern);
    }

    private Evaluator not() {
        String subQuery = this.consumeParens();
        Validate.notEmpty(subQuery, ":not(selector) subselect must not be empty");
        return new StructuralEvaluator.Not(QueryParser.parse(subQuery));
    }

    public String toString() {
        return this.query;
    }

    @Override
    public void close() {
        this.tq.close();
    }
}

