/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.jsoup.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.watermedia.shaded.jsoup.helper.Validate;
import org.watermedia.shaded.jsoup.internal.StringUtil;
import org.watermedia.shaded.jsoup.nodes.Comment;
import org.watermedia.shaded.jsoup.nodes.DataNode;
import org.watermedia.shaded.jsoup.nodes.Element;
import org.watermedia.shaded.jsoup.nodes.FormElement;
import org.watermedia.shaded.jsoup.nodes.Node;
import org.watermedia.shaded.jsoup.nodes.TextNode;
import org.watermedia.shaded.jsoup.select.Evaluator;
import org.watermedia.shaded.jsoup.select.NodeFilter;
import org.watermedia.shaded.jsoup.select.NodeTraversor;
import org.watermedia.shaded.jsoup.select.NodeVisitor;
import org.watermedia.shaded.jsoup.select.Nodes;
import org.watermedia.shaded.jsoup.select.Selector;

public class Elements
extends Nodes<Element> {
    public Elements() {
    }

    public Elements(int initialCapacity) {
        super(initialCapacity);
    }

    public Elements(Collection<Element> elements) {
        super(elements);
    }

    public Elements(List<Element> elements) {
        super(elements);
    }

    public Elements(Element ... elements) {
        super(Arrays.asList(elements));
    }

    @Override
    public Elements clone() {
        Elements clone = new Elements(this.size());
        for (Element e : this) {
            clone.add(e.clone());
        }
        return clone;
    }

    @Override
    public ArrayList<Element> asList() {
        return new ArrayList<Element>(this);
    }

    public String attr(String attributeKey) {
        for (Element element : this) {
            if (!element.hasAttr(attributeKey)) continue;
            return element.attr(attributeKey);
        }
        return "";
    }

    public boolean hasAttr(String attributeKey) {
        for (Element element : this) {
            if (!element.hasAttr(attributeKey)) continue;
            return true;
        }
        return false;
    }

    public List<String> eachAttr(String attributeKey) {
        ArrayList<String> attrs = new ArrayList<String>(this.size());
        for (Element element : this) {
            if (!element.hasAttr(attributeKey)) continue;
            attrs.add(element.attr(attributeKey));
        }
        return attrs;
    }

    public Elements attr(String attributeKey, String attributeValue) {
        for (Element element : this) {
            element.attr(attributeKey, attributeValue);
        }
        return this;
    }

    public Elements removeAttr(String attributeKey) {
        for (Element element : this) {
            element.removeAttr(attributeKey);
        }
        return this;
    }

    public Elements addClass(String className) {
        for (Element element : this) {
            element.addClass(className);
        }
        return this;
    }

    public Elements removeClass(String className) {
        for (Element element : this) {
            element.removeClass(className);
        }
        return this;
    }

    public Elements toggleClass(String className) {
        for (Element element : this) {
            element.toggleClass(className);
        }
        return this;
    }

    public boolean hasClass(String className) {
        for (Element element : this) {
            if (!element.hasClass(className)) continue;
            return true;
        }
        return false;
    }

    public String val() {
        if (this.size() > 0) {
            return this.first().val();
        }
        return "";
    }

    public Elements val(String value) {
        for (Element element : this) {
            element.val(value);
        }
        return this;
    }

    public String text() {
        return this.stream().map(Element::text).collect(StringUtil.joining(" "));
    }

    public boolean hasText() {
        for (Element element : this) {
            if (!element.hasText()) continue;
            return true;
        }
        return false;
    }

    public List<String> eachText() {
        ArrayList<String> texts = new ArrayList<String>(this.size());
        for (Element el2 : this) {
            if (!el2.hasText()) continue;
            texts.add(el2.text());
        }
        return texts;
    }

    public String html() {
        return this.stream().map(Element::html).collect(StringUtil.joining("\n"));
    }

    public Elements tagName(String tagName) {
        for (Element element : this) {
            element.tagName(tagName);
        }
        return this;
    }

    public Elements html(String html) {
        for (Element element : this) {
            element.html(html);
        }
        return this;
    }

    public Elements prepend(String html) {
        for (Element element : this) {
            element.prepend(html);
        }
        return this;
    }

    public Elements append(String html) {
        for (Element element : this) {
            element.append(html);
        }
        return this;
    }

    public Elements before(String html) {
        super.before(html);
        return this;
    }

    public Elements after(String html) {
        super.after(html);
        return this;
    }

    public Elements wrap(String html) {
        super.wrap(html);
        return this;
    }

    public Elements unwrap() {
        for (Element element : this) {
            element.unwrap();
        }
        return this;
    }

    public Elements empty() {
        for (Element element : this) {
            element.empty();
        }
        return this;
    }

    public Elements remove() {
        super.remove();
        return this;
    }

    public Elements select(String query) {
        return Selector.select(query, this);
    }

    public @Nullable Element selectFirst(String cssQuery) {
        return Selector.selectFirst(cssQuery, this);
    }

    public Element expectFirst(String cssQuery) {
        return Validate.expectNotNull(Selector.selectFirst(cssQuery, this), "No elements matched the query '%s' in the elements.", cssQuery);
    }

    public Elements not(String query) {
        Elements out = Selector.select(query, this);
        return Selector.filterOut(this, out);
    }

    public Elements eq(int index) {
        return this.size() > index ? new Elements((Element)this.get(index)) : new Elements();
    }

    public boolean is(String query) {
        Evaluator eval = Selector.evaluatorOf(query);
        for (Element e : this) {
            if (!e.is(eval)) continue;
            return true;
        }
        return false;
    }

    public Elements next() {
        return this.siblings(null, true, false);
    }

    public Elements next(String query) {
        return this.siblings(query, true, false);
    }

    public Elements nextAll() {
        return this.siblings(null, true, true);
    }

    public Elements nextAll(String query) {
        return this.siblings(query, true, true);
    }

    public Elements prev() {
        return this.siblings(null, false, false);
    }

    public Elements prev(String query) {
        return this.siblings(query, false, false);
    }

    public Elements prevAll() {
        return this.siblings(null, false, true);
    }

    public Elements prevAll(String query) {
        return this.siblings(query, false, true);
    }

    private Elements siblings(@Nullable String query, boolean next, boolean all) {
        Elements els = new Elements();
        Evaluator eval = query != null ? Selector.evaluatorOf(query) : null;
        block0: for (Element e : this) {
            Element sib;
            while ((sib = next ? e.nextElementSibling() : e.previousElementSibling()) != null) {
                if (eval == null || sib.is(eval)) {
                    els.add(sib);
                }
                e = sib;
                if (all) continue;
                continue block0;
            }
        }
        return els;
    }

    public Elements parents() {
        LinkedHashSet<Element> combo = new LinkedHashSet<Element>();
        for (Element e : this) {
            combo.addAll(e.parents());
        }
        return new Elements((Collection<Element>)combo);
    }

    @Override
    public @Nullable Element first() {
        return (Element)super.first();
    }

    @Override
    public @Nullable Element last() {
        return (Element)super.last();
    }

    public Elements traverse(NodeVisitor nodeVisitor) {
        NodeTraversor.traverse(nodeVisitor, this);
        return this;
    }

    public Elements filter(NodeFilter nodeFilter) {
        NodeTraversor.filter(nodeFilter, this);
        return this;
    }

    public List<FormElement> forms() {
        ArrayList<FormElement> forms = new ArrayList<FormElement>();
        for (Element el2 : this) {
            if (!(el2 instanceof FormElement)) continue;
            forms.add((FormElement)el2);
        }
        return forms;
    }

    public List<Comment> comments() {
        return this.childNodesOfType(Comment.class);
    }

    public List<TextNode> textNodes() {
        return this.childNodesOfType(TextNode.class);
    }

    public List<DataNode> dataNodes() {
        return this.childNodesOfType(DataNode.class);
    }

    private <T extends Node> List<T> childNodesOfType(Class<T> tClass) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Element el2 : this) {
            for (int i = 0; i < el2.childNodeSize(); ++i) {
                Node node = el2.childNode(i);
                if (!tClass.isInstance(node)) continue;
                nodes.add((Node)tClass.cast(node));
            }
        }
        return nodes;
    }

    @Override
    public Element set(int index, Element element) {
        return super.set(index, element);
    }

    @Override
    public Element remove(int index) {
        return (Element)super.remove(index);
    }

    @Override
    public Element deselect(int index) {
        return (Element)super.deselect(index);
    }
}

