/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.jsoup.select;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.watermedia.shaded.jsoup.nodes.Element;
import org.watermedia.shaded.jsoup.nodes.Node;
import org.watermedia.shaded.jsoup.select.Elements;
import org.watermedia.shaded.jsoup.select.Evaluator;
import org.watermedia.shaded.jsoup.select.Nodes;

public class Collector {
    private Collector() {
    }

    public static Elements collect(Evaluator eval, Element root) {
        Stream<Element> stream = eval.wantsNodes() ? Collector.streamNodes(eval, root, Element.class) : Collector.stream(eval, root);
        Elements els = stream.collect(Collectors.toCollection(Elements::new));
        eval.reset();
        return els;
    }

    public static Stream<Element> stream(Evaluator evaluator, Element root) {
        evaluator.reset();
        return root.stream().filter(evaluator.asPredicate(root));
    }

    public static <T extends Node> Stream<T> streamNodes(Evaluator evaluator, Element root, Class<T> type) {
        evaluator.reset();
        return root.nodeStream(type).filter(evaluator.asNodePredicate(root));
    }

    public static @Nullable Element findFirst(Evaluator eval, Element root) {
        Element el2 = Collector.stream(eval, root).findFirst().orElse(null);
        eval.reset();
        return el2;
    }

    public static <T extends Node> @Nullable T findFirstNode(Evaluator eval, Element root, Class<T> type) {
        Node node = Collector.streamNodes(eval, root, type).findFirst().orElse(null);
        eval.reset();
        return (T)node;
    }

    public static <T extends Node> Nodes<T> collectNodes(Evaluator evaluator, Element root, Class<T> type) {
        return Collector.streamNodes(evaluator, root, type).collect(Collectors.toCollection(Nodes::new));
    }
}

