/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.jsoup.parser;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.watermedia.shaded.jsoup.helper.Validate;
import org.watermedia.shaded.jsoup.nodes.Attributes;
import org.watermedia.shaded.jsoup.nodes.Document;
import org.watermedia.shaded.jsoup.nodes.Element;
import org.watermedia.shaded.jsoup.nodes.Node;
import org.watermedia.shaded.jsoup.nodes.Range;
import org.watermedia.shaded.jsoup.parser.CharacterReader;
import org.watermedia.shaded.jsoup.parser.ParseError;
import org.watermedia.shaded.jsoup.parser.ParseErrorList;
import org.watermedia.shaded.jsoup.parser.ParseSettings;
import org.watermedia.shaded.jsoup.parser.Parser;
import org.watermedia.shaded.jsoup.parser.Tag;
import org.watermedia.shaded.jsoup.parser.TagSet;
import org.watermedia.shaded.jsoup.parser.Token;
import org.watermedia.shaded.jsoup.parser.Tokeniser;
import org.watermedia.shaded.jsoup.select.NodeVisitor;

abstract class TreeBuilder {
    protected Parser parser;
    CharacterReader reader;
    Tokeniser tokeniser;
    Document doc;
    ArrayList<Element> stack;
    String baseUri;
    Token currentToken;
    ParseSettings settings;
    TagSet tagSet;
    @Nullable NodeVisitor nodeListener;
    private Token.StartTag start;
    private final Token.EndTag end = new Token.EndTag(this);
    boolean trackSourceRange;

    TreeBuilder() {
    }

    abstract ParseSettings defaultSettings();

    void initialiseParse(Reader input, String baseUri, Parser parser) {
        Validate.notNullParam(input, "input");
        Validate.notNullParam(baseUri, "baseUri");
        Validate.notNull(parser);
        this.doc = new Document(parser.defaultNamespace(), baseUri);
        this.doc.parser(parser);
        this.parser = parser;
        this.settings = parser.settings();
        this.reader = new CharacterReader(input);
        this.trackSourceRange = parser.isTrackPosition();
        this.reader.trackNewlines(parser.isTrackErrors() || this.trackSourceRange);
        if (parser.isTrackErrors()) {
            parser.getErrors().clear();
        }
        this.tokeniser = new Tokeniser(this);
        this.stack = new ArrayList(32);
        this.tagSet = parser.tagSet();
        this.start = new Token.StartTag(this);
        this.currentToken = this.start;
        this.baseUri = baseUri;
        this.onNodeInserted(this.doc);
    }

    void completeParse() {
        if (this.reader == null) {
            return;
        }
        this.reader.close();
        this.reader = null;
        this.tokeniser = null;
        this.stack = null;
    }

    Document parse(Reader input, String baseUri, Parser parser) {
        this.initialiseParse(input, baseUri, parser);
        this.runParser();
        return this.doc;
    }

    List<Node> parseFragment(Reader inputFragment, @Nullable Element context, String baseUri, Parser parser) {
        this.initialiseParse(inputFragment, baseUri, parser);
        this.initialiseParseFragment(context);
        this.runParser();
        return this.completeParseFragment();
    }

    void initialiseParseFragment(@Nullable Element context) {
    }

    abstract List<Node> completeParseFragment();

    void nodeListener(NodeVisitor nodeListener) {
        this.nodeListener = nodeListener;
    }

    abstract TreeBuilder newInstance();

    void runParser() {
        while (this.stepParser()) {
        }
        this.completeParse();
    }

    boolean stepParser() {
        Token token;
        if (this.currentToken.type == Token.TokenType.EOF) {
            if (this.stack == null) {
                return false;
            }
            if (this.stack.isEmpty()) {
                this.onNodeClosed(this.doc);
                this.stack = null;
                return true;
            }
            this.pop();
            return true;
        }
        this.currentToken = token = this.tokeniser.read();
        this.process(token);
        token.reset();
        return true;
    }

    abstract boolean process(Token var1);

    boolean processStartTag(String name) {
        Token.StartTag start = this.start;
        if (this.currentToken == start) {
            return this.process(new Token.StartTag(this).name(name));
        }
        return this.process(start.reset().name(name));
    }

    boolean processStartTag(String name, Attributes attrs) {
        Token.StartTag start = this.start;
        if (this.currentToken == start) {
            return this.process(new Token.StartTag(this).nameAttr(name, attrs));
        }
        start.reset();
        start.nameAttr(name, attrs);
        return this.process(start);
    }

    boolean processEndTag(String name) {
        if (this.currentToken == this.end) {
            return this.process(new Token.EndTag(this).name(name));
        }
        return this.process(this.end.reset().name(name));
    }

    Element pop() {
        int size = this.stack.size();
        Element removed = this.stack.remove(size - 1);
        this.onNodeClosed(removed);
        return removed;
    }

    final void push(Element element) {
        this.stack.add(element);
        this.onNodeInserted(element);
    }

    final void enforceStackDepthLimit() {
        int maxDepth = this.parser.getMaxDepth();
        if (maxDepth == Integer.MAX_VALUE) {
            return;
        }
        while (this.stack.size() >= maxDepth) {
            Element trimmed = this.pop();
            this.onStackPrunedForDepth(trimmed);
        }
    }

    void onStackPrunedForDepth(Element element) {
    }

    int defaultMaxDepth() {
        return 512;
    }

    Element currentElement() {
        int size = this.stack.size();
        return size > 0 ? this.stack.get(size - 1) : this.doc;
    }

    boolean currentElementIs(String normalName) {
        if (this.stack.size() == 0) {
            return false;
        }
        Element current = this.currentElement();
        return current != null && current.normalName().equals(normalName) && current.tag().namespace().equals("http://www.w3.org/1999/xhtml");
    }

    boolean currentElementIs(String normalName, String namespace) {
        if (this.stack.size() == 0) {
            return false;
        }
        Element current = this.currentElement();
        return current != null && current.normalName().equals(normalName) && current.tag().namespace().equals(namespace);
    }

    void error(String msg) {
        this.error(msg, null);
    }

    void error(String msg, Object ... args) {
        ParseErrorList errors = this.parser.getErrors();
        if (errors.canAddError()) {
            errors.add(new ParseError(this.reader, msg, args));
        }
    }

    Tag tagFor(String tagName, String normalName, String namespace, ParseSettings settings) {
        return this.tagSet.valueOf(tagName, normalName, namespace, settings.preserveTagCase());
    }

    Tag tagFor(Token.Tag token) {
        return this.tagSet.valueOf(token.name(), token.normalName, this.defaultNamespace(), this.settings.preserveTagCase());
    }

    String defaultNamespace() {
        return "http://www.w3.org/1999/xhtml";
    }

    TagSet defaultTagSet() {
        return TagSet.Html();
    }

    void onNodeInserted(Node node) {
        this.trackNodePosition(node, true);
        if (this.nodeListener != null) {
            this.nodeListener.head(node, this.stack.size());
        }
    }

    void onNodeClosed(Node node) {
        this.trackNodePosition(node, false);
        if (this.nodeListener != null) {
            this.nodeListener.tail(node, this.stack.size());
        }
    }

    void trackNodePosition(Node node, boolean isStart) {
        if (!this.trackSourceRange) {
            return;
        }
        Token token = this.currentToken;
        int startPos = token.startPos();
        int endPos = token.endPos();
        if (node instanceof Element) {
            Element el2 = (Element)node;
            if (token.isEOF()) {
                if (el2.endSourceRange().isTracked()) {
                    return;
                }
                startPos = endPos = this.reader.pos();
            } else if (isStart) {
                if (!token.isStartTag() || !el2.normalName().equals(token.asStartTag().normalName)) {
                    endPos = startPos;
                }
            } else if (!(el2.tag().isEmpty() || el2.tag().isSelfClosing() || token.isEndTag() && el2.normalName().equals(token.asEndTag().normalName))) {
                endPos = startPos;
            }
        }
        Range.Position startPosition = new Range.Position(startPos, this.reader.lineNumber(startPos), this.reader.columnNumber(startPos));
        Range.Position endPosition = new Range.Position(endPos, this.reader.lineNumber(endPos), this.reader.columnNumber(endPos));
        Range range = new Range(startPosition, endPosition);
        node.attributes().userData(isStart ? "jsoup.start" : "jsoup.end", range);
    }
}

