/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.jsoup.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.watermedia.shaded.jsoup.helper.Validate;
import org.watermedia.shaded.jsoup.internal.SharedConstants;
import org.watermedia.shaded.jsoup.parser.ParseSettings;
import org.watermedia.shaded.jsoup.parser.Tag;

public class TagSet {
    static final TagSet HtmlTagSet = TagSet.initHtmlDefault();
    private final Map<String, Map<String, Tag>> tags = new HashMap<String, Map<String, Tag>>();
    private final @Nullable TagSet source;
    private @Nullable ArrayList<Consumer<Tag>> customizers;

    public static TagSet Html() {
        return new TagSet(HtmlTagSet, null);
    }

    private TagSet(@Nullable TagSet source, @Nullable ArrayList<Consumer<Tag>> customizers) {
        this.source = source;
        this.customizers = customizers;
    }

    public TagSet() {
        this(null, null);
    }

    public TagSet(TagSet template) {
        this(template.source, TagSet.copyCustomizers(template));
        if (template.tags.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Map<String, Tag>> namespaceEntry : template.tags.entrySet()) {
            HashMap<String, Tag> nsTags = new HashMap<String, Tag>(namespaceEntry.getValue().size());
            for (Map.Entry<String, Tag> tagEntry : namespaceEntry.getValue().entrySet()) {
                nsTags.put(tagEntry.getKey(), tagEntry.getValue().clone());
            }
            this.tags.put(namespaceEntry.getKey(), nsTags);
        }
    }

    private static @Nullable ArrayList<Consumer<Tag>> copyCustomizers(TagSet base) {
        if (base.customizers == null) {
            return null;
        }
        return new ArrayList<Consumer<Tag>>(base.customizers);
    }

    public TagSet add(Tag tag) {
        tag.set(Tag.Known);
        this.doAdd(tag);
        return this;
    }

    private void doAdd(Tag tag) {
        if (this.customizers != null) {
            for (Consumer<Tag> customizer : this.customizers) {
                customizer.accept(tag);
            }
        }
        this.tags.computeIfAbsent(tag.namespace, ns -> new HashMap()).put(tag.tagName, tag);
    }

    public @Nullable Tag get(String tagName, String namespace) {
        Tag tag;
        Validate.notNull(tagName);
        Validate.notNull(namespace);
        Map<String, Tag> nsTags = this.tags.get(namespace);
        if (nsTags != null && (tag = nsTags.get(tagName)) != null) {
            return tag;
        }
        if (this.source != null && (tag = this.source.get(tagName, namespace)) != null) {
            Tag copy = tag.clone();
            this.doAdd(copy);
            return copy;
        }
        return null;
    }

    Tag valueOf(String tagName, @Nullable String normalName, String namespace, boolean preserveTagCase) {
        Validate.notNull(tagName);
        Validate.notNull(namespace);
        tagName = tagName.trim();
        Validate.notEmpty(tagName);
        Tag tag = this.get(tagName, namespace);
        if (tag != null) {
            return tag;
        }
        if (normalName == null) {
            normalName = ParseSettings.normalName(tagName);
        }
        tagName = preserveTagCase ? tagName : normalName;
        tag = this.get(normalName, namespace);
        if (tag != null) {
            if (preserveTagCase && !tagName.equals(normalName)) {
                tag = tag.clone();
                tag.tagName = tagName;
                this.doAdd(tag);
            }
            return tag;
        }
        tag = new Tag(tagName, normalName, namespace);
        this.doAdd(tag);
        return tag;
    }

    public Tag valueOf(String tagName, String namespace, ParseSettings settings) {
        return this.valueOf(tagName, null, namespace, settings.preserveTagCase());
    }

    public Tag valueOf(String tagName, String namespace) {
        return this.valueOf(tagName, namespace, ParseSettings.preserveCase);
    }

    public TagSet onNewTag(Consumer<Tag> customizer) {
        Validate.notNull(customizer);
        if (this.customizers == null) {
            this.customizers = new ArrayList();
        }
        this.customizers.add(customizer);
        return this;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TagSet)) {
            return false;
        }
        TagSet tagSet = (TagSet)o;
        return Objects.equals(this.tags, tagSet.tags);
    }

    public int hashCode() {
        return Objects.hashCode(this.tags);
    }

    static TagSet initHtmlDefault() {
        String[] blockTags = new String[]{"html", "head", "body", "frameset", "script", "noscript", "style", "meta", "link", "title", "frame", "noframes", "section", "nav", "aside", "hgroup", "header", "footer", "p", "h1", "h2", "h3", "h4", "h5", "h6", "button", "ul", "ol", "pre", "div", "blockquote", "hr", "address", "figure", "figcaption", "form", "fieldset", "ins", "del", "dl", "dt", "dd", "li", "table", "caption", "thead", "tfoot", "tbody", "colgroup", "col", "tr", "th", "td", "video", "audio", "canvas", "details", "menu", "plaintext", "template", "article", "main", "center", "template", "dir", "applet", "marquee", "listing", "#root"};
        String[] inlineTags = new String[]{"object", "base", "font", "tt", "i", "b", "u", "big", "small", "em", "strong", "dfn", "code", "samp", "kbd", "var", "cite", "abbr", "time", "acronym", "mark", "ruby", "rt", "rp", "rtc", "a", "img", "wbr", "map", "q", "sub", "sup", "bdo", "iframe", "embed", "span", "input", "select", "textarea", "label", "optgroup", "option", "legend", "datalist", "keygen", "output", "progress", "meter", "area", "param", "source", "track", "summary", "org.watermedia.shaded.command", "device", "area", "basefont", "bgsound", "menuitem", "param", "source", "track", "data", "bdi", "s", "strike", "nobr", "rb"};
        String[] inlineContainers = new String[]{"title", "a", "p", "h1", "h2", "h3", "h4", "h5", "h6", "pre", "address", "li", "th", "td", "script", "style", "ins", "del", "s", "button"};
        String[] voidTags = new String[]{"meta", "link", "base", "frame", "img", "br", "wbr", "embed", "hr", "input", "keygen", "col", "org.watermedia.shaded.command", "device", "area", "basefont", "bgsound", "menuitem", "param", "source", "track"};
        String[] preserveWhitespaceTags = new String[]{"pre", "plaintext", "title", "textarea", "script"};
        String[] rcdataTags = new String[]{"title", "textarea"};
        String[] dataTags = new String[]{"iframe", "noembed", "noframes", "script", "style", "xmp"};
        String[] formSubmitTags = SharedConstants.FormSubmitTags;
        String[] blockMathTags = new String[]{"math"};
        String[] inlineMathTags = new String[]{"mi", "mo", "msup", "mn", "mtext"};
        String[] blockSvgTags = new String[]{"svg", "femerge", "femergenode"};
        String[] inlineSvgTags = new String[]{"text"};
        String[] dataSvgTags = new String[]{"script"};
        return new TagSet().setupTags("http://www.w3.org/1999/xhtml", blockTags, tag -> tag.set(Tag.Block)).setupTags("http://www.w3.org/1999/xhtml", inlineTags, tag -> tag.set(0)).setupTags("http://www.w3.org/1999/xhtml", inlineContainers, tag -> tag.set(Tag.InlineContainer)).setupTags("http://www.w3.org/1999/xhtml", voidTags, tag -> tag.set(Tag.Void)).setupTags("http://www.w3.org/1999/xhtml", preserveWhitespaceTags, tag -> tag.set(Tag.PreserveWhitespace)).setupTags("http://www.w3.org/1999/xhtml", rcdataTags, tag -> tag.set(Tag.RcData)).setupTags("http://www.w3.org/1999/xhtml", dataTags, tag -> tag.set(Tag.Data)).setupTags("http://www.w3.org/1999/xhtml", formSubmitTags, tag -> tag.set(Tag.FormSubmittable)).setupTags("http://www.w3.org/1998/Math/MathML", blockMathTags, tag -> tag.set(Tag.Block)).setupTags("http://www.w3.org/1998/Math/MathML", inlineMathTags, tag -> tag.set(0)).setupTags("http://www.w3.org/2000/svg", blockSvgTags, tag -> tag.set(Tag.Block)).setupTags("http://www.w3.org/2000/svg", inlineSvgTags, tag -> tag.set(0)).setupTags("http://www.w3.org/2000/svg", dataSvgTags, tag -> tag.set(Tag.Data));
    }

    private TagSet setupTags(String namespace, String[] tagNames, Consumer<Tag> tagModifier) {
        for (String tagName : tagNames) {
            Tag tag = this.get(tagName, namespace);
            if (tag == null) {
                tag = new Tag(tagName, tagName, namespace);
                tag.options = 0;
                this.add(tag);
            }
            tagModifier.accept(tag);
        }
        return this;
    }
}

