/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.jsoup.nodes;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.watermedia.shaded.jsoup.helper.Regex;
import org.watermedia.shaded.jsoup.helper.Validate;
import org.watermedia.shaded.jsoup.internal.Normalizer;
import org.watermedia.shaded.jsoup.internal.QuietAppendable;
import org.watermedia.shaded.jsoup.internal.StringUtil;
import org.watermedia.shaded.jsoup.nodes.Attribute;
import org.watermedia.shaded.jsoup.nodes.Attributes;
import org.watermedia.shaded.jsoup.nodes.CDataNode;
import org.watermedia.shaded.jsoup.nodes.Comment;
import org.watermedia.shaded.jsoup.nodes.DataNode;
import org.watermedia.shaded.jsoup.nodes.Document;
import org.watermedia.shaded.jsoup.nodes.Node;
import org.watermedia.shaded.jsoup.nodes.NodeIterator;
import org.watermedia.shaded.jsoup.nodes.NodeUtils;
import org.watermedia.shaded.jsoup.nodes.Printer;
import org.watermedia.shaded.jsoup.nodes.Range;
import org.watermedia.shaded.jsoup.nodes.TextNode;
import org.watermedia.shaded.jsoup.parser.ParseSettings;
import org.watermedia.shaded.jsoup.parser.Parser;
import org.watermedia.shaded.jsoup.parser.Tag;
import org.watermedia.shaded.jsoup.parser.TokenQueue;
import org.watermedia.shaded.jsoup.select.Collector;
import org.watermedia.shaded.jsoup.select.Elements;
import org.watermedia.shaded.jsoup.select.Evaluator;
import org.watermedia.shaded.jsoup.select.NodeFilter;
import org.watermedia.shaded.jsoup.select.NodeVisitor;
import org.watermedia.shaded.jsoup.select.Nodes;
import org.watermedia.shaded.jsoup.select.Selector;

public class Element
extends Node
implements Iterable<Element> {
    private static final List<Element> EmptyChildren = Collections.emptyList();
    private static final NodeList EmptyNodeList = new NodeList(0);
    private static final Pattern ClassSplit = Pattern.compile("\\s+");
    static final String BaseUriKey = Attributes.internalKey("baseUri");
    Tag tag;
    NodeList childNodes;
    @Nullable Attributes attributes;
    private static final String childElsKey = "jsoup.childEls";
    private static final String childElsMod = "jsoup.childElsMod";

    public Element(String tag, String namespace) {
        this(Tag.valueOf(tag, namespace, ParseSettings.preserveCase), null);
    }

    public Element(String tag) {
        this(tag, "http://www.w3.org/1999/xhtml");
    }

    public Element(Tag tag, @Nullable String baseUri, @Nullable Attributes attributes) {
        Validate.notNull(tag);
        this.childNodes = EmptyNodeList;
        this.attributes = attributes;
        this.tag = tag;
        if (!StringUtil.isBlank(baseUri)) {
            this.setBaseUri(baseUri);
        }
    }

    public Element(Tag tag, @Nullable String baseUri) {
        this(tag, baseUri, null);
    }

    protected boolean hasChildNodes() {
        return this.childNodes != EmptyNodeList;
    }

    @Override
    protected List<Node> ensureChildNodes() {
        if (this.childNodes == EmptyNodeList) {
            this.childNodes = new NodeList(4);
        }
        return this.childNodes;
    }

    @Override
    protected boolean hasAttributes() {
        return this.attributes != null;
    }

    @Override
    public Attributes attributes() {
        if (this.attributes == null) {
            this.attributes = new Attributes();
        }
        return this.attributes;
    }

    @Override
    public String baseUri() {
        String baseUri = Element.searchUpForAttribute(this, BaseUriKey);
        return baseUri != null ? baseUri : "";
    }

    static @Nullable String searchUpForAttribute(Element start, String key) {
        for (Element el2 = start; el2 != null; el2 = el2.parent()) {
            if (el2.attributes == null || !el2.attributes.hasKey(key)) continue;
            return el2.attributes.get(key);
        }
        return null;
    }

    @Override
    protected void doSetBaseUri(String baseUri) {
        this.attributes().put(BaseUriKey, baseUri);
    }

    @Override
    public int childNodeSize() {
        return this.childNodes.size();
    }

    @Override
    public String nodeName() {
        return this.tag.getName();
    }

    public String tagName() {
        return this.tag.getName();
    }

    @Override
    public String normalName() {
        return this.tag.normalName();
    }

    public boolean elementIs(String normalName, String namespace) {
        return this.tag.normalName().equals(normalName) && this.tag.namespace().equals(namespace);
    }

    public Element tagName(String tagName) {
        return this.tagName(tagName, this.tag.namespace());
    }

    public Element tagName(String tagName, String namespace) {
        Validate.notEmptyParam(tagName, "tagName");
        Validate.notEmptyParam(namespace, "namespace");
        Parser parser = NodeUtils.parser(this);
        this.tag = parser.tagSet().valueOf(tagName, namespace, parser.settings());
        return this;
    }

    public Tag tag() {
        return this.tag;
    }

    public Element tag(Tag tag) {
        Validate.notNull(tag);
        this.tag = tag;
        return this;
    }

    public boolean isBlock() {
        return this.tag.isBlock();
    }

    public String id() {
        return this.attributes != null ? this.attributes.getIgnoreCase("id") : "";
    }

    public Element id(String id2) {
        Validate.notNull(id2);
        this.attr("id", id2);
        return this;
    }

    @Override
    public Element attr(String attributeKey, String attributeValue) {
        super.attr(attributeKey, attributeValue);
        return this;
    }

    public Element attr(String attributeKey, boolean attributeValue) {
        this.attributes().put(attributeKey, attributeValue);
        return this;
    }

    public @Nullable Attribute attribute(String key) {
        return this.hasAttributes() ? this.attributes().attribute(key) : null;
    }

    public Map<String, String> dataset() {
        return this.attributes().dataset();
    }

    @Override
    public final @Nullable Element parent() {
        return this.parentNode;
    }

    public Elements parents() {
        Elements parents = new Elements();
        for (Element parent = this.parent(); parent != null && !parent.nameIs("#root"); parent = parent.parent()) {
            parents.add(parent);
        }
        return parents;
    }

    public Element child(int index) {
        Validate.isTrue(index >= 0, "Index must be >= 0");
        List<Element> cached = this.cachedChildren();
        if (cached != null) {
            return cached.get(index);
        }
        int size = this.childNodes.size();
        int e = 0;
        for (int i = 0; i < size; ++i) {
            Node node = (Node)this.childNodes.get(i);
            if (!(node instanceof Element) || e++ != index) continue;
            return (Element)node;
        }
        throw new IndexOutOfBoundsException("No child at index: " + index);
    }

    public int childrenSize() {
        if (this.childNodeSize() == 0) {
            return 0;
        }
        return this.childElementsList().size();
    }

    public Elements children() {
        return new Elements(this.childElementsList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Element> childElementsList() {
        if (this.childNodeSize() == 0) {
            return EmptyChildren;
        }
        NodeList nodeList = this.childNodes;
        synchronized (nodeList) {
            List<Element> children = this.cachedChildren();
            if (children == null) {
                children = this.filterNodes(Element.class);
                this.stashChildren(children);
            }
            return children;
        }
    }

    @Nullable List<Element> cachedChildren() {
        Integer modCount;
        List els;
        if (this.attributes == null || !this.attributes.hasUserData()) {
            return null;
        }
        Map<String, Object> userData = this.attributes.userData();
        WeakReference ref = (WeakReference)userData.get(childElsKey);
        if (ref != null && (els = (List)ref.get()) != null && (modCount = (Integer)userData.get(childElsMod)) != null && modCount.intValue() == this.childNodes.modCount()) {
            return els;
        }
        return null;
    }

    private void stashChildren(List<Element> els) {
        Map<String, Object> userData = this.attributes().userData();
        WeakReference<List<Element>> ref = new WeakReference<List<Element>>(els);
        userData.put(childElsKey, ref);
        userData.put(childElsMod, this.childNodes.modCount());
    }

    public Stream<Element> stream() {
        return NodeUtils.stream(this, Element.class);
    }

    private <T> List<T> filterNodes(Class<T> clazz) {
        return this.childNodes.stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public List<TextNode> textNodes() {
        return this.filterNodes(TextNode.class);
    }

    public List<DataNode> dataNodes() {
        return this.filterNodes(DataNode.class);
    }

    public Elements select(String cssQuery) {
        return Selector.select(cssQuery, this);
    }

    public Elements select(Evaluator evaluator) {
        return Selector.select(evaluator, this);
    }

    public Stream<Element> selectStream(String cssQuery) {
        return Selector.selectStream(cssQuery, this);
    }

    public Stream<Element> selectStream(Evaluator evaluator) {
        return Selector.selectStream(evaluator, this);
    }

    public @Nullable Element selectFirst(String cssQuery) {
        return Selector.selectFirst(cssQuery, this);
    }

    public @Nullable Element selectFirst(Evaluator evaluator) {
        return Collector.findFirst(evaluator, this);
    }

    public Element expectFirst(String cssQuery) {
        return Validate.expectNotNull(Selector.selectFirst(cssQuery, this), this.parent() != null ? "No elements matched the query '%s' on element '%s'." : "No elements matched the query '%s' in the document.", cssQuery, this.tagName());
    }

    public Nodes<Node> selectNodes(Evaluator evaluator) {
        return this.selectNodes(evaluator, Node.class);
    }

    public Nodes<Node> selectNodes(String cssQuery) {
        return this.selectNodes(cssQuery, Node.class);
    }

    public <T extends Node> Nodes<T> selectNodes(Evaluator evaluator, Class<T> type) {
        Validate.notNull(evaluator);
        return Collector.collectNodes(evaluator, this, type);
    }

    public <T extends Node> Nodes<T> selectNodes(String cssQuery, Class<T> type) {
        Validate.notEmpty(cssQuery);
        return this.selectNodes(Selector.evaluatorOf(cssQuery), type);
    }

    public <T extends Node> @Nullable T selectFirstNode(String cssQuery, Class<T> type) {
        return this.selectFirstNode(Selector.evaluatorOf(cssQuery), type);
    }

    public <T extends Node> @Nullable T selectFirstNode(Evaluator evaluator, Class<T> type) {
        return Collector.findFirstNode(evaluator, this, type);
    }

    public <T extends Node> T expectFirstNode(String cssQuery, Class<T> type) {
        return (T)((Node)Validate.expectNotNull(this.selectFirstNode(cssQuery, type), this.parent() != null ? "No nodes matched the query '%s' on element '%s'." : "No nodes matched the query '%s' in the document.", cssQuery, this.tagName()));
    }

    public boolean is(String cssQuery) {
        return this.is(Selector.evaluatorOf(cssQuery));
    }

    public boolean is(Evaluator evaluator) {
        return evaluator.matches(this.root(), this);
    }

    public @Nullable Element closest(String cssQuery) {
        return this.closest(Selector.evaluatorOf(cssQuery));
    }

    public @Nullable Element closest(Evaluator evaluator) {
        Validate.notNull(evaluator);
        Element el2 = this;
        Element root = this.root();
        do {
            if (!evaluator.matches(root, el2)) continue;
            return el2;
        } while ((el2 = el2.parent()) != null);
        return null;
    }

    public Elements selectXpath(String xpath) {
        return new Elements(NodeUtils.selectXpath(xpath, this, Element.class));
    }

    public <T extends Node> List<T> selectXpath(String xpath, Class<T> nodeType) {
        return NodeUtils.selectXpath(xpath, this, nodeType);
    }

    public Element appendChild(Node child) {
        Validate.notNull(child);
        this.reparentChild(child);
        this.ensureChildNodes();
        this.childNodes.add(child);
        child.setSiblingIndex(this.childNodes.size() - 1);
        return this;
    }

    public Element appendChildren(Collection<? extends Node> children) {
        this.insertChildren(-1, children);
        return this;
    }

    public Element appendTo(Element parent) {
        Validate.notNull(parent);
        parent.appendChild(this);
        return this;
    }

    public Element prependChild(Node child) {
        Validate.notNull(child);
        this.addChildren(0, child);
        return this;
    }

    public Element prependChildren(Collection<? extends Node> children) {
        this.insertChildren(0, children);
        return this;
    }

    public Element insertChildren(int index, Collection<? extends Node> children) {
        Validate.notNull(children, "Children collection to be inserted must not be null.");
        int currentSize = this.childNodeSize();
        if (index < 0) {
            index += currentSize + 1;
        }
        Validate.isTrue(index >= 0 && index <= currentSize, "Insert position out of bounds.");
        this.addChildren(index, children.toArray(new Node[0]));
        return this;
    }

    public Element insertChildren(int index, Node ... children) {
        Validate.notNull(children, "Children collection to be inserted must not be null.");
        int currentSize = this.childNodeSize();
        if (index < 0) {
            index += currentSize + 1;
        }
        Validate.isTrue(index >= 0 && index <= currentSize, "Insert position out of bounds.");
        this.addChildren(index, children);
        return this;
    }

    public Element appendElement(String tagName) {
        return this.appendElement(tagName, this.tag.namespace());
    }

    public Element appendElement(String tagName, String namespace) {
        Parser parser = NodeUtils.parser(this);
        Element child = new Element(parser.tagSet().valueOf(tagName, namespace, parser.settings()), this.baseUri());
        this.appendChild(child);
        return child;
    }

    public Element prependElement(String tagName) {
        return this.prependElement(tagName, this.tag.namespace());
    }

    public Element prependElement(String tagName, String namespace) {
        Parser parser = NodeUtils.parser(this);
        Element child = new Element(parser.tagSet().valueOf(tagName, namespace, parser.settings()), this.baseUri());
        this.prependChild(child);
        return child;
    }

    public Element appendText(String text) {
        Validate.notNull(text);
        TextNode node = new TextNode(text);
        this.appendChild(node);
        return this;
    }

    public Element prependText(String text) {
        Validate.notNull(text);
        TextNode node = new TextNode(text);
        this.prependChild(node);
        return this;
    }

    public Element append(String html) {
        Validate.notNull(html);
        List<Node> nodes = NodeUtils.parser(this).parseFragmentInput(html, this, this.baseUri());
        this.addChildren(nodes.toArray(new Node[0]));
        return this;
    }

    public Element prepend(String html) {
        Validate.notNull(html);
        List<Node> nodes = NodeUtils.parser(this).parseFragmentInput(html, this, this.baseUri());
        this.addChildren(0, nodes.toArray(new Node[0]));
        return this;
    }

    @Override
    public Element before(String html) {
        return (Element)super.before(html);
    }

    @Override
    public Element before(Node node) {
        return (Element)super.before(node);
    }

    @Override
    public Element after(String html) {
        return (Element)super.after(html);
    }

    @Override
    public Element after(Node node) {
        return (Element)super.after(node);
    }

    @Override
    public Element empty() {
        int size = this.childNodes.size();
        for (int i = 0; i < size; ++i) {
            ((Node)this.childNodes.get((int)i)).parentNode = null;
        }
        this.childNodes.clear();
        return this;
    }

    @Override
    public Element wrap(String html) {
        return (Element)super.wrap(html);
    }

    private String uniqueIdSelector(@Nullable Document ownerDoc) {
        String id2 = this.id();
        if (!id2.isEmpty()) {
            String idSel = "#" + TokenQueue.escapeCssIdentifier(id2);
            if (ownerDoc != null) {
                Elements els = ownerDoc.select(idSel);
                if (els.size() == 1 && els.get(0) == this) {
                    return idSel;
                }
            } else {
                return idSel;
            }
        }
        return "";
    }

    public String cssSelector() {
        Document ownerDoc = this.ownerDocument();
        String idSel = this.uniqueIdSelector(ownerDoc);
        if (!idSel.isEmpty()) {
            return idSel;
        }
        StringBuilder selector = StringUtil.borrowBuilder();
        for (Element el2 = this; el2 != null && !(el2 instanceof Document); el2 = el2.parent()) {
            idSel = el2.uniqueIdSelector(ownerDoc);
            if (!idSel.isEmpty()) {
                selector.insert(0, idSel);
                break;
            }
            selector.insert(0, el2.cssSelectorComponent());
        }
        return StringUtil.releaseBuilder(selector);
    }

    private String cssSelectorComponent() {
        String tagName = TokenQueue.escapeCssIdentifier(this.tagName()).replace("\\:", "|");
        StringBuilder selector = StringUtil.borrowBuilder().append(tagName);
        String classes = this.classNames().stream().map(TokenQueue::escapeCssIdentifier).collect(StringUtil.joining("."));
        if (!classes.isEmpty()) {
            selector.append('.').append(classes);
        }
        if (this.parent() == null || this.parent() instanceof Document) {
            return StringUtil.releaseBuilder(selector);
        }
        selector.insert(0, " > ");
        if (this.parent().select(selector.toString()).size() > 1) {
            selector.append(String.format(":nth-child(%d)", this.elementSiblingIndex() + 1));
        }
        return StringUtil.releaseBuilder(selector);
    }

    public Elements siblingElements() {
        if (this.parentNode == null) {
            return new Elements(0);
        }
        List<Element> elements = this.parent().childElementsList();
        Elements siblings = new Elements(elements.size() - 1);
        for (Element el2 : elements) {
            if (el2 == this) continue;
            siblings.add(el2);
        }
        return siblings;
    }

    public Elements nextElementSiblings() {
        return this.nextElementSiblings(true);
    }

    public Elements previousElementSiblings() {
        return this.nextElementSiblings(false);
    }

    private Elements nextElementSiblings(boolean next) {
        Elements els = new Elements();
        if (this.parentNode == null) {
            return els;
        }
        els.add(this);
        return next ? els.nextAll() : els.prevAll();
    }

    public Element firstElementSibling() {
        if (this.parent() != null) {
            return this.parent().firstElementChild();
        }
        return this;
    }

    public int elementSiblingIndex() {
        if (this.parent() == null) {
            return 0;
        }
        return Element.indexInList(this, this.parent().childElementsList());
    }

    public Element lastElementSibling() {
        if (this.parent() != null) {
            return this.parent().lastElementChild();
        }
        return this;
    }

    private static <E extends Element> int indexInList(Element search, List<E> elements) {
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            if (elements.get(i) != search) continue;
            return i;
        }
        return 0;
    }

    public @Nullable Element firstElementChild() {
        int size = this.childNodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = (Node)this.childNodes.get(i);
            if (!(node instanceof Element)) continue;
            return (Element)node;
        }
        return null;
    }

    public @Nullable Element lastElementChild() {
        for (int i = this.childNodes.size() - 1; i >= 0; --i) {
            Node node = (Node)this.childNodes.get(i);
            if (!(node instanceof Element)) continue;
            return (Element)node;
        }
        return null;
    }

    public Elements getElementsByTag(String tagName) {
        Validate.notEmpty(tagName);
        tagName = Normalizer.normalize(tagName);
        return Collector.collect(new Evaluator.Tag(tagName), this);
    }

    public @Nullable Element getElementById(String id2) {
        Validate.notEmpty(id2);
        return Collector.findFirst(new Evaluator.Id(id2), this);
    }

    public Elements getElementsByClass(String className) {
        Validate.notEmpty(className);
        return Collector.collect(new Evaluator.Class(className), this);
    }

    public Elements getElementsByAttribute(String key) {
        Validate.notEmpty(key);
        key = key.trim();
        return Collector.collect(new Evaluator.Attribute(key), this);
    }

    public Elements getElementsByAttributeStarting(String keyPrefix) {
        Validate.notEmpty(keyPrefix);
        keyPrefix = keyPrefix.trim();
        return Collector.collect(new Evaluator.AttributeStarting(keyPrefix), this);
    }

    public Elements getElementsByAttributeValue(String key, String value) {
        return Collector.collect(new Evaluator.AttributeWithValue(key, value), this);
    }

    public Elements getElementsByAttributeValueNot(String key, String value) {
        return Collector.collect(new Evaluator.AttributeWithValueNot(key, value), this);
    }

    public Elements getElementsByAttributeValueStarting(String key, String valuePrefix) {
        return Collector.collect(new Evaluator.AttributeWithValueStarting(key, valuePrefix), this);
    }

    public Elements getElementsByAttributeValueEnding(String key, String valueSuffix) {
        return Collector.collect(new Evaluator.AttributeWithValueEnding(key, valueSuffix), this);
    }

    public Elements getElementsByAttributeValueContaining(String key, String match) {
        return Collector.collect(new Evaluator.AttributeWithValueContaining(key, match), this);
    }

    public Elements getElementsByAttributeValueMatching(String key, Pattern pattern) {
        return Collector.collect(new Evaluator.AttributeWithValueMatching(key, pattern), this);
    }

    public Elements getElementsByAttributeValueMatching(String key, String regex) {
        Regex pattern;
        try {
            pattern = Regex.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Pattern syntax error: " + regex, e);
        }
        return Collector.collect(new Evaluator.AttributeWithValueMatching(key, pattern), this);
    }

    public Elements getElementsByIndexLessThan(int index) {
        return Collector.collect(new Evaluator.IndexLessThan(index), this);
    }

    public Elements getElementsByIndexGreaterThan(int index) {
        return Collector.collect(new Evaluator.IndexGreaterThan(index), this);
    }

    public Elements getElementsByIndexEquals(int index) {
        return Collector.collect(new Evaluator.IndexEquals(index), this);
    }

    public Elements getElementsContainingText(String searchText) {
        return Collector.collect(new Evaluator.ContainsText(searchText), this);
    }

    public Elements getElementsContainingOwnText(String searchText) {
        return Collector.collect(new Evaluator.ContainsOwnText(searchText), this);
    }

    public Elements getElementsMatchingText(Pattern pattern) {
        return Collector.collect(new Evaluator.Matches(pattern), this);
    }

    public Elements getElementsMatchingText(String regex) {
        Regex pattern;
        try {
            pattern = Regex.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Pattern syntax error: " + regex, e);
        }
        return Collector.collect(new Evaluator.Matches(pattern), this);
    }

    public Elements getElementsMatchingOwnText(Pattern pattern) {
        return Collector.collect(new Evaluator.MatchesOwn(pattern), this);
    }

    public Elements getElementsMatchingOwnText(String regex) {
        Regex pattern;
        try {
            pattern = Regex.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Pattern syntax error: " + regex, e);
        }
        return Collector.collect(new Evaluator.MatchesOwn(pattern), this);
    }

    public Elements getAllElements() {
        return Collector.collect(new Evaluator.AllElements(), this);
    }

    public String text() {
        StringBuilder accum = StringUtil.borrowBuilder();
        new TextAccumulator(accum).traverse(this);
        return StringUtil.releaseBuilder(accum).trim();
    }

    public String wholeText() {
        return Element.wholeTextOf(this.nodeStream());
    }

    @Override
    public String nodeValue() {
        return this.wholeOwnText();
    }

    private static String wholeTextOf(Stream<Node> stream) {
        return stream.map(node -> {
            if (node instanceof TextNode) {
                return ((TextNode)node).getWholeText();
            }
            if (node.nameIs("br")) {
                return "\n";
            }
            return "";
        }).collect(StringUtil.joining(""));
    }

    public String wholeOwnText() {
        return Element.wholeTextOf(this.childNodes.stream());
    }

    public String ownText() {
        StringBuilder sb = StringUtil.borrowBuilder();
        this.ownText(sb);
        return StringUtil.releaseBuilder(sb).trim();
    }

    private void ownText(StringBuilder accum) {
        for (int i = 0; i < this.childNodeSize(); ++i) {
            Node child = (Node)this.childNodes.get(i);
            if (child instanceof TextNode) {
                TextNode textNode = (TextNode)child;
                Element.appendNormalisedText(accum, textNode);
                continue;
            }
            if (!child.nameIs("br") || TextNode.lastCharIsWhitespace(accum)) continue;
            accum.append(" ");
        }
    }

    private static void appendNormalisedText(StringBuilder accum, TextNode textNode) {
        String text = textNode.getWholeText();
        if (Element.preserveWhitespace(textNode.parentNode) || textNode instanceof CDataNode) {
            accum.append(text);
        } else {
            StringUtil.appendNormalisedWhitespace(accum, text, TextNode.lastCharIsWhitespace(accum));
        }
    }

    static boolean preserveWhitespace(@Nullable Node node) {
        if (node instanceof Element) {
            Element el2 = (Element)node;
            int i = 0;
            do {
                if (el2.tag.preserveWhitespace()) {
                    return true;
                }
                el2 = el2.parent();
            } while (++i < 6 && el2 != null);
        }
        return false;
    }

    public Element text(String text) {
        Validate.notNull(text);
        this.empty();
        if (this.tag().is(Tag.Data)) {
            this.appendChild(new DataNode(text));
        } else {
            this.appendChild(new TextNode(text));
        }
        return this;
    }

    public boolean hasText() {
        AtomicBoolean hasText = new AtomicBoolean(false);
        this.filter((node, depth) -> {
            TextNode textNode;
            if (node instanceof TextNode && !(textNode = (TextNode)node).isBlank()) {
                hasText.set(true);
                return NodeFilter.FilterResult.STOP;
            }
            return NodeFilter.FilterResult.CONTINUE;
        });
        return hasText.get();
    }

    public String data() {
        StringBuilder sb = StringUtil.borrowBuilder();
        this.traverse((childNode, depth) -> {
            if (childNode instanceof DataNode) {
                DataNode data = (DataNode)childNode;
                sb.append(data.getWholeData());
            } else if (childNode instanceof Comment) {
                Comment comment = (Comment)childNode;
                sb.append(comment.getData());
            } else if (childNode instanceof CDataNode) {
                CDataNode cDataNode = (CDataNode)childNode;
                sb.append(cDataNode.getWholeText());
            }
        });
        return StringUtil.releaseBuilder(sb);
    }

    public String className() {
        return this.attr("class").trim();
    }

    public Set<String> classNames() {
        String[] names = ClassSplit.split(this.className());
        LinkedHashSet<String> classNames = new LinkedHashSet<String>(Arrays.asList(names));
        classNames.remove("");
        return classNames;
    }

    public Element classNames(Set<String> classNames) {
        Validate.notNull(classNames);
        if (classNames.isEmpty()) {
            this.attributes().remove("class");
        } else {
            this.attributes().put("class", StringUtil.join(classNames, " "));
        }
        return this;
    }

    public boolean hasClass(String className) {
        if (this.attributes == null) {
            return false;
        }
        String classAttr = this.attributes.getIgnoreCase("class");
        int len = classAttr.length();
        int wantLen = className.length();
        if (len == 0 || len < wantLen) {
            return false;
        }
        if (len == wantLen) {
            return className.equalsIgnoreCase(classAttr);
        }
        boolean inClass = false;
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(classAttr.charAt(i))) {
                if (!inClass) continue;
                if (i - start == wantLen && classAttr.regionMatches(true, start, className, 0, wantLen)) {
                    return true;
                }
                inClass = false;
                continue;
            }
            if (inClass) continue;
            inClass = true;
            start = i;
        }
        if (inClass && len - start == wantLen) {
            return classAttr.regionMatches(true, start, className, 0, wantLen);
        }
        return false;
    }

    public Element addClass(String className) {
        Validate.notNull(className);
        Set<String> classes = this.classNames();
        classes.add(className);
        this.classNames(classes);
        return this;
    }

    public Element removeClass(String className) {
        Validate.notNull(className);
        Set<String> classes = this.classNames();
        classes.remove(className);
        this.classNames(classes);
        return this;
    }

    public Element toggleClass(String className) {
        Validate.notNull(className);
        Set<String> classes = this.classNames();
        if (classes.contains(className)) {
            classes.remove(className);
        } else {
            classes.add(className);
        }
        this.classNames(classes);
        return this;
    }

    public String val() {
        if (this.elementIs("textarea", "http://www.w3.org/1999/xhtml")) {
            return this.text();
        }
        return this.attr("value");
    }

    public Element val(String value) {
        if (this.elementIs("textarea", "http://www.w3.org/1999/xhtml")) {
            this.text(value);
        } else {
            this.attr("value", value);
        }
        return this;
    }

    public Range endSourceRange() {
        return Range.of(this, false);
    }

    @Override
    void outerHtmlHead(QuietAppendable accum, Document.OutputSettings out) {
        String tagName = this.safeTagName(out.syntax());
        accum.append('<').append(tagName);
        if (this.attributes != null) {
            this.attributes.html(accum, out);
        }
        if (this.childNodes.isEmpty()) {
            boolean xmlMode;
            boolean bl = xmlMode = out.syntax() == Document.OutputSettings.Syntax.xml || !this.tag.namespace().equals("http://www.w3.org/1999/xhtml");
            if (xmlMode && (this.tag.is(Tag.SeenSelfClose) || this.tag.isKnownTag() && (this.tag.isEmpty() || this.tag.isSelfClosing()))) {
                accum.append(" />");
            } else if (!xmlMode && this.tag.isEmpty()) {
                accum.append('>');
            } else {
                accum.append("></").append(tagName).append('>');
            }
        } else {
            accum.append('>');
        }
    }

    @Override
    void outerHtmlTail(QuietAppendable accum, Document.OutputSettings out) {
        if (!this.childNodes.isEmpty()) {
            accum.append("</").append(this.safeTagName(out.syntax())).append('>');
        }
    }

    private @Nullable String safeTagName(Document.OutputSettings.Syntax syntax) {
        return syntax == Document.OutputSettings.Syntax.xml ? Normalizer.xmlSafeTagName(this.tagName()) : this.tagName();
    }

    public String html() {
        StringBuilder sb = StringUtil.borrowBuilder();
        this.html(sb);
        String html = StringUtil.releaseBuilder(sb);
        return NodeUtils.outputSettings(this).prettyPrint() ? html.trim() : html;
    }

    @Override
    public <T extends Appendable> T html(T accum) {
        Node child = this.firstChild();
        if (child != null) {
            Printer printer = Printer.printerFor(child, QuietAppendable.wrap(accum));
            while (child != null) {
                printer.traverse(child);
                child = child.nextSibling();
            }
        }
        return accum;
    }

    public Element html(String html) {
        this.empty();
        this.append(html);
        return this;
    }

    @Override
    public Element clone() {
        return (Element)super.clone();
    }

    @Override
    public Element shallowClone() {
        String baseUri = this.baseUri();
        if (baseUri.isEmpty()) {
            baseUri = null;
        }
        return new Element(this.tag, baseUri, this.attributes == null ? null : this.attributes.clone());
    }

    @Override
    protected Element doClone(@Nullable Node parent) {
        Element clone = (Element)super.doClone(parent);
        clone.childNodes = new NodeList(this.childNodes.size());
        clone.childNodes.addAll(this.childNodes);
        if (this.attributes != null) {
            clone.attributes = this.attributes.clone();
            clone.attributes.userData(childElsKey, null);
        }
        return clone;
    }

    @Override
    public Element clearAttributes() {
        if (this.attributes != null) {
            super.clearAttributes();
            if (this.attributes.size == 0) {
                this.attributes = null;
            }
        }
        return this;
    }

    @Override
    public Element removeAttr(String attributeKey) {
        return (Element)super.removeAttr(attributeKey);
    }

    @Override
    public Element root() {
        return (Element)super.root();
    }

    @Override
    public Element traverse(NodeVisitor nodeVisitor) {
        return (Element)super.traverse(nodeVisitor);
    }

    @Override
    public Element forEachNode(Consumer<? super Node> action) {
        return (Element)super.forEachNode(action);
    }

    @Override
    public void forEach(Consumer<? super Element> action) {
        this.stream().forEach(action);
    }

    @Override
    public Iterator<Element> iterator() {
        return new NodeIterator<Element>(this, Element.class);
    }

    @Override
    public Element filter(NodeFilter nodeFilter) {
        return (Element)super.filter(nodeFilter);
    }

    void reindexChildren() {
        int size = this.childNodes.size();
        for (int i = 0; i < size; ++i) {
            ((Node)this.childNodes.get(i)).setSiblingIndex(i);
        }
        this.childNodes.validChildren = true;
    }

    void invalidateChildren() {
        this.childNodes.validChildren = false;
    }

    boolean hasValidChildren() {
        return this.childNodes.validChildren;
    }

    static final class NodeList
    extends ArrayList<Node> {
        boolean validChildren = true;

        public NodeList(int size) {
            super(size);
        }

        int modCount() {
            return this.modCount;
        }

        void incrementMod() {
            ++this.modCount;
        }
    }

    private static class TextAccumulator
    implements NodeVisitor {
        private final StringBuilder accum;

        public TextAccumulator(StringBuilder accum) {
            this.accum = accum;
        }

        @Override
        public void head(Node node, int depth) {
            if (node instanceof TextNode) {
                TextNode textNode = (TextNode)node;
                Element.appendNormalisedText(this.accum, textNode);
            } else if (node instanceof Element) {
                Element element = (Element)node;
                if (this.accum.length() > 0 && (element.isBlock() || element.nameIs("br")) && !TextNode.lastCharIsWhitespace(this.accum)) {
                    this.accum.append(' ');
                }
            }
        }

        @Override
        public void tail(Node node, int depth) {
            if (node instanceof Element) {
                Element element = (Element)node;
                Node next = node.nextSibling();
                if (!element.tag.isInline() && (next instanceof TextNode || next instanceof Element && ((Element)next).tag.isInline()) && !TextNode.lastCharIsWhitespace(this.accum)) {
                    this.accum.append(' ');
                }
            }
        }
    }
}

