/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.jsoup.internal;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jspecify.annotations.Nullable;
import org.watermedia.shaded.jsoup.helper.Validate;
import org.watermedia.shaded.jsoup.internal.SoftPool;

class SimpleBufferedInput
extends FilterInputStream {
    static final int BufferSize = 8192;
    static final SoftPool<byte[]> BufferPool = new SoftPool<byte[]>(() -> new byte[8192]);
    private int capRemaining = Integer.MAX_VALUE;
    private byte @Nullable [] byteBuf;
    private int bufPos;
    private int bufLength;
    private int bufMark = -1;
    private boolean inReadFully = false;

    SimpleBufferedInput(@Nullable InputStream in) {
        super(in);
        if (in == null) {
            this.inReadFully = true;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.bufPos >= this.bufLength) {
            this.fill();
            if (this.bufPos >= this.bufLength) {
                return -1;
            }
        }
        return this.getBuf()[this.bufPos++] & 0xFF;
    }

    @Override
    public int read(byte[] dest, int offset, int desiredLen) throws IOException {
        int read;
        Validate.notNull(dest);
        if (offset < 0 || desiredLen < 0 || desiredLen > dest.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (desiredLen == 0) {
            return 0;
        }
        int bufAvail = this.bufLength - this.bufPos;
        if (bufAvail <= 0) {
            this.fill();
            bufAvail = this.bufLength - this.bufPos;
        }
        if ((read = Math.min(bufAvail, desiredLen)) <= 0) {
            return -1;
        }
        System.arraycopy(this.getBuf(), this.bufPos, dest, offset, read);
        this.bufPos += read;
        return read;
    }

    private void fill() throws IOException {
        if (this.inReadFully) {
            return;
        }
        if (this.byteBuf == null) {
            this.byteBuf = BufferPool.borrow();
        }
        this.compact();
        this.bufLength = this.bufPos;
        int toRead = Math.min(this.byteBuf.length - this.bufPos, this.capRemaining);
        if (toRead <= 0) {
            return;
        }
        int read = this.in.read(this.byteBuf, this.bufPos, toRead);
        if (read > 0) {
            this.bufLength = read + this.bufPos;
            this.capRemaining -= read;
            while (this.byteBuf.length - this.bufLength > 0 && this.capRemaining > 0 && this.in.available() >= 1 && (toRead = Math.min(this.byteBuf.length - this.bufLength, this.capRemaining)) > 0 && (read = this.in.read(this.byteBuf, this.bufLength, toRead)) > 0) {
                this.bufLength += read;
                this.capRemaining -= read;
            }
        }
        if (read == -1) {
            this.inReadFully = true;
        }
    }

    byte[] getBuf() {
        Validate.notNull(this.byteBuf);
        return this.byteBuf;
    }

    boolean baseReadFully() {
        return this.inReadFully;
    }

    void resetFullyRead() {
        if (this.in != null) {
            this.inReadFully = false;
        }
    }

    @Override
    public int available() throws IOException {
        int buffered;
        int n = buffered = this.byteBuf != null ? this.bufLength - this.bufPos : 0;
        if (buffered > 0) {
            return buffered;
        }
        int avail = this.inReadFully ? 0 : this.in.available();
        return avail;
    }

    void capRemaining(int newRemaining) {
        this.capRemaining = Math.max(0, newRemaining);
    }

    void setMark() {
        this.bufMark = this.bufPos;
    }

    void rewindToMark() throws IOException {
        if (this.bufMark < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.bufPos = this.bufMark;
    }

    void clearMark() {
        this.bufMark = -1;
    }

    private void compact() {
        int keepFrom;
        if (this.byteBuf == null || this.bufPos == 0) {
            return;
        }
        int n = keepFrom = this.bufMark >= 0 ? this.bufMark : this.bufPos;
        if (keepFrom <= 0) {
            return;
        }
        int remaining = this.bufLength - keepFrom;
        if (remaining > 0) {
            System.arraycopy(this.byteBuf, keepFrom, this.byteBuf, 0, remaining);
        }
        this.bufLength = remaining;
        this.bufPos -= keepFrom;
        if (this.bufMark >= 0) {
            this.bufMark -= keepFrom;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            super.close();
        }
        if (this.byteBuf == null) {
            return;
        }
        BufferPool.release(this.byteBuf);
        this.byteBuf = null;
    }
}

