/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.jsoup.helper;

import java.lang.reflect.Method;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.watermedia.shaded.jsoup.helper.Re2jRegex;
import org.watermedia.shaded.jsoup.helper.ValidationException;

public class Regex {
    private static final boolean hasRe2j = Regex.hasRe2j();
    private final Pattern jdkPattern;

    Regex(Pattern jdkPattern) {
        this.jdkPattern = jdkPattern;
    }

    public static Regex compile(String regex) {
        if (Regex.usingRe2j()) {
            return Re2jRegex.compile(regex);
        }
        try {
            return new Regex(Pattern.compile(regex));
        }
        catch (PatternSyntaxException e) {
            throw new ValidationException("Pattern syntax error: " + e.getMessage());
        }
    }

    public static Regex fromPattern(Pattern pattern) {
        return new Regex(pattern);
    }

    public static boolean usingRe2j() {
        return hasRe2j && Regex.wantsRe2j();
    }

    static boolean wantsRe2j() {
        return Boolean.parseBoolean(System.getProperty("jsoup.useRe2j", "true"));
    }

    static void wantsRe2j(boolean use) {
        System.setProperty("jsoup.useRe2j", Boolean.toString(use));
    }

    static boolean hasRe2j() {
        try {
            Class<?> re2 = Class.forName("org.watermedia.shaded.com.google.re2j.Pattern", false, Regex.class.getClassLoader());
            try {
                Class<?> moduleCls = Class.forName("java.lang.Module");
                Method getModule = Class.class.getMethod("getModule", new Class[0]);
                Object jsoupMod = getModule.invoke(Regex.class, new Object[0]);
                Object re2Mod = getModule.invoke(re2, new Object[0]);
                boolean reads = (Boolean)moduleCls.getMethod("canRead", moduleCls).invoke(jsoupMod, re2Mod);
                if (!reads) {
                    moduleCls.getMethod("addReads", moduleCls).invoke(jsoupMod, re2Mod);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (ReflectiveOperationException e) {
            System.err.println("Warning: (bug? please report) couldn't access re2j from jsoup due to modules: " + e);
            return false;
        }
    }

    public Matcher matcher(CharSequence input) {
        return new JdkMatcher(this.jdkPattern.matcher(input));
    }

    public String toString() {
        return this.jdkPattern.toString();
    }

    private static final class JdkMatcher
    implements Matcher {
        private final java.util.regex.Matcher delegate;

        JdkMatcher(java.util.regex.Matcher delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean find() {
            return this.delegate.find();
        }
    }

    public static interface Matcher {
        public boolean find();
    }
}

