/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.jsoup.helper;

import org.watermedia.shaded.com.google.re2j.Matcher;
import org.watermedia.shaded.com.google.re2j.Pattern;
import org.watermedia.shaded.jsoup.helper.Regex;
import org.watermedia.shaded.jsoup.helper.ValidationException;

final class Re2jRegex
extends Regex {
    private static final java.util.regex.Pattern unused = java.util.regex.Pattern.compile("");
    private final Pattern re2jPattern;

    private Re2jRegex(Pattern re2jPattern) {
        super(unused);
        this.re2jPattern = re2jPattern;
    }

    public static Regex compile(String regex) {
        try {
            return new Re2jRegex(Pattern.compile((String)regex));
        }
        catch (RuntimeException e) {
            throw new ValidationException("Pattern syntax error: " + e.getMessage());
        }
        catch (OutOfMemoryError | StackOverflowError e) {
            throw new ValidationException("Pattern complexity error: " + e.getMessage());
        }
    }

    @Override
    public Regex.Matcher matcher(CharSequence input) {
        return new Re2jMatcher(this.re2jPattern.matcher(input));
    }

    @Override
    public String toString() {
        return this.re2jPattern.toString();
    }

    private static final class Re2jMatcher
    implements Regex.Matcher {
        private final Matcher delegate;

        Re2jMatcher(Matcher delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean find() {
            return this.delegate.find();
        }
    }
}

