/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.youtube.patch;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.watermedia.api.network.patchs.AbstractPatch;
import org.watermedia.shaded.schabi.newpipe.extractor.NewPipe;
import org.watermedia.shaded.schabi.newpipe.extractor.ServiceList;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Request;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Response;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.Localization;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeService;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.AudioStream;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamType;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.VideoStream;

public class YouTubePatch
extends AbstractPatch {
    private static final Pattern YOUTUBE_PATTERN = Pattern.compile("^(?:https?://)?(?:www\\.|m\\.)?(?:youtube\\.com/(?:watch\\?v=|shorts/|embed/|v/)|youtu\\.be/)([a-zA-Z0-9_-]{11}).*$");
    private static volatile boolean initialized = false;
    private static final Object INIT_LOCK = new Object();
    private static final Map<String, Integer> RESOLUTION_MAP = Map.ofEntries(Map.entry("144p", 144), Map.entry("240p", 240), Map.entry("360p", 360), Map.entry("480p", 480), Map.entry("720p", 720), Map.entry("720p60", 720), Map.entry("1080p", 1080), Map.entry("1080p60", 1080), Map.entry("1440p", 1440), Map.entry("1440p60", 1440), Map.entry("2160p", 2160), Map.entry("2160p60", 2160), Map.entry("4320p", 4320), Map.entry("4320p60", 4320));
    private static final Map<AbstractPatch.Quality, Integer> QUALITY_TARGET = Map.of(AbstractPatch.Quality.LOWEST, 144, AbstractPatch.Quality.LOW, 360, AbstractPatch.Quality.MIDDLE, 720, AbstractPatch.Quality.HIGH, 1080, AbstractPatch.Quality.HIGHEST, Integer.MAX_VALUE);

    public YouTubePatch() {
        YouTubePatch.ensureInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureInitialized() {
        if (!initialized) {
            Object object = INIT_LOCK;
            synchronized (object) {
                if (!initialized) {
                    NewPipe.init(new WaterMediaDownloader(), new Localization("en", "US"));
                    initialized = true;
                }
            }
        }
    }

    public String platform() {
        return "YouTube";
    }

    public boolean isValid(URI uri) {
        if (uri == null) {
            return false;
        }
        String url = uri.toString();
        return YOUTUBE_PATTERN.matcher(url).matches();
    }

    public AbstractPatch.Result patch(URI uri, AbstractPatch.Quality prefQuality) throws AbstractPatch.FixingURLException {
        AbstractPatch.Quality quality = prefQuality = prefQuality != null ? prefQuality : AbstractPatch.Quality.HIGHEST;
        if (!this.isValid(uri)) {
            throw new AbstractPatch.FixingURLException(uri, (Throwable)new IllegalArgumentException("Invalid YouTube URL"));
        }
        try {
            URI primaryUri;
            List<AudioStream> audioStreams;
            AudioStream selectedAudio;
            String url = uri.toString();
            YoutubeService youtube = ServiceList.YouTube;
            StreamExtractor extractor = youtube.getStreamExtractor(url);
            extractor.fetchPage();
            StreamType streamType = extractor.getStreamType();
            boolean isLiveStream = streamType == StreamType.LIVE_STREAM || streamType == StreamType.AUDIO_LIVE_STREAM;
            boolean isVideoContent = streamType != StreamType.AUDIO_STREAM && streamType != StreamType.AUDIO_LIVE_STREAM;
            URI videoUri = null;
            URI audioUri = null;
            if (isVideoContent) {
                List<VideoStream> videoStreams = extractor.getVideoStreams();
                VideoStream selectedVideo = this.selectVideoStream(videoStreams, prefQuality);
                if (selectedVideo != null && selectedVideo.getContent() != null) {
                    videoUri = URI.create(selectedVideo.getContent());
                } else {
                    List<VideoStream> videoOnlyStreams = extractor.getVideoOnlyStreams();
                    selectedVideo = this.selectVideoStream(videoOnlyStreams, prefQuality);
                    if (selectedVideo != null && selectedVideo.getContent() != null) {
                        videoUri = URI.create(selectedVideo.getContent());
                    }
                }
            }
            if ((selectedAudio = this.selectAudioStream(audioStreams = extractor.getAudioStreams(), prefQuality)) != null && selectedAudio.getContent() != null) {
                audioUri = URI.create(selectedAudio.getContent());
            }
            URI uRI = primaryUri = videoUri != null ? videoUri : audioUri;
            if (primaryUri == null) {
                throw new AbstractPatch.FixingURLException(uri, (Throwable)new ExtractionException("No streams available"));
            }
            AbstractPatch.Result result = new AbstractPatch.Result(primaryUri, isVideoContent, isLiveStream, fallbackUri -> {
                try {
                    String content;
                    List<VideoStream> fallbackStreams = extractor.getVideoStreams();
                    if (!fallbackStreams.isEmpty() && (content = fallbackStreams.get(0).getContent()) != null) {
                        return new AbstractPatch.Result(URI.create(content), true, isLiveStream);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            });
            if (videoUri != null && audioUri != null) {
                result.setAudioTrack(audioUri);
            }
            return result;
        }
        catch (IOException | ExtractionException e) {
            throw new AbstractPatch.FixingURLException(uri, (Throwable)e);
        }
    }

    private VideoStream selectVideoStream(List<VideoStream> streams, AbstractPatch.Quality quality) {
        if (streams == null || streams.isEmpty()) {
            return null;
        }
        int targetResolution = QUALITY_TARGET.getOrDefault(quality, 720);
        if (quality == AbstractPatch.Quality.HIGHEST) {
            return streams.stream().filter(s -> s.getContent() != null).max(Comparator.comparingInt(this::getResolutionValue)).orElse(streams.get(0));
        }
        if (quality == AbstractPatch.Quality.LOWEST) {
            return streams.stream().filter(s -> s.getContent() != null).min(Comparator.comparingInt(this::getResolutionValue)).orElse(streams.get(0));
        }
        return streams.stream().filter(s -> s.getContent() != null).min(Comparator.comparingInt(s -> Math.abs(this.getResolutionValue((VideoStream)s) - targetResolution))).orElse(streams.get(0));
    }

    private AudioStream selectAudioStream(List<AudioStream> streams, AbstractPatch.Quality quality) {
        if (streams == null || streams.isEmpty()) {
            return null;
        }
        if (quality == AbstractPatch.Quality.HIGHEST || quality == AbstractPatch.Quality.HIGH) {
            return streams.stream().filter(s -> s.getContent() != null).max(Comparator.comparingInt(AudioStream::getAverageBitrate)).orElse(streams.get(0));
        }
        if (quality == AbstractPatch.Quality.LOWEST) {
            return streams.stream().filter(s -> s.getContent() != null).min(Comparator.comparingInt(AudioStream::getAverageBitrate)).orElse(streams.get(0));
        }
        int targetBitrate = quality == AbstractPatch.Quality.LOW ? 64 : 128;
        return streams.stream().filter(s -> s.getContent() != null).min(Comparator.comparingInt(s -> Math.abs(s.getAverageBitrate() - targetBitrate))).orElse(streams.get(0));
    }

    private int getResolutionValue(VideoStream stream) {
        String resolution = stream.getResolution();
        if (resolution.isEmpty()) {
            int height = stream.getHeight();
            return Math.max(height, 0);
        }
        return RESOLUTION_MAP.getOrDefault(resolution, this.parseResolution(resolution));
    }

    private int parseResolution(String resolution) {
        if (resolution == null) {
            return 0;
        }
        Matcher matcher = Pattern.compile("(\\d+)p").matcher(resolution);
        if (matcher.find()) {
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    private static class WaterMediaDownloader
    extends Downloader {
        private final HttpClient httpClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(30L)).build();

        @Override
        public Response execute(Request request) throws IOException {
            String url = request.url();
            Map<String, List<String>> headers = request.headers();
            byte[] dataToSend = request.dataToSend();
            HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofSeconds(30L));
            if (headers != null) {
                for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                    String headerName = entry.getKey();
                    for (String headerValue : entry.getValue()) {
                        builder.header(headerName, headerValue);
                    }
                }
            }
            if (dataToSend != null && dataToSend.length > 0) {
                builder.POST(HttpRequest.BodyPublishers.ofByteArray(dataToSend));
            } else {
                builder.GET();
            }
            try {
                HttpResponse<String> response = this.httpClient.send(builder.build(), HttpResponse.BodyHandlers.ofString());
                return new Response(response.statusCode(), response.body(), response.headers().map(), response.body(), response.uri().toString());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Request interrupted", e);
            }
        }
    }
}

