/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.utils.jsextractor;

import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.jsextractor.Lexer;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.jsextractor.Token;

public final class JavaScriptExtractor {
    private JavaScriptExtractor() {
    }

    @Nonnull
    public static String matchToClosingBrace(String jsCode, String start) throws ParsingException {
        int startIndex = jsCode.indexOf(start);
        if (startIndex < 0) {
            throw new ParsingException("Start not found");
        }
        String js = jsCode.substring(startIndex += start.length());
        Lexer lexer = new Lexer(js);
        boolean visitedOpenBrace = false;
        while (true) {
            Lexer.ParsedToken parsedToken = lexer.getNextToken();
            Token t = parsedToken.token;
            if (t == Token.LC) {
                visitedOpenBrace = true;
                continue;
            }
            if (visitedOpenBrace && lexer.isBalanced()) {
                return js.substring(0, parsedToken.end);
            }
            if (t == Token.EOF) break;
        }
        throw new ParsingException("Could not find matching braces");
    }
}

