/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.jsoup.Jsoup;
import org.watermedia.shaded.jsoup.nodes.Document;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;

public final class JsonUtils {
    private JsonUtils() {
    }

    @Nonnull
    public static Object getValue(@Nonnull JsonObject object, @Nonnull String path) throws ParsingException {
        List<String> keys = Arrays.asList(path.split("\\."));
        JsonObject parentObject = JsonUtils.getObject(object, keys.subList(0, keys.size() - 1));
        if (parentObject == null) {
            throw new ParsingException("Unable to get " + path);
        }
        Object result = parentObject.get(keys.get(keys.size() - 1));
        if (result == null) {
            throw new ParsingException("Unable to get " + path);
        }
        return result;
    }

    private static <T> T getInstanceOf(@Nonnull JsonObject object, @Nonnull String path, @Nonnull Class<T> klass) throws ParsingException {
        Object value = JsonUtils.getValue(object, path);
        if (klass.isInstance(value)) {
            return klass.cast(value);
        }
        throw new ParsingException("Wrong data type at path " + path);
    }

    @Nonnull
    public static String getString(@Nonnull JsonObject object, @Nonnull String path) throws ParsingException {
        return JsonUtils.getInstanceOf(object, path, String.class);
    }

    @Nonnull
    public static Boolean getBoolean(@Nonnull JsonObject object, @Nonnull String path) throws ParsingException {
        return JsonUtils.getInstanceOf(object, path, Boolean.class);
    }

    @Nonnull
    public static Number getNumber(@Nonnull JsonObject object, @Nonnull String path) throws ParsingException {
        return JsonUtils.getInstanceOf(object, path, Number.class);
    }

    @Nonnull
    public static JsonObject getObject(@Nonnull JsonObject object, @Nonnull String path) throws ParsingException {
        return JsonUtils.getInstanceOf(object, path, JsonObject.class);
    }

    @Nonnull
    public static JsonArray getArray(@Nonnull JsonObject object, @Nonnull String path) throws ParsingException {
        return JsonUtils.getInstanceOf(object, path, JsonArray.class);
    }

    @Nonnull
    public static List<Object> getValues(@Nonnull JsonArray array, @Nonnull String path) throws ParsingException {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < array.size(); ++i) {
            JsonObject obj = array.getObject(i);
            result.add(JsonUtils.getValue(obj, path));
        }
        return result;
    }

    @Nullable
    private static JsonObject getObject(@Nonnull JsonObject object, @Nonnull List<String> keys) {
        String key;
        JsonObject result = object;
        Iterator<String> iterator = keys.iterator();
        while (iterator.hasNext() && (result = result.getObject(key = iterator.next())) != null) {
        }
        return result;
    }

    public static JsonArray toJsonArray(String responseBody) throws ParsingException {
        try {
            return JsonParser.array().from(responseBody);
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse JSON", e);
        }
    }

    public static JsonObject toJsonObject(String responseBody) throws ParsingException {
        try {
            return JsonParser.object().from(responseBody);
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse JSON", e);
        }
    }

    public static JsonObject getJsonData(String html, String variable) throws JsonParserException, ArrayIndexOutOfBoundsException {
        Document document = Jsoup.parse(html);
        String json = document.getElementsByAttribute(variable).attr(variable);
        return JsonParser.object().from(json);
    }

    public static List<String> getStringListFromJsonArray(@Nonnull JsonArray array) {
        return array.stream().filter(String.class::isInstance).map(String.class::cast).collect(Collectors.toList());
    }
}

