/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.subscription;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.subscription.SubscriptionItem;

public abstract class SubscriptionExtractor {
    private final List<ContentSource> supportedSources;
    protected final StreamingService service;

    public SubscriptionExtractor(StreamingService service, List<ContentSource> supportedSources) {
        this.service = service;
        this.supportedSources = Collections.unmodifiableList(supportedSources);
    }

    public List<ContentSource> getSupportedSources() {
        return this.supportedSources;
    }

    @Nullable
    public abstract String getRelatedUrl();

    public List<SubscriptionItem> fromChannelUrl(String channelUrl) throws IOException, ExtractionException {
        throw new UnsupportedOperationException("Service " + this.service.getServiceInfo().getName() + " doesn't support extracting from a channel url");
    }

    public List<SubscriptionItem> fromInputStream(@Nonnull InputStream contentInputStream) throws ExtractionException {
        throw new UnsupportedOperationException("Service " + this.service.getServiceInfo().getName() + " doesn't support extracting from an InputStream");
    }

    public List<SubscriptionItem> fromInputStream(@Nonnull InputStream contentInputStream, @Nonnull String contentType) throws ExtractionException {
        throw new UnsupportedOperationException("Service " + this.service.getServiceInfo().getName() + " doesn't support extracting from an InputStream");
    }

    public static enum ContentSource {
        CHANNEL_URL,
        INPUT_STREAM;

    }

    public static class InvalidSourceException
    extends ParsingException {
        public InvalidSourceException() {
            this(null, null);
        }

        public InvalidSourceException(@Nullable String detailMessage) {
            this(detailMessage, null);
        }

        public InvalidSourceException(Throwable cause) {
            this(null, cause);
        }

        public InvalidSourceException(@Nullable String detailMessage, Throwable cause) {
            super("Not a valid source" + (String)(detailMessage == null ? "" : " (" + detailMessage + ")"), cause);
        }
    }
}

