/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.stream;

import java.io.Serializable;
import java.util.List;

public final class Frameset
implements Serializable {
    private final List<String> urls;
    private final int frameWidth;
    private final int frameHeight;
    private final int totalCount;
    private final int durationPerFrame;
    private final int framesPerPageX;
    private final int framesPerPageY;

    public Frameset(List<String> urls, int frameWidth, int frameHeight, int totalCount, int durationPerFrame, int framesPerPageX, int framesPerPageY) {
        this.urls = urls;
        this.totalCount = totalCount;
        this.durationPerFrame = durationPerFrame;
        this.frameWidth = frameWidth;
        this.frameHeight = frameHeight;
        this.framesPerPageX = framesPerPageX;
        this.framesPerPageY = framesPerPageY;
    }

    public List<String> getUrls() {
        return this.urls;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getFramesPerPageX() {
        return this.framesPerPageX;
    }

    public int getFramesPerPageY() {
        return this.framesPerPageY;
    }

    public int getFrameWidth() {
        return this.frameWidth;
    }

    public int getFrameHeight() {
        return this.frameHeight;
    }

    public int getDurationPerFrame() {
        return this.durationPerFrame;
    }

    public int[] getFrameBoundsAt(long position) {
        if (position < 0L || position > (long)(this.totalCount + 1) * (long)this.durationPerFrame) {
            return new int[]{0, 0, 0, this.frameWidth, this.frameHeight};
        }
        int framesPerStoryboard = this.framesPerPageX * this.framesPerPageY;
        int absoluteFrameNumber = Math.min((int)(position / (long)this.durationPerFrame), this.totalCount);
        int relativeFrameNumber = absoluteFrameNumber % framesPerStoryboard;
        int rowIndex = Math.floorDiv(relativeFrameNumber, this.framesPerPageX);
        int columnIndex = relativeFrameNumber % this.framesPerPageY;
        return new int[]{Math.floorDiv(absoluteFrameNumber, framesPerStoryboard), columnIndex * this.frameWidth, rowIndex * this.frameHeight, columnIndex * this.frameWidth + this.frameWidth, rowIndex * this.frameHeight + this.frameHeight};
    }
}

