/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.FoundAdException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.LinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubePlaylistLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public final class YoutubeStreamLinkHandlerFactory
extends LinkHandlerFactory {
    private static final Pattern YOUTUBE_VIDEO_ID_REGEX_PATTERN = Pattern.compile("^([a-zA-Z0-9_-]{11})");
    private static final YoutubeStreamLinkHandlerFactory INSTANCE = new YoutubeStreamLinkHandlerFactory();
    private static final List<String> SUBPATHS = List.of("embed/", "live/", "shorts/", "watch/", "v/", "w/");

    private YoutubeStreamLinkHandlerFactory() {
    }

    public static YoutubeStreamLinkHandlerFactory getInstance() {
        return INSTANCE;
    }

    @Nullable
    private static String extractId(@Nullable String id2) {
        if (id2 != null) {
            Matcher m = YOUTUBE_VIDEO_ID_REGEX_PATTERN.matcher(id2);
            return m.find() ? m.group(1) : null;
        }
        return null;
    }

    @Nonnull
    private static String assertIsId(@Nullable String id2) throws ParsingException {
        String extractedId = YoutubeStreamLinkHandlerFactory.extractId(id2);
        if (extractedId != null) {
            return extractedId;
        }
        throw new ParsingException("The given string is not a YouTube video ID");
    }

    @Override
    @Nonnull
    public String getUrl(String id2) throws ParsingException, UnsupportedOperationException {
        return "https://www.youtube.com/watch?v=" + id2;
    }

    @Override
    @Nonnull
    public String getId(String theUrlString) throws ParsingException, UnsupportedOperationException {
        URL url;
        Object urlString;
        block62: {
            urlString = theUrlString;
            try {
                URI uri = new URI((String)urlString);
                String scheme = uri.getScheme();
                if (scheme == null || !scheme.equals("vnd.youtube") && !scheme.equals("vnd.youtube.launch")) break block62;
                String schemeSpecificPart = uri.getSchemeSpecificPart();
                if (schemeSpecificPart.startsWith("//")) {
                    String extractedId = YoutubeStreamLinkHandlerFactory.extractId(schemeSpecificPart.substring(2));
                    if (extractedId != null) {
                        return extractedId;
                    }
                    urlString = "https:" + schemeSpecificPart;
                    break block62;
                }
                return YoutubeStreamLinkHandlerFactory.assertIsId(schemeSpecificPart);
            }
            catch (URISyntaxException uri) {
                // empty catch block
            }
        }
        try {
            url = Utils.stringToURL((String)urlString);
        }
        catch (MalformedURLException e) {
            throw new ParsingException("The given URL is not valid", e);
        }
        String host = url.getHost();
        String path = url.getPath();
        if (!path.isEmpty()) {
            path = path.substring(1);
        }
        if (!(Utils.isHTTP(url) && (YoutubeParsingHelper.isYoutubeURL(url) || YoutubeParsingHelper.isYoutubeServiceURL(url) || YoutubeParsingHelper.isHooktubeURL(url) || YoutubeParsingHelper.isInvidiousURL(url) || YoutubeParsingHelper.isY2ubeURL(url)))) {
            if (host.equalsIgnoreCase("googleads.g.doubleclick.net")) {
                throw new FoundAdException("Error: found ad: " + (String)urlString);
            }
            throw new ParsingException("The URL is not a YouTube URL");
        }
        if (YoutubePlaylistLinkHandlerFactory.getInstance().acceptUrl((String)urlString)) {
            throw new ParsingException("Error: no suitable URL: " + (String)urlString);
        }
        switch (host.toUpperCase()) {
            case "WWW.YOUTUBE-NOCOOKIE.COM": {
                if (!path.startsWith("embed/")) break;
                return YoutubeStreamLinkHandlerFactory.assertIsId(path.substring(6));
            }
            case "YOUTUBE.COM": 
            case "WWW.YOUTUBE.COM": 
            case "M.YOUTUBE.COM": 
            case "MUSIC.YOUTUBE.COM": {
                if (path.equals("attribution_link")) {
                    URL decodedURL;
                    String uQueryValue = Utils.getQueryValue(url, "u");
                    try {
                        decodedURL = Utils.stringToURL("https://www.youtube.com" + uQueryValue);
                    }
                    catch (MalformedURLException e) {
                        throw new ParsingException("Error: no suitable URL: " + (String)urlString);
                    }
                    String viewQueryValue = Utils.getQueryValue(decodedURL, "v");
                    return YoutubeStreamLinkHandlerFactory.assertIsId(viewQueryValue);
                }
                String maybeId = this.getIdFromSubpathsInPath(path);
                if (maybeId != null) {
                    return maybeId;
                }
                String viewQueryValue = Utils.getQueryValue(url, "v");
                return YoutubeStreamLinkHandlerFactory.assertIsId(viewQueryValue);
            }
            case "Y2U.BE": 
            case "YOUTU.BE": {
                String viewQueryValue = Utils.getQueryValue(url, "v");
                if (viewQueryValue != null) {
                    return YoutubeStreamLinkHandlerFactory.assertIsId(viewQueryValue);
                }
                return YoutubeStreamLinkHandlerFactory.assertIsId(path);
            }
            case "HOOKTUBE.COM": 
            case "INVIDIO.US": 
            case "DEV.INVIDIO.US": 
            case "WWW.INVIDIO.US": 
            case "REDIRECT.INVIDIOUS.IO": 
            case "INVIDIOUS.SNOPYTA.ORG": 
            case "YEWTU.BE": 
            case "TUBE.CONNECT.CAFE": 
            case "TUBUS.EDUVID.ORG": 
            case "INVIDIOUS.KAVIN.ROCKS": 
            case "INVIDIOUS-US.KAVIN.ROCKS": 
            case "PIPED.KAVIN.ROCKS": 
            case "INVIDIOUS.SITE": 
            case "VID.MINT.LGBT": 
            case "INVIDIOU.SITE": 
            case "INVIDIOUS.FDN.FR": 
            case "INVIDIOUS.048596.XYZ": 
            case "INVIDIOUS.ZEE.LI": 
            case "VID.PUFFYAN.US": 
            case "YTPRIVATE.COM": 
            case "INVIDIOUS.NAMAZSO.EU": 
            case "INVIDIOUS.SILKKY.CLOUD": 
            case "INVIDIOUS.EXONIP.DE": 
            case "INV.RIVERSIDE.ROCKS": 
            case "INVIDIOUS.BLAMEFRAN.NET": 
            case "INVIDIOUS.MOOMOO.ME": 
            case "YTB.TROM.TF": 
            case "YT.CYBERHOST.UK": 
            case "Y.COM.CM": {
                String viewQueryValue;
                if (path.equals("watch") && (viewQueryValue = Utils.getQueryValue(url, "v")) != null) {
                    return YoutubeStreamLinkHandlerFactory.assertIsId(viewQueryValue);
                }
                String maybeId = this.getIdFromSubpathsInPath(path);
                if (maybeId != null) {
                    return maybeId;
                }
                String viewQueryValue2 = Utils.getQueryValue(url, "v");
                if (viewQueryValue2 != null) {
                    return YoutubeStreamLinkHandlerFactory.assertIsId(viewQueryValue2);
                }
                return YoutubeStreamLinkHandlerFactory.assertIsId(path);
            }
        }
        throw new ParsingException("Error: no suitable URL: " + (String)urlString);
    }

    @Override
    public boolean onAcceptUrl(String url) throws FoundAdException {
        try {
            this.getId(url);
            return true;
        }
        catch (FoundAdException fe) {
            throw fe;
        }
        catch (ParsingException e) {
            return false;
        }
    }

    @Nullable
    private String getIdFromSubpathsInPath(@Nonnull String path) throws ParsingException {
        for (String subpath : SUBPATHS) {
            if (!path.startsWith(subpath)) continue;
            String id2 = path.substring(subpath.length());
            return YoutubeStreamLinkHandlerFactory.assertIsId(id2);
        }
        return null;
    }
}

