/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.LinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public final class YoutubePlaylistLinkHandlerFactory
extends ListLinkHandlerFactory {
    private static final YoutubePlaylistLinkHandlerFactory INSTANCE = new YoutubePlaylistLinkHandlerFactory();

    private YoutubePlaylistLinkHandlerFactory() {
    }

    public static YoutubePlaylistLinkHandlerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public String getUrl(String id2, List<String> contentFilters, String sortFilter) throws ParsingException, UnsupportedOperationException {
        return "https://www.youtube.com/playlist?list=" + id2;
    }

    @Override
    public String getId(String url) throws ParsingException, UnsupportedOperationException {
        try {
            URL urlObj = Utils.stringToURL(url);
            if (!Utils.isHTTP(urlObj) || !YoutubeParsingHelper.isYoutubeURL(urlObj) && !YoutubeParsingHelper.isInvidiousURL(urlObj)) {
                throw new ParsingException("the url given is not a YouTube-URL");
            }
            String path = urlObj.getPath();
            if (!path.equals("/watch") && !path.equals("/playlist")) {
                throw new ParsingException("the url given is neither a video nor a playlist URL");
            }
            String listID = Utils.getQueryValue(urlObj, "list");
            if (listID == null) {
                throw new ParsingException("the URL given does not include a playlist");
            }
            if (!listID.matches("[a-zA-Z0-9_-]{10,}")) {
                throw new ParsingException("the list-ID given in the URL does not match the list pattern");
            }
            return listID;
        }
        catch (Exception exception) {
            throw new ParsingException("Error could not parse URL: " + exception.getMessage(), exception);
        }
    }

    @Override
    public boolean onAcceptUrl(String url) {
        try {
            this.getId(url);
        }
        catch (ParsingException e) {
            return false;
        }
        return true;
    }

    @Override
    public ListLinkHandler fromUrl(String url) throws ParsingException {
        try {
            URL urlObj = Utils.stringToURL(url);
            String listID = Utils.getQueryValue(urlObj, "list");
            if (listID != null && YoutubeParsingHelper.isYoutubeMixId(listID)) {
                String videoID = Utils.getQueryValue(urlObj, "v");
                if (videoID == null) {
                    videoID = YoutubeParsingHelper.extractVideoIdFromMixId(listID);
                }
                String newUrl = "https://www.youtube.com/watch?v=" + videoID + "&list=" + listID;
                return new ListLinkHandler(new LinkHandler(url, newUrl, listID));
            }
        }
        catch (MalformedURLException exception) {
            throw new ParsingException("Error could not parse URL: " + exception.getMessage(), exception);
        }
        return super.fromUrl(url);
    }
}

