/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeService;
import org.watermedia.shaded.schabi.newpipe.extractor.subscription.SubscriptionExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.subscription.SubscriptionItem;

public class YoutubeSubscriptionExtractor
extends SubscriptionExtractor {
    private static final String BASE_CHANNEL_URL = "https://www.youtube.com/channel/";

    public YoutubeSubscriptionExtractor(YoutubeService youtubeService) {
        super(youtubeService, Collections.singletonList(SubscriptionExtractor.ContentSource.INPUT_STREAM));
    }

    @Override
    public String getRelatedUrl() {
        return "https://takeout.google.com/takeout/custom/youtube";
    }

    @Override
    public List<SubscriptionItem> fromInputStream(@Nonnull InputStream contentInputStream) throws ExtractionException {
        return this.fromJsonInputStream(contentInputStream);
    }

    @Override
    public List<SubscriptionItem> fromInputStream(@Nonnull InputStream contentInputStream, @Nonnull String contentType) throws ExtractionException {
        switch (contentType) {
            case "json": 
            case "application/json": {
                return this.fromJsonInputStream(contentInputStream);
            }
            case "csv": 
            case "text/csv": 
            case "text/comma-separated-values": {
                return this.fromCsvInputStream(contentInputStream);
            }
            case "zip": 
            case "application/zip": {
                return this.fromZipInputStream(contentInputStream);
            }
        }
        throw new SubscriptionExtractor.InvalidSourceException("Unsupported content type: " + contentType);
    }

    public List<SubscriptionItem> fromJsonInputStream(@Nonnull InputStream contentInputStream) throws ExtractionException {
        JsonArray subscriptions;
        try {
            subscriptions = JsonParser.array().from(contentInputStream);
        }
        catch (JsonParserException e) {
            throw new SubscriptionExtractor.InvalidSourceException("Invalid json input stream", e);
        }
        boolean foundInvalidSubscription = false;
        ArrayList<SubscriptionItem> subscriptionItems = new ArrayList<SubscriptionItem>();
        for (Object subscriptionObject : subscriptions) {
            if (!(subscriptionObject instanceof JsonObject)) {
                foundInvalidSubscription = true;
                continue;
            }
            JsonObject subscription = ((JsonObject)subscriptionObject).getObject("snippet");
            String id2 = subscription.getObject("resourceId").getString("channelId", "");
            if (id2.length() != 24) {
                foundInvalidSubscription = true;
                continue;
            }
            subscriptionItems.add(new SubscriptionItem(this.service.getServiceId(), BASE_CHANNEL_URL + id2, subscription.getString("title", "")));
        }
        if (foundInvalidSubscription && subscriptionItems.isEmpty()) {
            throw new SubscriptionExtractor.InvalidSourceException("Found only invalid channel ids");
        }
        return subscriptionItems;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<SubscriptionItem> fromZipInputStream(@Nonnull InputStream contentInputStream) throws ExtractionException {
        try (ZipInputStream zipInputStream = new ZipInputStream(contentInputStream);){
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!zipEntry.getName().toLowerCase().endsWith(".csv")) continue;
                try {
                    List<SubscriptionItem> csvItems = this.fromCsvInputStream(zipInputStream);
                    if (csvItems.isEmpty()) continue;
                    List<SubscriptionItem> list = csvItems;
                    return list;
                }
                catch (ExtractionException extractionException) {}
            }
            throw new SubscriptionExtractor.InvalidSourceException("Unable to find a valid subscriptions.csv file (try extracting and selecting the csv file)");
        }
        catch (IOException e) {
            throw new SubscriptionExtractor.InvalidSourceException("Error reading contents of zip file", e);
        }
    }

    public List<SubscriptionItem> fromCsvInputStream(@Nonnull InputStream contentInputStream) throws ExtractionException {
        List<SubscriptionItem> list;
        BufferedReader reader = new BufferedReader(new InputStreamReader(contentInputStream));
        try {
            list = reader.lines().skip(1L).map(line -> line.split(",")).filter(values -> ((String[])values).length >= 3).map(values -> {
                String channelUrl = values[1].replace("http://", "https://");
                return channelUrl.startsWith(BASE_CHANNEL_URL) ? new SubscriptionItem(this.service.getServiceId(), channelUrl, values[2]) : null;
            }).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | UncheckedIOException e) {
                throw new SubscriptionExtractor.InvalidSourceException("Error reading CSV file", e);
            }
        }
        reader.close();
        return list;
    }
}

