/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonBuilder;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonWriter;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.MediaFormat;
import org.watermedia.shaded.schabi.newpipe.extractor.MetaInfo;
import org.watermedia.shaded.schabi.newpipe.extractor.MultiInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.AgeRestrictedContentException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ContentNotAvailableException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.GeographicRestrictionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.PaidContentException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.PrivateContentException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.YoutubeMusicPremiumContentException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.LinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.ContentCountry;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.DateWrapper;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.Localization;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.TimeAgoParser;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.TimeAgoPatternsManager;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.ItagItem;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.PoTokenProvider;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.PoTokenResult;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeDescriptionHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeJavaScriptPlayerManager;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeMetaInfoHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeStreamHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.ItagInfo;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeMixOrPlaylistInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeMixOrPlaylistLockupInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeStreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeStreamInfoItemLockupExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubeChannelLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.AudioStream;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.DeliveryMethod;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Description;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Frameset;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamSegment;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamType;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.SubtitlesStream;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.VideoStream;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.JsonUtils;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.LocaleCompat;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Pair;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Parser;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class YoutubeStreamExtractor
extends StreamExtractor {
    @Nullable
    private static PoTokenProvider poTokenProvider;
    private static boolean fetchIosClient;
    private JsonObject playerResponse;
    private JsonObject nextResponse;
    @Nullable
    private JsonObject iosStreamingData;
    @Nullable
    private JsonObject androidStreamingData;
    @Nullable
    private JsonObject html5StreamingData;
    private JsonObject videoPrimaryInfoRenderer;
    private JsonObject videoSecondaryInfoRenderer;
    private JsonObject playerMicroFormatRenderer;
    private JsonObject playerCaptionsTracklistRenderer;
    private int ageLimit = -1;
    private StreamType streamType;
    private String iosCpn;
    private String androidCpn;
    private String html5Cpn;
    @Nullable
    private String html5StreamingUrlsPoToken;
    @Nullable
    private String androidStreamingUrlsPoToken;
    @Nullable
    private String iosStreamingUrlsPoToken;
    private static final String FORMATS = "formats";
    private static final String ADAPTIVE_FORMATS = "adaptiveFormats";
    private static final String STREAMING_DATA = "streamingData";
    private static final String NEXT = "next";
    private static final String SIGNATURE_CIPHER = "signatureCipher";
    private static final String CIPHER = "cipher";
    private static final String PLAYER_CAPTIONS_TRACKLIST_RENDERER = "playerCaptionsTracklistRenderer";
    private static final String CAPTIONS = "captions";
    private static final String PLAYABILITY_STATUS = "playabilityStatus";

    public YoutubeStreamExtractor(StreamingService service, LinkHandler linkHandler) {
        super(service, linkHandler);
    }

    @Override
    @Nonnull
    public String getName() throws ParsingException {
        this.assertPageFetched();
        String title = this.playerResponse.getObject("videoDetails").getString("title");
        if (Utils.isNullOrEmpty(title) && Utils.isNullOrEmpty(title = YoutubeParsingHelper.getTextFromObject(this.getVideoPrimaryInfoRenderer().getObject("title")))) {
            throw new ParsingException("Could not get name");
        }
        return title;
    }

    @Override
    @Nullable
    public String getTextualUploadDate() throws ParsingException {
        if (!this.playerMicroFormatRenderer.getString("uploadDate", "").isEmpty()) {
            return this.playerMicroFormatRenderer.getString("uploadDate");
        }
        if (!this.playerMicroFormatRenderer.getString("publishDate", "").isEmpty()) {
            return this.playerMicroFormatRenderer.getString("publishDate");
        }
        JsonObject liveDetails = this.playerMicroFormatRenderer.getObject("liveBroadcastDetails");
        if (!liveDetails.getString("endTimestamp", "").isEmpty()) {
            return liveDetails.getString("endTimestamp");
        }
        if (!liveDetails.getString("startTimestamp", "").isEmpty()) {
            return liveDetails.getString("startTimestamp");
        }
        if (this.getStreamType() == StreamType.LIVE_STREAM) {
            return null;
        }
        String videoPrimaryInfoRendererDateText = YoutubeParsingHelper.getTextFromObject(this.getVideoPrimaryInfoRenderer().getObject("dateText"));
        if (videoPrimaryInfoRendererDateText != null) {
            if (videoPrimaryInfoRendererDateText.startsWith("Premiered")) {
                String time = videoPrimaryInfoRendererDateText.substring(13);
                try {
                    TimeAgoParser timeAgoParser = TimeAgoPatternsManager.getTimeAgoParserFor(new Localization("en"));
                    OffsetDateTime parsedTime = timeAgoParser.parse(time).offsetDateTime();
                    return DateTimeFormatter.ISO_LOCAL_DATE.format(parsedTime);
                }
                catch (Exception timeAgoParser) {
                    try {
                        LocalDate localDate = LocalDate.parse(time, DateTimeFormatter.ofPattern("MMM dd, yyyy", Locale.ENGLISH));
                        return DateTimeFormatter.ISO_LOCAL_DATE.format(localDate);
                    }
                    catch (Exception localDate) {
                        try {
                            LocalDate localDate2 = LocalDate.parse(time, DateTimeFormatter.ofPattern("dd MMM yyyy", Locale.ENGLISH));
                            return DateTimeFormatter.ISO_LOCAL_DATE.format(localDate2);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            try {
                LocalDate localDate = LocalDate.parse(videoPrimaryInfoRendererDateText, DateTimeFormatter.ofPattern("dd MMM yyyy", Locale.ENGLISH));
                return DateTimeFormatter.ISO_LOCAL_DATE.format(localDate);
            }
            catch (Exception e) {
                throw new ParsingException("Could not get upload date", e);
            }
        }
        throw new ParsingException("Could not get upload date");
    }

    @Override
    public DateWrapper getUploadDate() throws ParsingException {
        String textualUploadDate = this.getTextualUploadDate();
        if (Utils.isNullOrEmpty(textualUploadDate)) {
            return null;
        }
        return new DateWrapper(YoutubeParsingHelper.parseDateFrom(textualUploadDate), true);
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        this.assertPageFetched();
        try {
            return YoutubeParsingHelper.getImagesFromThumbnailsArray(this.playerResponse.getObject("videoDetails").getObject("thumbnail").getArray("thumbnails"));
        }
        catch (Exception e) {
            throw new ParsingException("Could not get thumbnails");
        }
    }

    @Override
    @Nonnull
    public Description getDescription() throws ParsingException {
        this.assertPageFetched();
        String videoSecondaryInfoRendererDescription = YoutubeParsingHelper.getTextFromObject(this.getVideoSecondaryInfoRenderer().getObject("description"), true);
        if (!Utils.isNullOrEmpty(videoSecondaryInfoRendererDescription)) {
            return new Description(videoSecondaryInfoRendererDescription, 1);
        }
        String attributedDescription = YoutubeDescriptionHelper.attributedDescriptionToHtml(this.getVideoSecondaryInfoRenderer().getObject("attributedDescription"));
        if (!Utils.isNullOrEmpty(attributedDescription)) {
            return new Description(attributedDescription, 1);
        }
        String description = this.playerResponse.getObject("videoDetails").getString("shortDescription");
        if (description == null) {
            JsonObject descriptionObject = this.playerMicroFormatRenderer.getObject("description");
            description = YoutubeParsingHelper.getTextFromObject(descriptionObject);
        }
        return new Description(description, 3);
    }

    @Override
    public int getAgeLimit() throws ParsingException {
        if (this.ageLimit != -1) {
            return this.ageLimit;
        }
        boolean ageRestricted = this.getVideoSecondaryInfoRenderer().getObject("metadataRowContainer").getObject("metadataRowContainerRenderer").getArray("rows").stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).flatMap(metadataRow -> metadataRow.getObject("metadataRowRenderer").getArray("contents").stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast)).flatMap(content -> content.getArray("runs").stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast)).map(run -> run.getString("text", "")).anyMatch(rowText -> rowText.contains("Age-restricted"));
        this.ageLimit = ageRestricted ? 18 : 0;
        return this.ageLimit;
    }

    @Override
    public long getLength() throws ParsingException {
        this.assertPageFetched();
        try {
            String duration = this.playerResponse.getObject("videoDetails").getString("lengthSeconds");
            return Long.parseLong(duration);
        }
        catch (Exception e) {
            return this.getDurationFromFirstAdaptiveFormat(Arrays.asList(this.html5StreamingData, this.androidStreamingData, this.iosStreamingData));
        }
    }

    private int getDurationFromFirstAdaptiveFormat(@Nonnull List<JsonObject> streamingDatas) throws ParsingException {
        for (JsonObject streamingData : streamingDatas) {
            JsonArray adaptiveFormats = streamingData.getArray(ADAPTIVE_FORMATS);
            if (adaptiveFormats.isEmpty()) continue;
            String durationMs = adaptiveFormats.getObject(0).getString("approxDurationMs");
            try {
                return Math.round((float)Long.parseLong(durationMs) / 1000.0f);
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        throw new ParsingException("Could not get duration");
    }

    @Override
    public long getTimeStamp() throws ParsingException {
        long timestamp = this.getTimestampSeconds("((#|&|\\?)t=\\d*h?\\d*m?\\d+s?)");
        if (timestamp == -2L) {
            return 0L;
        }
        return timestamp;
    }

    @Override
    public long getViewCount() throws ParsingException {
        String views = YoutubeParsingHelper.getTextFromObject(this.getVideoPrimaryInfoRenderer().getObject("viewCount").getObject("videoViewCountRenderer").getObject("viewCount"));
        if (Utils.isNullOrEmpty(views) && Utils.isNullOrEmpty(views = this.playerResponse.getObject("videoDetails").getString("viewCount"))) {
            throw new ParsingException("Could not get view count");
        }
        if (views.toLowerCase().contains("no views")) {
            return 0L;
        }
        return Long.parseLong(Utils.removeNonDigitCharacters(views));
    }

    @Override
    public long getLikeCount() throws ParsingException {
        this.assertPageFetched();
        if (!this.playerResponse.getObject("videoDetails").getBoolean("allowRatings")) {
            return -1L;
        }
        JsonArray topLevelButtons = this.getVideoPrimaryInfoRenderer().getObject("videoActions").getObject("menuRenderer").getArray("topLevelButtons");
        try {
            return YoutubeStreamExtractor.parseLikeCountFromLikeButtonViewModel(topLevelButtons);
        }
        catch (ParsingException parsingException) {
            try {
                return YoutubeStreamExtractor.parseLikeCountFromLikeButtonRenderer(topLevelButtons);
            }
            catch (ParsingException e) {
                throw new ParsingException("Could not get like count", e);
            }
        }
    }

    private static long parseLikeCountFromLikeButtonRenderer(@Nonnull JsonArray topLevelButtons) throws ParsingException {
        String likesString = null;
        JsonObject likeToggleButtonRenderer = topLevelButtons.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(button -> button.getObject("segmentedLikeDislikeButtonRenderer").getObject("likeButton").getObject("toggleButtonRenderer")).filter(toggleButtonRenderer -> !Utils.isNullOrEmpty(toggleButtonRenderer)).findFirst().orElse(null);
        if (likeToggleButtonRenderer != null) {
            likesString = likeToggleButtonRenderer.getObject("accessibilityData").getObject("accessibilityData").getString("label");
            if (likesString == null) {
                likesString = likeToggleButtonRenderer.getObject("accessibility").getString("label");
            }
            if (likesString == null) {
                likesString = likeToggleButtonRenderer.getObject("defaultText").getObject("accessibility").getObject("accessibilityData").getString("label");
            }
            if (likesString != null && likesString.toLowerCase().contains("no likes")) {
                return 0L;
            }
        }
        if (likesString == null) {
            throw new ParsingException("Could not get like count from accessibility data");
        }
        try {
            return Long.parseLong(Utils.removeNonDigitCharacters(likesString));
        }
        catch (NumberFormatException e) {
            throw new ParsingException("Could not parse \"" + likesString + "\" as a long", e);
        }
    }

    private static long parseLikeCountFromLikeButtonViewModel(@Nonnull JsonArray topLevelButtons) throws ParsingException {
        JsonObject likeToggleButtonViewModel = topLevelButtons.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(button -> button.getObject("segmentedLikeDislikeButtonViewModel").getObject("likeButtonViewModel").getObject("likeButtonViewModel").getObject("toggleButtonViewModel").getObject("toggleButtonViewModel").getObject("defaultButtonViewModel").getObject("buttonViewModel")).filter(buttonViewModel -> !Utils.isNullOrEmpty(buttonViewModel)).findFirst().orElse(null);
        if (likeToggleButtonViewModel == null) {
            throw new ParsingException("Could not find buttonViewModel object");
        }
        String accessibilityText = likeToggleButtonViewModel.getString("accessibilityText");
        if (accessibilityText == null) {
            throw new ParsingException("Could not find buttonViewModel's accessibilityText string");
        }
        try {
            return Long.parseLong(Utils.removeNonDigitCharacters(accessibilityText));
        }
        catch (NumberFormatException e) {
            throw new ParsingException("Could not parse \"" + accessibilityText + "\" as a long", e);
        }
    }

    @Override
    @Nonnull
    public String getUploaderUrl() throws ParsingException {
        this.assertPageFetched();
        String uploaderId = this.playerResponse.getObject("videoDetails").getString("channelId");
        if (!Utils.isNullOrEmpty(uploaderId)) {
            return YoutubeChannelLinkHandlerFactory.getInstance().getUrl("channel/" + uploaderId);
        }
        throw new ParsingException("Could not get uploader url");
    }

    @Override
    @Nonnull
    public String getUploaderName() throws ParsingException {
        this.assertPageFetched();
        String uploaderName = this.playerResponse.getObject("videoDetails").getString("author");
        if (Utils.isNullOrEmpty(uploaderName)) {
            throw new ParsingException("Could not get uploader name");
        }
        return uploaderName;
    }

    @Override
    public boolean isUploaderVerified() throws ParsingException {
        return YoutubeParsingHelper.isVerified(this.getVideoSecondaryInfoRenderer().getObject("owner").getObject("videoOwnerRenderer").getArray("badges"));
    }

    @Override
    @Nonnull
    public List<Image> getUploaderAvatars() throws ParsingException {
        this.assertPageFetched();
        List<Image> imageList = YoutubeParsingHelper.getImagesFromThumbnailsArray(this.getVideoSecondaryInfoRenderer().getObject("owner").getObject("videoOwnerRenderer").getObject("thumbnail").getArray("thumbnails"));
        if (imageList.isEmpty() && this.ageLimit == 0) {
            throw new ParsingException("Could not get uploader avatars");
        }
        return imageList;
    }

    @Override
    public long getUploaderSubscriberCount() throws ParsingException {
        JsonObject videoOwnerRenderer = JsonUtils.getObject(this.videoSecondaryInfoRenderer, "owner.videoOwnerRenderer");
        if (!videoOwnerRenderer.has("subscriberCountText")) {
            return -1L;
        }
        try {
            return Utils.mixedNumberWordToLong(YoutubeParsingHelper.getTextFromObject(videoOwnerRenderer.getObject("subscriberCountText")));
        }
        catch (NumberFormatException e) {
            throw new ParsingException("Could not get uploader subscriber count", e);
        }
    }

    @Override
    @Nonnull
    public String getDashMpdUrl() throws ParsingException {
        this.assertPageFetched();
        return YoutubeStreamExtractor.getManifestUrl("dash", Arrays.asList(new Pair<JsonObject, String>(this.androidStreamingData, this.androidStreamingUrlsPoToken), new Pair<JsonObject, String>(this.html5StreamingData, this.html5StreamingUrlsPoToken)), "mpd_version=7");
    }

    @Override
    @Nonnull
    public String getHlsUrl() throws ParsingException {
        this.assertPageFetched();
        return YoutubeStreamExtractor.getManifestUrl("hls", Arrays.asList(new Pair<JsonObject, String>(this.iosStreamingData, this.iosStreamingUrlsPoToken), new Pair<JsonObject, String>(this.androidStreamingData, this.androidStreamingUrlsPoToken), new Pair<JsonObject, String>(this.html5StreamingData, this.html5StreamingUrlsPoToken)), "");
    }

    @Nonnull
    private static String getManifestUrl(@Nonnull String manifestType, @Nonnull List<Pair<JsonObject, String>> streamingDataObjects, @Nonnull String partToAppendToManifestUrlEnd) {
        String manifestKey = manifestType + "ManifestUrl";
        for (Pair<JsonObject, String> streamingDataObj : streamingDataObjects) {
            String manifestUrl;
            if (streamingDataObj.getFirst() == null || Utils.isNullOrEmpty(manifestUrl = streamingDataObj.getFirst().getString(manifestKey))) continue;
            if (streamingDataObj.getSecond() == null) {
                return manifestUrl + "?" + partToAppendToManifestUrlEnd;
            }
            return manifestUrl + "?pot=" + streamingDataObj.getSecond() + "&" + partToAppendToManifestUrlEnd;
        }
        return "";
    }

    @Override
    public List<AudioStream> getAudioStreams() throws ExtractionException {
        this.assertPageFetched();
        return this.getItags(ADAPTIVE_FORMATS, ItagItem.ItagType.AUDIO, this.getAudioStreamBuilderHelper(), "audio");
    }

    @Override
    public List<VideoStream> getVideoStreams() throws ExtractionException {
        this.assertPageFetched();
        return this.getItags(FORMATS, ItagItem.ItagType.VIDEO, this.getVideoStreamBuilderHelper(false), "video");
    }

    @Override
    public List<VideoStream> getVideoOnlyStreams() throws ExtractionException {
        this.assertPageFetched();
        return this.getItags(ADAPTIVE_FORMATS, ItagItem.ItagType.VIDEO_ONLY, this.getVideoStreamBuilderHelper(true), "video-only");
    }

    @Override
    @Nonnull
    public List<SubtitlesStream> getSubtitlesDefault() throws ParsingException {
        return this.getSubtitles(MediaFormat.TTML);
    }

    @Override
    @Nonnull
    public List<SubtitlesStream> getSubtitles(MediaFormat format) throws ParsingException {
        this.assertPageFetched();
        ArrayList<SubtitlesStream> subtitlesToReturn = new ArrayList<SubtitlesStream>();
        JsonArray captionsArray = this.playerCaptionsTracklistRenderer.getArray("captionTracks");
        for (int i = 0; i < captionsArray.size(); ++i) {
            String languageCode = captionsArray.getObject(i).getString("languageCode");
            String baseUrl = captionsArray.getObject(i).getString("baseUrl");
            String vssId = captionsArray.getObject(i).getString("vssId");
            if (languageCode == null || baseUrl == null || vssId == null) continue;
            boolean isAutoGenerated = vssId.startsWith("a.");
            String cleanUrl = baseUrl.replaceAll("&fmt=[^&]*", "").replaceAll("&tlang=[^&]*", "");
            subtitlesToReturn.add(new SubtitlesStream.Builder().setContent(cleanUrl + "&fmt=" + format.getSuffix(), true).setMediaFormat(format).setLanguageCode(languageCode).setAutoGenerated(isAutoGenerated).build());
        }
        return subtitlesToReturn;
    }

    @Override
    public StreamType getStreamType() {
        this.assertPageFetched();
        return this.streamType;
    }

    private void setStreamType() {
        this.streamType = this.playerResponse.getObject(PLAYABILITY_STATUS).has("liveStreamability") ? StreamType.LIVE_STREAM : (this.playerResponse.getObject("videoDetails").getBoolean("isPostLiveDvr", false) ? StreamType.POST_LIVE_STREAM : StreamType.VIDEO_STREAM);
    }

    @Nullable
    public MultiInfoItemsCollector getRelatedItems() throws ExtractionException {
        this.assertPageFetched();
        if (this.getAgeLimit() != 0) {
            return null;
        }
        try {
            MultiInfoItemsCollector collector = new MultiInfoItemsCollector(this.getServiceId());
            JsonArray results = this.nextResponse.getObject("contents").getObject("twoColumnWatchNextResults").getObject("secondaryResults").getObject("secondaryResults").getArray("results");
            TimeAgoParser timeAgoParser = this.getTimeAgoParser();
            results.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(result -> {
                if (result.has("org.watermedia.shaded.compactVideoRenderer")) {
                    return new YoutubeStreamInfoItemExtractor(result.getObject("org.watermedia.shaded.compactVideoRenderer"), timeAgoParser);
                }
                if (result.has("org.watermedia.shaded.compactRadioRenderer")) {
                    return new YoutubeMixOrPlaylistInfoItemExtractor(result.getObject("org.watermedia.shaded.compactRadioRenderer"));
                }
                if (result.has("org.watermedia.shaded.compactPlaylistRenderer")) {
                    return new YoutubeMixOrPlaylistInfoItemExtractor(result.getObject("org.watermedia.shaded.compactPlaylistRenderer"));
                }
                if (result.has("lockupViewModel")) {
                    JsonObject lockupViewModel = result.getObject("lockupViewModel");
                    String contentType = lockupViewModel.getString("contentType");
                    if ("LOCKUP_CONTENT_TYPE_PLAYLIST".equals(contentType) || "LOCKUP_CONTENT_TYPE_PODCAST".equals(contentType)) {
                        return new YoutubeMixOrPlaylistLockupInfoItemExtractor(lockupViewModel);
                    }
                    if ("LOCKUP_CONTENT_TYPE_VIDEO".equals(contentType)) {
                        return new YoutubeStreamInfoItemLockupExtractor(lockupViewModel, timeAgoParser);
                    }
                }
                return null;
            }).filter(Objects::nonNull).forEach(collector::commit);
            return collector;
        }
        catch (Exception e) {
            throw new ParsingException("Could not get related videos", e);
        }
    }

    @Override
    public String getErrorMessage() {
        try {
            return YoutubeParsingHelper.getTextFromObject(this.playerResponse.getObject(PLAYABILITY_STATUS).getObject("errorScreen").getObject("playerErrorMessageRenderer").getObject("reason"));
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        String videoId = this.getId();
        Localization localization = this.getExtractorLocalization();
        ContentCountry contentCountry = this.getExtractorContentCountry();
        PoTokenProvider poTokenProviderInstance = poTokenProvider;
        boolean noPoTokenProviderSet = poTokenProviderInstance == null;
        this.fetchHtml5Client(localization, contentCountry, videoId, poTokenProviderInstance);
        this.setStreamType();
        PoTokenResult androidPoTokenResult = noPoTokenProviderSet ? null : poTokenProviderInstance.getAndroidClientPoToken(videoId);
        this.fetchAndroidClient(localization, contentCountry, videoId, androidPoTokenResult);
        if (fetchIosClient) {
            PoTokenResult iosPoTokenResult = noPoTokenProviderSet ? null : poTokenProviderInstance.getIosClientPoToken(videoId);
            this.fetchIosClient(localization, contentCountry, videoId, iosPoTokenResult);
        }
        byte[] nextBody = JsonWriter.string(((JsonBuilder)((JsonBuilder)((JsonBuilder)YoutubeParsingHelper.prepareDesktopJsonBuilder(localization, contentCountry).value("videoId", videoId)).value("contentCheckOk", true)).value("racyCheckOk", true)).done()).getBytes(StandardCharsets.UTF_8);
        this.nextResponse = YoutubeParsingHelper.getJsonPostResponse(NEXT, nextBody, localization);
    }

    private static void checkPlayabilityStatus(@Nonnull JsonObject playabilityStatus) throws ParsingException {
        String status = playabilityStatus.getString("status");
        if (status == null || status.equalsIgnoreCase("ok")) {
            return;
        }
        String reason = playabilityStatus.getString("reason");
        if (status.equalsIgnoreCase("login_required")) {
            if (reason == null) {
                String message = playabilityStatus.getArray("messages").getString(0);
                if (message != null && message.contains("private")) {
                    throw new PrivateContentException("This video is private");
                }
            } else if (reason.contains("age")) {
                throw new AgeRestrictedContentException("This age-restricted video cannot be watched anonymously");
            }
        }
        if ((status.equalsIgnoreCase("unplayable") || status.equalsIgnoreCase("error")) && reason != null) {
            if (reason.contains("Music Premium")) {
                throw new YoutubeMusicPremiumContentException();
            }
            if (reason.contains("payment")) {
                throw new PaidContentException("This video is a paid video");
            }
            if (reason.contains("members-only")) {
                throw new PaidContentException("This video is only available for members of the channel of this video");
            }
            if (reason.contains("unavailable")) {
                String detailedErrorMessage = YoutubeParsingHelper.getTextFromObject(playabilityStatus.getObject("errorScreen").getObject("playerErrorMessageRenderer").getObject("subreason"));
                if (detailedErrorMessage != null && detailedErrorMessage.contains("country")) {
                    throw new GeographicRestrictionException("This video is not available in client's country.");
                }
                throw new ContentNotAvailableException(Objects.requireNonNullElse(detailedErrorMessage, reason));
            }
            if (reason.contains("age-restricted")) {
                throw new AgeRestrictedContentException("This age-restricted video cannot be watched anonymously");
            }
        }
        throw new ContentNotAvailableException("Got error: \"" + reason + "\"");
    }

    private void fetchHtml5Client(@Nonnull Localization localization, @Nonnull ContentCountry contentCountry, @Nonnull String videoId, @Nullable PoTokenProvider poTokenProviderInstance) throws IOException, ExtractionException {
        this.html5Cpn = YoutubeParsingHelper.generateContentPlaybackNonce();
        JsonObject webPlayerResponse = YoutubeStreamHelper.getWebMetadataPlayerResponse(localization, contentCountry, videoId);
        YoutubeStreamExtractor.throwExceptionIfPlayerResponseNotValid(webPlayerResponse, videoId);
        this.playerResponse = webPlayerResponse;
        this.playerMicroFormatRenderer = this.playerResponse.getObject("microformat").getObject("playerMicroformatRenderer");
        JsonObject playabilityStatus = webPlayerResponse.getObject(PLAYABILITY_STATUS);
        if (YoutubeStreamExtractor.isVideoAgeRestricted(playabilityStatus)) {
            this.fetchHtml5EmbedClient(localization, contentCountry, videoId, poTokenProviderInstance == null ? null : poTokenProviderInstance.getWebEmbedClientPoToken(videoId));
        } else {
            YoutubeStreamExtractor.checkPlayabilityStatus(playabilityStatus);
        }
    }

    private static void throwExceptionIfPlayerResponseNotValid(@Nonnull JsonObject webPlayerResponse, @Nonnull String videoId) throws ExtractionException {
        if (YoutubeStreamExtractor.isPlayerResponseNotValid(webPlayerResponse, videoId)) {
            YoutubeStreamExtractor.checkPlayabilityStatus(webPlayerResponse.getObject(PLAYABILITY_STATUS));
            throw new ExtractionException("WEB player response is not valid");
        }
    }

    private void fetchHtml5EmbedClient(@Nonnull Localization localization, @Nonnull ContentCountry contentCountry, @Nonnull String videoId, @Nullable PoTokenResult webEmbedPoTokenResult) throws IOException, ExtractionException {
        JsonObject webEmbeddedPlayerResponse;
        this.html5Cpn = YoutubeParsingHelper.generateContentPlaybackNonce();
        this.playerResponse = webEmbeddedPlayerResponse = YoutubeStreamHelper.getWebEmbeddedPlayerResponse(localization, contentCountry, videoId, this.html5Cpn, webEmbedPoTokenResult, YoutubeJavaScriptPlayerManager.getSignatureTimestamp(videoId));
        YoutubeStreamExtractor.checkPlayabilityStatus(webEmbeddedPlayerResponse.getObject(PLAYABILITY_STATUS));
        if (YoutubeStreamExtractor.isPlayerResponseNotValid(webEmbeddedPlayerResponse, videoId)) {
            throw new ExtractionException("WEB_EMBEDDED_PLAYER player response is not valid");
        }
        this.html5StreamingData = webEmbeddedPlayerResponse.getObject(STREAMING_DATA);
        this.playerCaptionsTracklistRenderer = webEmbeddedPlayerResponse.getObject(CAPTIONS).getObject(PLAYER_CAPTIONS_TRACKLIST_RENDERER);
        if (webEmbedPoTokenResult != null) {
            this.html5StreamingUrlsPoToken = webEmbedPoTokenResult.streamingDataPoToken;
        }
    }

    private void fetchAndroidClient(@Nonnull Localization localization, @Nonnull ContentCountry contentCountry, @Nonnull String videoId, @Nullable PoTokenResult androidPoTokenResult) {
        try {
            this.androidCpn = YoutubeParsingHelper.generateContentPlaybackNonce();
            JsonObject androidPlayerResponse = androidPoTokenResult == null ? YoutubeStreamHelper.getAndroidReelPlayerResponse(contentCountry, localization, videoId, this.androidCpn) : YoutubeStreamHelper.getAndroidPlayerResponse(contentCountry, localization, videoId, this.androidCpn, androidPoTokenResult);
            if (!YoutubeStreamExtractor.isPlayerResponseNotValid(androidPlayerResponse, videoId)) {
                this.androidStreamingData = androidPlayerResponse.getObject(STREAMING_DATA);
                if (Utils.isNullOrEmpty(this.playerCaptionsTracklistRenderer)) {
                    this.playerCaptionsTracklistRenderer = androidPlayerResponse.getObject(CAPTIONS).getObject(PLAYER_CAPTIONS_TRACKLIST_RENDERER);
                }
                if (androidPoTokenResult != null) {
                    this.androidStreamingUrlsPoToken = androidPoTokenResult.streamingDataPoToken;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void fetchIosClient(@Nonnull Localization localization, @Nonnull ContentCountry contentCountry, @Nonnull String videoId, @Nullable PoTokenResult iosPoTokenResult) {
        try {
            this.iosCpn = YoutubeParsingHelper.generateContentPlaybackNonce();
            JsonObject iosPlayerResponse = YoutubeStreamHelper.getIosPlayerResponse(contentCountry, localization, videoId, this.iosCpn, iosPoTokenResult);
            if (!YoutubeStreamExtractor.isPlayerResponseNotValid(iosPlayerResponse, videoId)) {
                this.iosStreamingData = iosPlayerResponse.getObject(STREAMING_DATA);
                if (Utils.isNullOrEmpty(this.playerCaptionsTracklistRenderer)) {
                    this.playerCaptionsTracklistRenderer = iosPlayerResponse.getObject(CAPTIONS).getObject(PLAYER_CAPTIONS_TRACKLIST_RENDERER);
                }
                if (iosPoTokenResult != null) {
                    this.iosStreamingUrlsPoToken = iosPoTokenResult.streamingDataPoToken;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isPlayerResponseNotValid(@Nonnull JsonObject playerResponse, @Nonnull String videoId) {
        return !videoId.equals(playerResponse.getObject("videoDetails").getString("videoId"));
    }

    private static boolean isVideoAgeRestricted(@Nonnull JsonObject playabilityStatus) {
        return "login_required".equalsIgnoreCase(playabilityStatus.getString("status")) && playabilityStatus.getString("reason", "").contains("age");
    }

    @Nonnull
    private JsonObject getVideoPrimaryInfoRenderer() {
        if (this.videoPrimaryInfoRenderer != null) {
            return this.videoPrimaryInfoRenderer;
        }
        this.videoPrimaryInfoRenderer = this.getVideoInfoRenderer("videoPrimaryInfoRenderer");
        return this.videoPrimaryInfoRenderer;
    }

    @Nonnull
    private JsonObject getVideoSecondaryInfoRenderer() {
        if (this.videoSecondaryInfoRenderer != null) {
            return this.videoSecondaryInfoRenderer;
        }
        this.videoSecondaryInfoRenderer = this.getVideoInfoRenderer("videoSecondaryInfoRenderer");
        return this.videoSecondaryInfoRenderer;
    }

    @Nonnull
    private JsonObject getVideoInfoRenderer(@Nonnull String videoRendererName) {
        return this.nextResponse.getObject("contents").getObject("twoColumnWatchNextResults").getObject("results").getObject("results").getArray("contents").stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).filter(content -> content.has(videoRendererName)).map(content -> content.getObject(videoRendererName)).findFirst().orElse(new JsonObject());
    }

    @Nonnull
    private <T extends org.watermedia.shaded.schabi.newpipe.extractor.stream.Stream> List<T> getItags(String streamingDataKey, ItagItem.ItagType itagTypeWanted, Function<ItagInfo, T> streamBuilderHelper, String streamTypeExceptionMessage) throws ParsingException {
        try {
            String videoId = this.getId();
            ArrayList streamList = new ArrayList();
            Stream.of(new Pair<JsonObject, Pair<String, String>>(this.html5StreamingData, new Pair<String, String>(this.html5Cpn, this.html5StreamingUrlsPoToken)), new Pair<JsonObject, Pair<String, String>>(this.androidStreamingData, new Pair<String, String>(this.androidCpn, this.androidStreamingUrlsPoToken)), new Pair<JsonObject, Pair<String, String>>(this.iosStreamingData, new Pair<String, String>(this.iosCpn, this.iosStreamingUrlsPoToken))).flatMap(pair -> this.getStreamsFromStreamingDataKey(videoId, (JsonObject)pair.getFirst(), streamingDataKey, itagTypeWanted, (String)((Pair)pair.getSecond()).getFirst(), (String)((Pair)pair.getSecond()).getSecond())).map(streamBuilderHelper).forEachOrdered(stream -> {
                if (!org.watermedia.shaded.schabi.newpipe.extractor.stream.Stream.containSimilarStream(stream, streamList)) {
                    streamList.add(stream);
                }
            });
            return streamList;
        }
        catch (Exception e) {
            throw new ParsingException("Could not get " + streamTypeExceptionMessage + " streams", e);
        }
    }

    @Nonnull
    private Function<ItagInfo, AudioStream> getAudioStreamBuilderHelper() {
        return itagInfo -> {
            ItagItem itagItem = itagInfo.getItagItem();
            AudioStream.Builder builder = new AudioStream.Builder().setId(String.valueOf(itagItem.id)).setContent(itagInfo.getContent(), itagInfo.getIsUrl()).setMediaFormat(itagItem.getMediaFormat()).setAverageBitrate(itagItem.getAverageBitrate()).setAudioTrackId(itagItem.getAudioTrackId()).setAudioTrackName(itagItem.getAudioTrackName()).setAudioLocale(itagItem.getAudioLocale()).setAudioTrackType(itagItem.getAudioTrackType()).setItagItem(itagItem);
            if (this.streamType == StreamType.LIVE_STREAM || this.streamType == StreamType.POST_LIVE_STREAM || !itagInfo.getIsUrl()) {
                builder.setDeliveryMethod(DeliveryMethod.DASH);
            }
            return builder.build();
        };
    }

    @Nonnull
    private Function<ItagInfo, VideoStream> getVideoStreamBuilderHelper(boolean areStreamsVideoOnly) {
        return itagInfo -> {
            ItagItem itagItem = itagInfo.getItagItem();
            VideoStream.Builder builder = new VideoStream.Builder().setId(String.valueOf(itagItem.id)).setContent(itagInfo.getContent(), itagInfo.getIsUrl()).setMediaFormat(itagItem.getMediaFormat()).setIsVideoOnly(areStreamsVideoOnly).setItagItem(itagItem);
            String resolutionString = itagItem.getResolutionString();
            builder.setResolution(resolutionString != null ? resolutionString : "");
            if (this.streamType != StreamType.VIDEO_STREAM || !itagInfo.getIsUrl()) {
                builder.setDeliveryMethod(DeliveryMethod.DASH);
            }
            return builder.build();
        };
    }

    @Nonnull
    private Stream<ItagInfo> getStreamsFromStreamingDataKey(String videoId, JsonObject streamingData, String streamingDataKey, @Nonnull ItagItem.ItagType itagTypeWanted, @Nonnull String contentPlaybackNonce, @Nullable String poToken) {
        if (streamingData == null || !streamingData.has(streamingDataKey)) {
            return Stream.empty();
        }
        return streamingData.getArray(streamingDataKey).stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(formatData -> {
            try {
                ItagItem itagItem = ItagItem.getItag(formatData.getInt("itag"));
                if (itagItem.itagType == itagTypeWanted) {
                    return this.buildAndAddItagInfoToList(videoId, (JsonObject)formatData, itagItem, itagItem.itagType, contentPlaybackNonce, poToken);
                }
            }
            catch (ExtractionException extractionException) {
                // empty catch block
            }
            return null;
        }).filter(Objects::nonNull);
    }

    private ItagInfo buildAndAddItagInfoToList(@Nonnull String videoId, @Nonnull JsonObject formatData, @Nonnull ItagItem itagItem, @Nonnull ItagItem.ItagType itagType, @Nonnull String contentPlaybackNonce, @Nullable String poToken) throws ExtractionException {
        Object streamUrl;
        if (formatData.has("url")) {
            streamUrl = formatData.getString("url");
        } else {
            String cipherString = formatData.getString(CIPHER, formatData.getString(SIGNATURE_CIPHER));
            if (Utils.isNullOrEmpty(cipherString)) {
                return null;
            }
            Map<String, String> cipher = Parser.compatParseMap(cipherString);
            String signature = YoutubeJavaScriptPlayerManager.deobfuscateSignature(videoId, cipher.getOrDefault("s", ""));
            streamUrl = cipher.get("url") + "&" + cipher.get("sp") + "=" + signature;
        }
        streamUrl = YoutubeJavaScriptPlayerManager.getUrlWithThrottlingParameterDeobfuscated(videoId, (String)streamUrl);
        streamUrl = (String)streamUrl + "&cpn=" + contentPlaybackNonce;
        if (poToken != null) {
            streamUrl = (String)streamUrl + "&pot=" + poToken;
        }
        JsonObject initRange = formatData.getObject("initRange");
        JsonObject indexRange = formatData.getObject("indexRange");
        String mimeType = formatData.getString("mimeType", "");
        String codec = mimeType.contains("codecs") ? mimeType.split("\"")[1] : "";
        itagItem.setBitrate(formatData.getInt("bitrate"));
        itagItem.setWidth(formatData.getInt("width"));
        itagItem.setHeight(formatData.getInt("height"));
        itagItem.setInitStart(Integer.parseInt(initRange.getString("start", "-1")));
        itagItem.setInitEnd(Integer.parseInt(initRange.getString("end", "-1")));
        itagItem.setIndexStart(Integer.parseInt(indexRange.getString("start", "-1")));
        itagItem.setIndexEnd(Integer.parseInt(indexRange.getString("end", "-1")));
        itagItem.setQuality(formatData.getString("quality"));
        itagItem.setCodec(codec);
        if (this.streamType == StreamType.LIVE_STREAM || this.streamType == StreamType.POST_LIVE_STREAM) {
            itagItem.setTargetDurationSec(formatData.getInt("targetDurationSec"));
        }
        if (itagType == ItagItem.ItagType.VIDEO || itagType == ItagItem.ItagType.VIDEO_ONLY) {
            itagItem.setFps(formatData.getInt("fps"));
        } else if (itagType == ItagItem.ItagType.AUDIO) {
            itagItem.setSampleRate(Integer.parseInt(formatData.getString("audioSampleRate")));
            itagItem.setAudioChannels(formatData.getInt("audioChannels", 2));
            String audioTrackId = formatData.getObject("audioTrack").getString("id");
            if (!Utils.isNullOrEmpty(audioTrackId)) {
                itagItem.setAudioTrackId(audioTrackId);
                int audioTrackIdLastLocaleCharacter = audioTrackId.indexOf(".");
                if (audioTrackIdLastLocaleCharacter != -1) {
                    LocaleCompat.forLanguageTag(audioTrackId.substring(0, audioTrackIdLastLocaleCharacter)).ifPresent(itagItem::setAudioLocale);
                }
                itagItem.setAudioTrackType(YoutubeParsingHelper.extractAudioTrackType((String)streamUrl));
            }
            itagItem.setAudioTrackName(formatData.getObject("audioTrack").getString("displayName"));
        }
        itagItem.setContentLength(Long.parseLong(formatData.getString("contentLength", String.valueOf(-1L))));
        itagItem.setApproxDurationMs(Long.parseLong(formatData.getString("approxDurationMs", String.valueOf(-1L))));
        ItagInfo itagInfo = new ItagInfo((String)streamUrl, itagItem);
        if (this.streamType == StreamType.VIDEO_STREAM) {
            itagInfo.setIsUrl(!formatData.getString("type", "").equalsIgnoreCase("FORMAT_STREAM_TYPE_OTF"));
        } else {
            itagInfo.setIsUrl(this.streamType != StreamType.POST_LIVE_STREAM);
        }
        return itagInfo;
    }

    @Override
    @Nonnull
    public List<Frameset> getFrames() throws ExtractionException {
        try {
            JsonObject storyboards = this.playerResponse.getObject("storyboards");
            JsonObject storyboardsRenderer = storyboards.getObject(storyboards.has("playerLiveStoryboardSpecRenderer") ? "playerLiveStoryboardSpecRenderer" : "playerStoryboardSpecRenderer");
            if (storyboardsRenderer == null) {
                return Collections.emptyList();
            }
            String storyboardsRendererSpec = storyboardsRenderer.getString("spec");
            if (storyboardsRendererSpec == null) {
                return Collections.emptyList();
            }
            String[] spec = storyboardsRendererSpec.split("\\|");
            String url = spec[0];
            ArrayList<Frameset> result = new ArrayList<Frameset>(spec.length - 1);
            for (int i = 1; i < spec.length; ++i) {
                List<CallSite> urls;
                String[] parts = spec[i].split("#");
                if (parts.length != 8 || Integer.parseInt(parts[5]) == 0) continue;
                int totalCount = Integer.parseInt(parts[2]);
                int framesPerPageX = Integer.parseInt(parts[3]);
                int framesPerPageY = Integer.parseInt(parts[4]);
                String baseUrl = url.replace("$L", String.valueOf(i - 1)).replace("$N", parts[6]) + "&sigh=" + parts[7];
                if (baseUrl.contains("$M")) {
                    int totalPages = (int)Math.ceil((double)totalCount / (double)(framesPerPageX * framesPerPageY));
                    urls = new ArrayList<CallSite>(totalPages);
                    for (int j = 0; j < totalPages; ++j) {
                        urls.add((CallSite)((Object)baseUrl.replace("$M", String.valueOf(j))));
                    }
                } else {
                    urls = Collections.singletonList(baseUrl);
                }
                result.add(new Frameset(urls, Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), totalCount, Integer.parseInt(parts[5]), framesPerPageX, framesPerPageY));
            }
            return result;
        }
        catch (Exception e) {
            throw new ExtractionException("Could not get frames", e);
        }
    }

    @Override
    @Nonnull
    public StreamExtractor.Privacy getPrivacy() {
        return this.playerMicroFormatRenderer.getBoolean("isUnlisted") ? StreamExtractor.Privacy.UNLISTED : StreamExtractor.Privacy.PUBLIC;
    }

    @Override
    @Nonnull
    public String getCategory() {
        return this.playerMicroFormatRenderer.getString("category", "");
    }

    @Override
    @Nonnull
    public String getLicence() throws ParsingException {
        JsonObject metadataRowRenderer = this.getVideoSecondaryInfoRenderer().getObject("metadataRowContainer").getObject("metadataRowContainerRenderer").getArray("rows").getObject(0).getObject("metadataRowRenderer");
        JsonArray contents = metadataRowRenderer.getArray("contents");
        String license = YoutubeParsingHelper.getTextFromObject(contents.getObject(0));
        return license != null && "Licence".equals(YoutubeParsingHelper.getTextFromObject(metadataRowRenderer.getObject("title"))) ? license : "YouTube licence";
    }

    @Override
    public Locale getLanguageInfo() {
        return null;
    }

    @Override
    @Nonnull
    public List<String> getTags() {
        return JsonUtils.getStringListFromJsonArray(this.playerResponse.getObject("videoDetails").getArray("keywords"));
    }

    @Override
    @Nonnull
    public List<StreamSegment> getStreamSegments() throws ParsingException {
        if (!this.nextResponse.has("engagementPanels")) {
            return Collections.emptyList();
        }
        JsonArray segmentsArray = this.nextResponse.getArray("engagementPanels").stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).filter(panel -> "engagement-panel-macro-markers-description-chapters".equals(panel.getObject("engagementPanelSectionListRenderer").getString("panelIdentifier"))).map(panel -> panel.getObject("engagementPanelSectionListRenderer").getObject("content").getObject("macroMarkersListRenderer").getArray("contents")).findFirst().orElse(null);
        if (segmentsArray == null) {
            return Collections.emptyList();
        }
        long duration = this.getLength();
        ArrayList<StreamSegment> segments = new ArrayList<StreamSegment>();
        for (JsonObject segmentJson : segmentsArray.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(object -> object.getObject("macroMarkersListItemRenderer")).collect(Collectors.toList())) {
            JsonArray previewsArray;
            int startTimeSeconds = segmentJson.getObject("onTap").getObject("watchEndpoint").getInt("startTimeSeconds", -1);
            if (startTimeSeconds == -1) {
                throw new ParsingException("Could not get stream segment start time.");
            }
            if ((long)startTimeSeconds > duration) break;
            String title = YoutubeParsingHelper.getTextFromObject(segmentJson.getObject("title"));
            if (Utils.isNullOrEmpty(title)) {
                throw new ParsingException("Could not get stream segment title.");
            }
            StreamSegment segment = new StreamSegment(title, startTimeSeconds);
            segment.setUrl(this.getUrl() + "?t=" + startTimeSeconds);
            if (segmentJson.has("thumbnail") && !(previewsArray = segmentJson.getObject("thumbnail").getArray("thumbnails")).isEmpty()) {
                String url = previewsArray.getObject(previewsArray.size() - 1).getString("url");
                segment.setPreviewUrl(YoutubeParsingHelper.fixThumbnailUrl(url));
            }
            segments.add(segment);
        }
        return segments;
    }

    @Override
    @Nonnull
    public List<MetaInfo> getMetaInfo() throws ParsingException {
        return YoutubeMetaInfoHelper.getMetaInfo(this.nextResponse.getObject("contents").getObject("twoColumnWatchNextResults").getObject("results").getObject("results").getArray("contents"));
    }

    public static void setPoTokenProvider(@Nullable PoTokenProvider poTokenProvider) {
        YoutubeStreamExtractor.poTokenProvider = poTokenProvider;
    }

    public static void setFetchIosClient(boolean fetchIosClient) {
        YoutubeStreamExtractor.fetchIosClient = fetchIosClient;
    }
}

