/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors;

import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeBaseShowInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

class YoutubeShowRendererInfoItemExtractor
extends YoutubeBaseShowInfoItemExtractor {
    @Nonnull
    private final JsonObject shortBylineText;
    @Nonnull
    private final JsonObject longBylineText;

    YoutubeShowRendererInfoItemExtractor(@Nonnull JsonObject showRenderer) {
        super(showRenderer);
        this.shortBylineText = showRenderer.getObject("shortBylineText");
        this.longBylineText = showRenderer.getObject("longBylineText");
    }

    @Override
    public String getUploaderName() throws ParsingException {
        String name = YoutubeParsingHelper.getTextFromObject(this.longBylineText);
        if (Utils.isNullOrEmpty(name) && Utils.isNullOrEmpty(name = YoutubeParsingHelper.getTextFromObject(this.shortBylineText))) {
            throw new ParsingException("Could not get uploader name");
        }
        return name;
    }

    @Override
    public String getUploaderUrl() throws ParsingException {
        String uploaderUrl = YoutubeParsingHelper.getUrlFromObject(this.longBylineText);
        if (uploaderUrl == null && (uploaderUrl = YoutubeParsingHelper.getUrlFromObject(this.shortBylineText)) == null) {
            throw new ParsingException("Could not get uploader URL");
        }
        return uploaderUrl;
    }

    @Override
    public boolean isUploaderVerified() throws ParsingException {
        return false;
    }
}

