/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors;

import java.io.IOException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.jsoup.Jsoup;
import org.watermedia.shaded.jsoup.nodes.Document;
import org.watermedia.shaded.jsoup.nodes.Element;
import org.watermedia.shaded.jsoup.select.Elements;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Response;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ContentNotAvailableException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.feed.FeedExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeFeedInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemsCollector;

public class YoutubeFeedExtractor
extends FeedExtractor {
    private static final String WEBSITE_CHANNEL_BASE_URL = "https://www.youtube.com/channel/";
    private Document document;

    public YoutubeFeedExtractor(StreamingService service, ListLinkHandler linkHandler) {
        super(service, linkHandler);
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        String channelIdOrUser = this.getLinkHandler().getId();
        String feedUrl = YoutubeParsingHelper.getFeedUrlFrom(channelIdOrUser);
        Response response = downloader.get(feedUrl);
        if (response.responseCode() == 404) {
            throw new ContentNotAvailableException("Could not get feed: 404 - not found");
        }
        this.document = Jsoup.parse(response.responseBody());
    }

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage<StreamInfoItem> getInitialPage() {
        Elements entries = this.document.select("feed > entry");
        StreamInfoItemsCollector collector = new StreamInfoItemsCollector(this.getServiceId());
        for (Element entryElement : entries) {
            collector.commit(new YoutubeFeedInfoItemExtractor(entryElement));
        }
        return new ListExtractor.InfoItemsPage<StreamInfoItem>(collector, null);
    }

    @Override
    @Nonnull
    public String getId() {
        return this.getUrl().replace(WEBSITE_CHANNEL_BASE_URL, "");
    }

    @Override
    @Nonnull
    public String getUrl() {
        String authorUriElementText;
        Element authorUriElement = this.document.select("feed > author > uri").first();
        if (authorUriElement != null && !(authorUriElementText = authorUriElement.text()).equals("")) {
            return authorUriElementText;
        }
        Element linkElement = this.document.select("feed > link[rel*=alternate]").first();
        if (linkElement != null) {
            return linkElement.attr("href");
        }
        return "";
    }

    @Override
    @Nonnull
    public String getName() {
        Element nameElement = this.document.select("feed > author > name").first();
        if (nameElement == null) {
            return "";
        }
        return nameElement.text();
    }

    @Override
    public ListExtractor.InfoItemsPage<StreamInfoItem> getPage(Page page) {
        return ListExtractor.InfoItemsPage.emptyPage();
    }
}

