/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonBuilder;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonWriter;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.InfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.MultiInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.tabs.ChannelTabExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.TimeAgoParser;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeChannelHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeBaseShowInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeMixOrPlaylistLockupInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubePlaylistInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeReelInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeShortsLockupInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeStreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeStreamInfoItemLockupExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubeChannelTabLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class YoutubeChannelTabExtractor
extends ChannelTabExtractor {
    @Nullable
    protected YoutubeChannelHelper.ChannelHeader channelHeader;
    private JsonObject jsonResponse;
    private String channelId;

    public YoutubeChannelTabExtractor(StreamingService service, ListLinkHandler linkHandler) {
        super(service, linkHandler);
    }

    @Nonnull
    private String getChannelTabsParameters() throws ParsingException {
        String name;
        switch (name = this.getName()) {
            case "videos": {
                return "EgZ2aWRlb3PyBgQKAjoA";
            }
            case "shorts": {
                return "EgZzaG9ydHPyBgUKA5oBAA%3D%3D";
            }
            case "livestreams": {
                return "EgdzdHJlYW1z8gYECgJ6AA%3D%3D";
            }
            case "albums": {
                return "EghyZWxlYXNlc_IGBQoDsgEA";
            }
            case "playlists": {
                return "EglwbGF5bGlzdHPyBgQKAkIA";
            }
        }
        throw new ParsingException("Unsupported channel tab: " + name);
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        String channelIdFromId = YoutubeChannelHelper.resolveChannelId(super.getId());
        String params = this.getChannelTabsParameters();
        YoutubeChannelHelper.ChannelResponseData data = YoutubeChannelHelper.getChannelResponse(channelIdFromId, params, this.getExtractorLocalization(), this.getExtractorContentCountry());
        this.jsonResponse = data.jsonResponse;
        this.channelHeader = YoutubeChannelHelper.getChannelHeader(this.jsonResponse);
        this.channelId = data.channelId;
    }

    @Override
    @Nonnull
    public String getUrl() throws ParsingException {
        try {
            return YoutubeChannelTabLinkHandlerFactory.getInstance().getUrl("channel/" + this.getId(), List.of(this.getName()), "");
        }
        catch (ParsingException e) {
            return super.getUrl();
        }
    }

    @Override
    @Nonnull
    public String getId() throws ParsingException {
        return YoutubeChannelHelper.getChannelId(this.channelHeader, this.jsonResponse, this.channelId);
    }

    protected String getChannelName() throws ParsingException {
        return YoutubeChannelHelper.getChannelName(this.channelHeader, YoutubeChannelHelper.getChannelAgeGateRenderer(this.jsonResponse), this.jsonResponse);
    }

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage<InfoItem> getInitialPage() throws IOException, ExtractionException {
        JsonObject tabContent;
        MultiInfoItemsCollector collector = new MultiInfoItemsCollector(this.getServiceId());
        JsonArray items = new JsonArray();
        Optional<JsonObject> tab = this.getTabData();
        if (tab.isPresent() && (items = (tabContent = tab.get().getObject("content")).getObject("sectionListRenderer").getArray("contents").getObject(0).getObject("itemSectionRenderer").getArray("contents").getObject(0).getObject("gridRenderer").getArray("items")).isEmpty() && (items = tabContent.getObject("richGridRenderer").getArray("contents")).isEmpty()) {
            items = tabContent.getObject("sectionListRenderer").getArray("contents");
        }
        VerifiedStatus verifiedStatus = this.channelHeader == null ? VerifiedStatus.UNKNOWN : (YoutubeChannelHelper.isChannelVerified(this.channelHeader) ? VerifiedStatus.VERIFIED : VerifiedStatus.UNVERIFIED);
        String channelName = this.getChannelName();
        String channelUrl = this.getUrl();
        JsonObject continuation = this.collectItemsFrom(collector, items, verifiedStatus, channelName, channelUrl).orElse(null);
        Page nextPage = this.getNextPageFrom(continuation, List.of(channelName, channelUrl, verifiedStatus.toString()));
        return new ListExtractor.InfoItemsPage<InfoItem>(collector, nextPage);
    }

    @Override
    public ListExtractor.InfoItemsPage<InfoItem> getPage(Page page) throws IOException, ExtractionException {
        if (page == null || Utils.isNullOrEmpty(page.getUrl())) {
            throw new IllegalArgumentException("Page doesn't contain an URL");
        }
        List<String> channelIds = page.getIds();
        MultiInfoItemsCollector collector = new MultiInfoItemsCollector(this.getServiceId());
        JsonObject ajaxJson = YoutubeParsingHelper.getJsonPostResponse("browse", page.getBody(), this.getExtractorLocalization());
        JsonObject sectionListContinuation = ajaxJson.getArray("onResponseReceivedActions").stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).filter(jsonObject -> jsonObject.has("appendContinuationItemsAction")).map(jsonObject -> jsonObject.getObject("appendContinuationItemsAction")).findFirst().orElse(new JsonObject());
        JsonObject continuation = this.collectItemsFrom(collector, sectionListContinuation.getArray("continuationItems"), channelIds).orElse(null);
        return new ListExtractor.InfoItemsPage<InfoItem>(collector, this.getNextPageFrom(continuation, channelIds));
    }

    Optional<JsonObject> getTabData() {
        String urlSuffix = YoutubeChannelTabLinkHandlerFactory.getUrlSuffix(this.getName());
        return this.jsonResponse.getObject("contents").getObject("twoColumnBrowseResultsRenderer").getArray("tabs").stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).filter(tab -> tab.has("tabRenderer")).map(tab -> tab.getObject("tabRenderer")).filter(tabRenderer -> tabRenderer.getObject("endpoint").getObject("org.watermedia.shaded.commandMetadata").getObject("webCommandMetadata").getString("url", "").endsWith(urlSuffix)).findFirst().filter(tabRenderer -> {
            JsonArray tabContents = tabRenderer.getObject("content").getObject("sectionListRenderer").getArray("contents").getObject(0).getObject("itemSectionRenderer").getArray("contents");
            return tabContents.size() != 1 || !tabContents.getObject(0).has("messageRenderer");
        });
    }

    private Optional<JsonObject> collectItemsFrom(@Nonnull MultiInfoItemsCollector collector, @Nonnull JsonArray items, @Nonnull List<String> channelIds) {
        VerifiedStatus verifiedStatus;
        String channelUrl;
        String channelName;
        if (channelIds.size() >= 3) {
            channelName = channelIds.get(0);
            channelUrl = channelIds.get(1);
            try {
                verifiedStatus = VerifiedStatus.valueOf(channelIds.get(2));
            }
            catch (IllegalArgumentException e) {
                verifiedStatus = VerifiedStatus.UNKNOWN;
            }
        } else {
            channelName = null;
            channelUrl = null;
            verifiedStatus = VerifiedStatus.UNKNOWN;
        }
        return this.collectItemsFrom(collector, items, verifiedStatus, channelName, channelUrl);
    }

    private Optional<JsonObject> collectItemsFrom(@Nonnull MultiInfoItemsCollector collector, @Nonnull JsonArray items, @Nonnull VerifiedStatus verifiedStatus, @Nullable String channelName, @Nullable String channelUrl) {
        return items.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(item -> this.collectItem(collector, (JsonObject)item, verifiedStatus, channelName, channelUrl)).reduce(Optional.empty(), (c1, c2) -> c1.or(() -> c2));
    }

    private Optional<JsonObject> collectItem(@Nonnull MultiInfoItemsCollector collector, @Nonnull JsonObject item, @Nonnull VerifiedStatus channelVerifiedStatus, @Nullable String channelName, @Nullable String channelUrl) {
        TimeAgoParser timeAgoParser = this.getTimeAgoParser();
        if (item.has("richItemRenderer")) {
            JsonObject richItem = item.getObject("richItemRenderer").getObject("content");
            if (richItem.has("videoRenderer")) {
                this.commitVideo(collector, timeAgoParser, richItem.getObject("videoRenderer"), channelVerifiedStatus, channelName, channelUrl);
            } else if (richItem.has("reelItemRenderer")) {
                YoutubeChannelTabExtractor.commitReel(collector, richItem.getObject("reelItemRenderer"), channelVerifiedStatus, channelName, channelUrl);
            } else if (richItem.has("shortsLockupViewModel")) {
                YoutubeChannelTabExtractor.commitShortsLockup(collector, richItem.getObject("shortsLockupViewModel"), channelVerifiedStatus, channelName, channelUrl);
            } else if (richItem.has("playlistRenderer")) {
                this.commitPlaylist(collector, richItem.getObject("playlistRenderer"), channelVerifiedStatus, channelName, channelUrl);
            }
        } else if (item.has("gridVideoRenderer")) {
            this.commitVideo(collector, timeAgoParser, item.getObject("gridVideoRenderer"), channelVerifiedStatus, channelName, channelUrl);
        } else if (item.has("gridPlaylistRenderer")) {
            this.commitPlaylist(collector, item.getObject("gridPlaylistRenderer"), channelVerifiedStatus, channelName, channelUrl);
        } else if (item.has("gridShowRenderer")) {
            collector.commit(new YoutubeGridShowRendererChannelInfoItemExtractor(item.getObject("gridShowRenderer"), channelVerifiedStatus, channelName, channelUrl));
        } else {
            if (item.has("shelfRenderer")) {
                return this.collectItem(collector, item.getObject("shelfRenderer").getObject("content"), channelVerifiedStatus, channelName, channelUrl);
            }
            if (item.has("itemSectionRenderer")) {
                return this.collectItemsFrom(collector, item.getObject("itemSectionRenderer").getArray("contents"), channelVerifiedStatus, channelName, channelUrl);
            }
            if (item.has("horizontalListRenderer")) {
                return this.collectItemsFrom(collector, item.getObject("horizontalListRenderer").getArray("items"), channelVerifiedStatus, channelName, channelUrl);
            }
            if (item.has("expandedShelfContentsRenderer")) {
                return this.collectItemsFrom(collector, item.getObject("expandedShelfContentsRenderer").getArray("items"), channelVerifiedStatus, channelName, channelUrl);
            }
            if (item.has("lockupViewModel")) {
                JsonObject lockupViewModel = item.getObject("lockupViewModel");
                String contentType = lockupViewModel.getString("contentType");
                if ("LOCKUP_CONTENT_TYPE_PLAYLIST".equals(contentType) || "LOCKUP_CONTENT_TYPE_PODCAST".equals(contentType)) {
                    this.commitPlaylistLockup(collector, lockupViewModel, channelVerifiedStatus, channelName, channelUrl);
                } else if ("LOCKUP_CONTENT_TYPE_VIDEO".equals(contentType)) {
                    YoutubeChannelTabExtractor.commitVideoLockup(collector, timeAgoParser, lockupViewModel, channelVerifiedStatus, channelName, channelUrl);
                }
            } else if (item.has("continuationItemRenderer")) {
                return Optional.ofNullable(item.getObject("continuationItemRenderer"));
            }
        }
        return Optional.empty();
    }

    private static void commitReel(@Nonnull MultiInfoItemsCollector collector, @Nonnull JsonObject reelItemRenderer, final @Nonnull VerifiedStatus channelVerifiedStatus, final @Nullable String channelName, final @Nullable String channelUrl) {
        collector.commit(new YoutubeReelInfoItemExtractor(reelItemRenderer){

            @Override
            public String getUploaderName() throws ParsingException {
                return Utils.isNullOrEmpty(channelName) ? super.getUploaderName() : channelName;
            }

            @Override
            public String getUploaderUrl() throws ParsingException {
                return Utils.isNullOrEmpty(channelUrl) ? super.getUploaderName() : channelUrl;
            }

            @Override
            public boolean isUploaderVerified() {
                return channelVerifiedStatus == VerifiedStatus.VERIFIED;
            }
        });
    }

    private static void commitShortsLockup(@Nonnull MultiInfoItemsCollector collector, @Nonnull JsonObject shortsLockupViewModel, final @Nonnull VerifiedStatus channelVerifiedStatus, final @Nullable String channelName, final @Nullable String channelUrl) {
        collector.commit(new YoutubeShortsLockupInfoItemExtractor(shortsLockupViewModel){

            @Override
            public String getUploaderName() throws ParsingException {
                return Utils.isNullOrEmpty(channelName) ? super.getUploaderName() : channelName;
            }

            @Override
            public String getUploaderUrl() throws ParsingException {
                return Utils.isNullOrEmpty(channelUrl) ? super.getUploaderName() : channelUrl;
            }

            @Override
            public boolean isUploaderVerified() {
                return channelVerifiedStatus == VerifiedStatus.VERIFIED;
            }
        });
    }

    private static void commitVideoLockup(@Nonnull MultiInfoItemsCollector collector, @Nonnull TimeAgoParser timeAgoParser, @Nonnull JsonObject lockupViewModel, final @Nonnull VerifiedStatus channelVerifiedStatus, final @Nullable String channelName, final @Nullable String channelUrl) {
        collector.commit(new YoutubeStreamInfoItemLockupExtractor(lockupViewModel, timeAgoParser){

            @Override
            public String getUploaderName() throws ParsingException {
                return Utils.isNullOrEmpty(channelName) ? super.getUploaderName() : channelName;
            }

            @Override
            public String getUploaderUrl() throws ParsingException {
                return Utils.isNullOrEmpty(channelUrl) ? super.getUploaderName() : channelUrl;
            }

            @Override
            public boolean isUploaderVerified() {
                return channelVerifiedStatus == VerifiedStatus.VERIFIED;
            }
        });
    }

    private void commitPlaylistLockup(@Nonnull MultiInfoItemsCollector collector, @Nonnull JsonObject playlistLockupViewModel, final @Nonnull VerifiedStatus channelVerifiedStatus, final @Nullable String channelName, final @Nullable String channelUrl) {
        collector.commit(new YoutubeMixOrPlaylistLockupInfoItemExtractor(playlistLockupViewModel){

            @Override
            public String getUploaderName() throws ParsingException {
                return Utils.isNullOrEmpty(channelName) ? super.getUploaderName() : channelName;
            }

            @Override
            public String getUploaderUrl() throws ParsingException {
                return Utils.isNullOrEmpty(channelUrl) ? super.getUploaderName() : channelUrl;
            }

            @Override
            public boolean isUploaderVerified() throws ParsingException {
                switch (channelVerifiedStatus) {
                    case VERIFIED: {
                        return true;
                    }
                    case UNVERIFIED: {
                        return false;
                    }
                }
                return super.isUploaderVerified();
            }
        });
    }

    private void commitVideo(@Nonnull MultiInfoItemsCollector collector, @Nonnull TimeAgoParser timeAgoParser, @Nonnull JsonObject jsonObject, final @Nonnull VerifiedStatus channelVerifiedStatus, final @Nullable String channelName, final @Nullable String channelUrl) {
        collector.commit(new YoutubeStreamInfoItemExtractor(jsonObject, timeAgoParser){

            @Override
            public String getUploaderName() throws ParsingException {
                return Utils.isNullOrEmpty(channelName) ? super.getUploaderName() : channelName;
            }

            @Override
            public String getUploaderUrl() throws ParsingException {
                return Utils.isNullOrEmpty(channelUrl) ? super.getUploaderName() : channelUrl;
            }

            @Override
            public boolean isUploaderVerified() throws ParsingException {
                switch (channelVerifiedStatus) {
                    case VERIFIED: {
                        return true;
                    }
                    case UNVERIFIED: {
                        return false;
                    }
                }
                return super.isUploaderVerified();
            }
        });
    }

    private void commitPlaylist(@Nonnull MultiInfoItemsCollector collector, @Nonnull JsonObject jsonObject, final @Nonnull VerifiedStatus channelVerifiedStatus, final @Nullable String channelName, final @Nullable String channelUrl) {
        collector.commit(new YoutubePlaylistInfoItemExtractor(jsonObject){

            @Override
            public String getUploaderName() throws ParsingException {
                return Utils.isNullOrEmpty(channelName) ? super.getUploaderName() : channelName;
            }

            @Override
            public String getUploaderUrl() throws ParsingException {
                return Utils.isNullOrEmpty(channelUrl) ? super.getUploaderName() : channelUrl;
            }

            @Override
            public boolean isUploaderVerified() throws ParsingException {
                switch (channelVerifiedStatus) {
                    case VERIFIED: {
                        return true;
                    }
                    case UNVERIFIED: {
                        return false;
                    }
                }
                return super.isUploaderVerified();
            }
        });
    }

    @Nullable
    private Page getNextPageFrom(JsonObject continuations, List<String> channelIds) throws IOException, ExtractionException {
        if (Utils.isNullOrEmpty(continuations)) {
            return null;
        }
        JsonObject continuationEndpoint = continuations.getObject("continuationEndpoint");
        String continuation = continuationEndpoint.getObject("continuationCommand").getString("token");
        byte[] body = JsonWriter.string(((JsonBuilder)YoutubeParsingHelper.prepareDesktopJsonBuilder(this.getExtractorLocalization(), this.getExtractorContentCountry()).value("continuation", continuation)).done()).getBytes(StandardCharsets.UTF_8);
        return new Page("https://www.youtube.com/youtubei/v1/browse?prettyPrint=false", null, channelIds, null, body);
    }

    private static final class YoutubeGridShowRendererChannelInfoItemExtractor
    extends YoutubeBaseShowInfoItemExtractor {
        @Nonnull
        private final VerifiedStatus verifiedStatus;
        @Nullable
        private final String channelName;
        @Nullable
        private final String channelUrl;

        private YoutubeGridShowRendererChannelInfoItemExtractor(@Nonnull JsonObject gridShowRenderer, @Nonnull VerifiedStatus verifiedStatus, @Nullable String channelName, @Nullable String channelUrl) {
            super(gridShowRenderer);
            this.verifiedStatus = verifiedStatus;
            this.channelName = channelName;
            this.channelUrl = channelUrl;
        }

        @Override
        public String getUploaderName() {
            return this.channelName;
        }

        @Override
        public String getUploaderUrl() {
            return this.channelUrl;
        }

        @Override
        public boolean isUploaderVerified() throws ParsingException {
            switch (this.verifiedStatus) {
                case VERIFIED: {
                    return true;
                }
                case UNVERIFIED: {
                    return false;
                }
            }
            throw new ParsingException("Could not get uploader verification status");
        }
    }

    private static enum VerifiedStatus {
        VERIFIED,
        UNVERIFIED,
        UNKNOWN;

    }

    public static final class VideosTabExtractor
    extends YoutubeChannelTabExtractor {
        private final JsonObject tabRenderer;
        private final String channelId;
        private final String channelName;
        private final String channelUrl;

        VideosTabExtractor(StreamingService service, ListLinkHandler linkHandler, JsonObject tabRenderer, @Nullable YoutubeChannelHelper.ChannelHeader channelHeader, String channelName, String channelId, String channelUrl) {
            super(service, linkHandler);
            this.channelHeader = channelHeader;
            this.tabRenderer = tabRenderer;
            this.channelId = channelId;
            this.channelName = channelName;
            this.channelUrl = channelUrl;
        }

        @Override
        public void onFetchPage(@Nonnull Downloader downloader) {
        }

        @Override
        @Nonnull
        public String getId() throws ParsingException {
            return this.channelId;
        }

        @Override
        @Nonnull
        public String getUrl() throws ParsingException {
            return this.channelUrl;
        }

        @Override
        protected String getChannelName() {
            return this.channelName;
        }

        @Override
        Optional<JsonObject> getTabData() {
            return Optional.of(this.tabRenderer);
        }
    }
}

