/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors;

import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

abstract class YoutubeBaseShowInfoItemExtractor
implements PlaylistInfoItemExtractor {
    @Nonnull
    protected final JsonObject showRenderer;

    YoutubeBaseShowInfoItemExtractor(@Nonnull JsonObject showRenderer) {
        this.showRenderer = showRenderer;
    }

    @Override
    public String getName() throws ParsingException {
        return this.showRenderer.getString("title");
    }

    @Override
    public String getUrl() throws ParsingException {
        return YoutubeParsingHelper.getUrlFromNavigationEndpoint(this.showRenderer.getObject("navigationEndpoint"));
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        return YoutubeParsingHelper.getThumbnailsFromInfoItem(this.showRenderer.getObject("thumbnailRenderer").getObject("showCustomThumbnailRenderer"));
    }

    @Override
    public long getStreamCount() throws ParsingException {
        String streamCountText = YoutubeParsingHelper.getTextFromObject(this.showRenderer.getObject("thumbnailOverlays").getObject("thumbnailOverlayBottomPanelRenderer").getObject("text"));
        if (streamCountText == null) {
            throw new ParsingException("Could not get stream count");
        }
        try {
            return Long.parseLong(Utils.removeNonDigitCharacters(streamCountText));
        }
        catch (NumberFormatException e) {
            throw new ParsingException("Could not convert stream count to a long", e);
        }
    }
}

