/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.dashmanifestcreators;

import java.util.Arrays;
import java.util.Objects;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Response;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.DeliveryType;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.ItagItem;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.dashmanifestcreators.CreationException;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.dashmanifestcreators.YoutubeDashManifestCreatorsUtils;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.ManifestCreatorCache;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public final class YoutubeOtfDashManifestCreator {
    private static final ManifestCreatorCache<String, String> OTF_STREAMS_CACHE = new ManifestCreatorCache();

    private YoutubeOtfDashManifestCreator() {
    }

    @Nonnull
    public static String fromOtfStreamingUrl(@Nonnull String otfBaseStreamingUrl, @Nonnull ItagItem itagItem, long durationSecondsFallback) throws CreationException {
        long streamDuration;
        String[] segmentDuration;
        if (OTF_STREAMS_CACHE.containsKey(otfBaseStreamingUrl)) {
            return Objects.requireNonNull(OTF_STREAMS_CACHE.get(otfBaseStreamingUrl)).getSecond();
        }
        String realOtfBaseStreamingUrl = otfBaseStreamingUrl;
        Response response = YoutubeDashManifestCreatorsUtils.getInitializationResponse(realOtfBaseStreamingUrl, itagItem, DeliveryType.OTF);
        realOtfBaseStreamingUrl = response.latestUrl().replace("&sq=0", "").replace("&rn=0", "").replace("&alr=yes", "");
        int responseCode = response.responseCode();
        if (responseCode != 200) {
            throw new CreationException("Could not get the initialization URL: response code " + responseCode);
        }
        try {
            String[] segmentsAndDurationsResponseSplit = response.responseBody().split("Segment-Durations-Ms: ")[1].split("\n")[0].split(",");
            int lastIndex = segmentsAndDurationsResponseSplit.length - 1;
            segmentDuration = Utils.isBlank(segmentsAndDurationsResponseSplit[lastIndex]) ? Arrays.copyOf(segmentsAndDurationsResponseSplit, lastIndex) : segmentsAndDurationsResponseSplit;
        }
        catch (Exception e) {
            throw new CreationException("Could not get segment durations", e);
        }
        try {
            streamDuration = YoutubeOtfDashManifestCreator.getStreamDuration(segmentDuration);
        }
        catch (CreationException e) {
            streamDuration = durationSecondsFallback * 1000L;
        }
        Document doc = YoutubeDashManifestCreatorsUtils.generateDocumentAndDoCommonElementsGeneration(itagItem, streamDuration);
        YoutubeDashManifestCreatorsUtils.generateSegmentTemplateElement(doc, realOtfBaseStreamingUrl, DeliveryType.OTF);
        YoutubeDashManifestCreatorsUtils.generateSegmentTimelineElement(doc);
        YoutubeOtfDashManifestCreator.generateSegmentElementsForOtfStreams(segmentDuration, doc);
        return YoutubeDashManifestCreatorsUtils.buildAndCacheResult(otfBaseStreamingUrl, doc, OTF_STREAMS_CACHE);
    }

    @Nonnull
    public static ManifestCreatorCache<String, String> getCache() {
        return OTF_STREAMS_CACHE;
    }

    private static void generateSegmentElementsForOtfStreams(@Nonnull String[] segmentDurations, @Nonnull Document doc) throws CreationException {
        try {
            Element segmentTimelineElement = (Element)doc.getElementsByTagName("SegmentTimeline").item(0);
            for (String segmentDuration : segmentDurations) {
                Element sElement = doc.createElement("S");
                String[] segmentLengthRepeat = segmentDuration.split("\\(r=");
                Integer.parseInt(segmentLengthRepeat[0]);
                if (segmentLengthRepeat.length > 1) {
                    int segmentRepeatCount = Integer.parseInt(Utils.removeNonDigitCharacters(segmentLengthRepeat[1]));
                    YoutubeDashManifestCreatorsUtils.setAttribute(sElement, doc, "r", String.valueOf(segmentRepeatCount));
                }
                YoutubeDashManifestCreatorsUtils.setAttribute(sElement, doc, "d", segmentLengthRepeat[0]);
                segmentTimelineElement.appendChild(sElement);
            }
        }
        catch (IllegalStateException | IndexOutOfBoundsException | NumberFormatException | DOMException e) {
            throw CreationException.couldNotAddElement("segment (S)", e);
        }
    }

    private static long getStreamDuration(@Nonnull String[] segmentDuration) throws CreationException {
        try {
            long streamLengthMs = 0L;
            for (String segDuration : segmentDuration) {
                String[] segmentLengthRepeat = segDuration.split("\\(r=");
                long segmentRepeatCount = 0L;
                if (segmentLengthRepeat.length > 1) {
                    segmentRepeatCount = Long.parseLong(Utils.removeNonDigitCharacters(segmentLengthRepeat[1]));
                }
                long segmentLength = Integer.parseInt(segmentLengthRepeat[0]);
                streamLengthMs += segmentLength + segmentRepeatCount * segmentLength;
            }
            return streamLengthMs;
        }
        catch (NumberFormatException e) {
            throw new CreationException("Could not get stream length from sequences list", e);
        }
    }
}

