/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.dashmanifestcreators;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.javax.xml.parsers.DocumentBuilderFactory;
import org.watermedia.shaded.javax.xml.parsers.ParserConfigurationException;
import org.watermedia.shaded.javax.xml.transform.Result;
import org.watermedia.shaded.javax.xml.transform.Source;
import org.watermedia.shaded.javax.xml.transform.Transformer;
import org.watermedia.shaded.javax.xml.transform.TransformerException;
import org.watermedia.shaded.javax.xml.transform.TransformerFactory;
import org.watermedia.shaded.javax.xml.transform.dom.DOMSource;
import org.watermedia.shaded.javax.xml.transform.stream.StreamResult;
import org.watermedia.shaded.schabi.newpipe.extractor.MediaFormat;
import org.watermedia.shaded.schabi.newpipe.extractor.NewPipe;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Response;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.DeliveryType;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.ItagItem;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.dashmanifestcreators.CreationException;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.AudioTrackType;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.ManifestCreatorCache;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public final class YoutubeDashManifestCreatorsUtils {
    public static final int MAXIMUM_REDIRECT_COUNT = 20;
    public static final String SQ_0 = "&sq=0";
    public static final String RN_0 = "&rn=0";
    public static final String ALR_YES = "&alr=yes";
    public static final String MPD = "MPD";
    public static final String PERIOD = "Period";
    public static final String ADAPTATION_SET = "AdaptationSet";
    public static final String ROLE = "Role";
    public static final String REPRESENTATION = "Representation";
    public static final String AUDIO_CHANNEL_CONFIGURATION = "AudioChannelConfiguration";
    public static final String SEGMENT_TEMPLATE = "SegmentTemplate";
    public static final String SEGMENT_TIMELINE = "SegmentTimeline";
    public static final String BASE_URL = "BaseURL";
    public static final String SEGMENT_BASE = "SegmentBase";
    public static final String INITIALIZATION = "Initialization";

    private YoutubeDashManifestCreatorsUtils() {
    }

    public static void setAttribute(Element element, Document doc, String name, String value) {
        Attr attr = doc.createAttribute(name);
        attr.setValue(value);
        element.setAttributeNode(attr);
    }

    @Nonnull
    public static Document generateDocumentAndDoCommonElementsGeneration(@Nonnull ItagItem itagItem, long streamDuration) throws CreationException {
        Document doc = YoutubeDashManifestCreatorsUtils.generateDocumentAndMpdElement(streamDuration);
        YoutubeDashManifestCreatorsUtils.generatePeriodElement(doc);
        YoutubeDashManifestCreatorsUtils.generateAdaptationSetElement(doc, itagItem);
        YoutubeDashManifestCreatorsUtils.generateRoleElement(doc, itagItem);
        YoutubeDashManifestCreatorsUtils.generateRepresentationElement(doc, itagItem);
        if (itagItem.itagType == ItagItem.ItagType.AUDIO) {
            YoutubeDashManifestCreatorsUtils.generateAudioChannelConfigurationElement(doc, itagItem);
        }
        return doc;
    }

    @Nonnull
    public static Document generateDocumentAndMpdElement(long duration) throws CreationException {
        try {
            Document doc = YoutubeDashManifestCreatorsUtils.newDocument();
            Element mpdElement = doc.createElement(MPD);
            doc.appendChild(mpdElement);
            YoutubeDashManifestCreatorsUtils.setAttribute(mpdElement, doc, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            YoutubeDashManifestCreatorsUtils.setAttribute(mpdElement, doc, "xmlns", "urn:mpeg:DASH:schema:MPD:2011");
            YoutubeDashManifestCreatorsUtils.setAttribute(mpdElement, doc, "xsi:schemaLocation", "urn:mpeg:DASH:schema:MPD:2011 DASH-MPD.xsd");
            YoutubeDashManifestCreatorsUtils.setAttribute(mpdElement, doc, "minBufferTime", "PT1.500S");
            YoutubeDashManifestCreatorsUtils.setAttribute(mpdElement, doc, "profiles", "urn:mpeg:dash:profile:full:2011");
            YoutubeDashManifestCreatorsUtils.setAttribute(mpdElement, doc, "type", "static");
            YoutubeDashManifestCreatorsUtils.setAttribute(mpdElement, doc, "mediaPresentationDuration", String.format(Locale.ENGLISH, "PT%.3fS", (double)duration / 1000.0));
            return doc;
        }
        catch (Exception e) {
            throw new CreationException("Could not generate the DASH manifest or append the MPD doc to it", e);
        }
    }

    public static void generatePeriodElement(@Nonnull Document doc) throws CreationException {
        try {
            Element mpdElement = (Element)doc.getElementsByTagName(MPD).item(0);
            Element periodElement = doc.createElement(PERIOD);
            mpdElement.appendChild(periodElement);
        }
        catch (DOMException e) {
            throw CreationException.couldNotAddElement(PERIOD, e);
        }
    }

    public static void generateAdaptationSetElement(@Nonnull Document doc, @Nonnull ItagItem itagItem) throws CreationException {
        try {
            String audioLanguage;
            Locale audioLocale;
            Element periodElement = (Element)doc.getElementsByTagName(PERIOD).item(0);
            Element adaptationSetElement = doc.createElement(ADAPTATION_SET);
            YoutubeDashManifestCreatorsUtils.setAttribute(adaptationSetElement, doc, "id", "0");
            MediaFormat mediaFormat = itagItem.getMediaFormat();
            if (mediaFormat == null || Utils.isNullOrEmpty(mediaFormat.getMimeType())) {
                throw CreationException.couldNotAddElement(ADAPTATION_SET, "the MediaFormat or its mime type is null or empty");
            }
            if (itagItem.itagType == ItagItem.ItagType.AUDIO && (audioLocale = itagItem.getAudioLocale()) != null && !(audioLanguage = audioLocale.getLanguage()).isEmpty()) {
                YoutubeDashManifestCreatorsUtils.setAttribute(adaptationSetElement, doc, "lang", audioLanguage);
            }
            YoutubeDashManifestCreatorsUtils.setAttribute(adaptationSetElement, doc, "mimeType", mediaFormat.getMimeType());
            YoutubeDashManifestCreatorsUtils.setAttribute(adaptationSetElement, doc, "subsegmentAlignment", "true");
            periodElement.appendChild(adaptationSetElement);
        }
        catch (DOMException e) {
            throw CreationException.couldNotAddElement(ADAPTATION_SET, e);
        }
    }

    public static void generateRoleElement(@Nonnull Document doc, @Nonnull ItagItem itagItem) throws CreationException {
        try {
            Element adaptationSetElement = (Element)doc.getElementsByTagName(ADAPTATION_SET).item(0);
            Element roleElement = doc.createElement(ROLE);
            YoutubeDashManifestCreatorsUtils.setAttribute(roleElement, doc, "schemeIdUri", "urn:mpeg:DASH:role:2011");
            YoutubeDashManifestCreatorsUtils.setAttribute(roleElement, doc, "value", YoutubeDashManifestCreatorsUtils.getRoleValue(itagItem.getAudioTrackType()));
            adaptationSetElement.appendChild(roleElement);
        }
        catch (DOMException e) {
            throw CreationException.couldNotAddElement(ROLE, e);
        }
    }

    private static String getRoleValue(@Nullable AudioTrackType trackType) {
        if (trackType != null) {
            switch (trackType) {
                case ORIGINAL: {
                    return "main";
                }
                case DUBBED: {
                    return "dub";
                }
                case DESCRIPTIVE: {
                    return "description";
                }
            }
            return "alternate";
        }
        return "main";
    }

    public static void generateRepresentationElement(@Nonnull Document doc, @Nonnull ItagItem itagItem) throws CreationException {
        try {
            Element adaptationSetElement = (Element)doc.getElementsByTagName(ADAPTATION_SET).item(0);
            Element representationElement = doc.createElement(REPRESENTATION);
            int id2 = itagItem.id;
            if (id2 <= 0) {
                throw CreationException.couldNotAddElement(REPRESENTATION, "the id of the ItagItem is <= 0");
            }
            YoutubeDashManifestCreatorsUtils.setAttribute(representationElement, doc, "id", String.valueOf(id2));
            String codec = itagItem.getCodec();
            if (Utils.isNullOrEmpty(codec)) {
                throw CreationException.couldNotAddElement(ADAPTATION_SET, "the codec value of the ItagItem is null or empty");
            }
            YoutubeDashManifestCreatorsUtils.setAttribute(representationElement, doc, "codecs", codec);
            YoutubeDashManifestCreatorsUtils.setAttribute(representationElement, doc, "startWithSAP", "1");
            YoutubeDashManifestCreatorsUtils.setAttribute(representationElement, doc, "maxPlayoutRate", "1");
            int bitrate = itagItem.getBitrate();
            if (bitrate <= 0) {
                throw CreationException.couldNotAddElement(REPRESENTATION, "the bitrate of the ItagItem is <= 0");
            }
            YoutubeDashManifestCreatorsUtils.setAttribute(representationElement, doc, "bandwidth", String.valueOf(bitrate));
            if (itagItem.itagType == ItagItem.ItagType.VIDEO || itagItem.itagType == ItagItem.ItagType.VIDEO_ONLY) {
                int height = itagItem.getHeight();
                int width = itagItem.getWidth();
                if (height <= 0 && width <= 0) {
                    throw CreationException.couldNotAddElement(REPRESENTATION, "both width and height of the ItagItem are <= 0");
                }
                if (width > 0) {
                    YoutubeDashManifestCreatorsUtils.setAttribute(representationElement, doc, "width", String.valueOf(width));
                }
                YoutubeDashManifestCreatorsUtils.setAttribute(representationElement, doc, "height", String.valueOf(itagItem.getHeight()));
                int fps = itagItem.getFps();
                if (fps > 0) {
                    YoutubeDashManifestCreatorsUtils.setAttribute(representationElement, doc, "frameRate", String.valueOf(fps));
                }
            }
            if (itagItem.itagType == ItagItem.ItagType.AUDIO && itagItem.getSampleRate() > 0) {
                Attr audioSamplingRateAttribute = doc.createAttribute("audioSamplingRate");
                audioSamplingRateAttribute.setValue(String.valueOf(itagItem.getSampleRate()));
            }
            adaptationSetElement.appendChild(representationElement);
        }
        catch (DOMException e) {
            throw CreationException.couldNotAddElement(REPRESENTATION, e);
        }
    }

    public static void generateAudioChannelConfigurationElement(@Nonnull Document doc, @Nonnull ItagItem itagItem) throws CreationException {
        try {
            Element representationElement = (Element)doc.getElementsByTagName(REPRESENTATION).item(0);
            Element audioChannelConfigurationElement = doc.createElement(AUDIO_CHANNEL_CONFIGURATION);
            YoutubeDashManifestCreatorsUtils.setAttribute(audioChannelConfigurationElement, doc, "schemeIdUri", "urn:mpeg:dash:23003:3:audio_channel_configuration:2011");
            if (itagItem.getAudioChannels() <= 0) {
                throw new CreationException("the number of audioChannels in the ItagItem is <= 0: " + itagItem.getAudioChannels());
            }
            YoutubeDashManifestCreatorsUtils.setAttribute(audioChannelConfigurationElement, doc, "value", String.valueOf(itagItem.getAudioChannels()));
            representationElement.appendChild(audioChannelConfigurationElement);
        }
        catch (DOMException e) {
            throw CreationException.couldNotAddElement(AUDIO_CHANNEL_CONFIGURATION, e);
        }
    }

    public static String buildAndCacheResult(@Nonnull String originalBaseStreamingUrl, @Nonnull Document doc, @Nonnull ManifestCreatorCache<String, String> manifestCreatorCache) throws CreationException {
        try {
            String documentXml = YoutubeDashManifestCreatorsUtils.documentToXml(doc);
            manifestCreatorCache.put(originalBaseStreamingUrl, documentXml);
            return documentXml;
        }
        catch (Exception e) {
            throw new CreationException("Could not convert the DASH manifest generated to a string", e);
        }
    }

    public static void generateSegmentTemplateElement(@Nonnull Document doc, @Nonnull String baseUrl, DeliveryType deliveryType) throws CreationException {
        if (deliveryType != DeliveryType.OTF && deliveryType != DeliveryType.LIVE) {
            throw CreationException.couldNotAddElement(SEGMENT_TEMPLATE, "invalid delivery type: " + deliveryType);
        }
        try {
            Element representationElement = (Element)doc.getElementsByTagName(REPRESENTATION).item(0);
            Element segmentTemplateElement = doc.createElement(SEGMENT_TEMPLATE);
            YoutubeDashManifestCreatorsUtils.setAttribute(segmentTemplateElement, doc, "startNumber", deliveryType == DeliveryType.LIVE ? "0" : "1");
            YoutubeDashManifestCreatorsUtils.setAttribute(segmentTemplateElement, doc, "timescale", "1000");
            if (deliveryType != DeliveryType.LIVE) {
                YoutubeDashManifestCreatorsUtils.setAttribute(segmentTemplateElement, doc, "initialization", baseUrl + SQ_0);
            }
            YoutubeDashManifestCreatorsUtils.setAttribute(segmentTemplateElement, doc, "media", baseUrl + "&sq=$Number$");
            representationElement.appendChild(segmentTemplateElement);
        }
        catch (DOMException e) {
            throw CreationException.couldNotAddElement(SEGMENT_TEMPLATE, e);
        }
    }

    public static void generateSegmentTimelineElement(@Nonnull Document doc) throws CreationException {
        try {
            Element segmentTemplateElement = (Element)doc.getElementsByTagName(SEGMENT_TEMPLATE).item(0);
            Element segmentTimelineElement = doc.createElement(SEGMENT_TIMELINE);
            segmentTemplateElement.appendChild(segmentTimelineElement);
        }
        catch (DOMException e) {
            throw CreationException.couldNotAddElement(SEGMENT_TIMELINE, e);
        }
    }

    @Nonnull
    public static Response getInitializationResponse(@Nonnull String baseStreamingUrl, @Nonnull ItagItem itagItem, DeliveryType deliveryType) throws CreationException {
        boolean isTvHtml5StreamingUrl = YoutubeParsingHelper.isTvHtml5StreamingUrl((String)baseStreamingUrl);
        boolean isHtml5StreamingUrl = YoutubeParsingHelper.isWebStreamingUrl((String)baseStreamingUrl) || isTvHtml5StreamingUrl || YoutubeParsingHelper.isWebEmbeddedPlayerStreamingUrl((String)baseStreamingUrl);
        boolean isAndroidStreamingUrl = YoutubeParsingHelper.isAndroidStreamingUrl((String)baseStreamingUrl);
        boolean isIosStreamingUrl = YoutubeParsingHelper.isIosStreamingUrl((String)baseStreamingUrl);
        if (isHtml5StreamingUrl) {
            baseStreamingUrl = (String)baseStreamingUrl + ALR_YES;
        }
        baseStreamingUrl = YoutubeDashManifestCreatorsUtils.appendRnSqParamsIfNeeded((String)baseStreamingUrl, deliveryType);
        Downloader downloader = NewPipe.getDownloader();
        if (isHtml5StreamingUrl) {
            String mimeTypeExpected = itagItem.getMediaFormat().getMimeType();
            if (!Utils.isNullOrEmpty(mimeTypeExpected)) {
                return YoutubeDashManifestCreatorsUtils.getStreamingWebUrlWithoutRedirects(downloader, (String)baseStreamingUrl, mimeTypeExpected, isTvHtml5StreamingUrl);
            }
        } else if (isAndroidStreamingUrl || isIosStreamingUrl) {
            try {
                Map<String, List<String>> headers = Map.of("User-Agent", List.of(isAndroidStreamingUrl ? YoutubeParsingHelper.getAndroidUserAgent(null) : YoutubeParsingHelper.getIosUserAgent(null)));
                byte[] emptyBody = "".getBytes(StandardCharsets.UTF_8);
                return downloader.post((String)baseStreamingUrl, headers, emptyBody);
            }
            catch (IOException | ExtractionException e) {
                throw new CreationException("Could not get the " + (isIosStreamingUrl ? "ANDROID" : "IOS") + " streaming URL response", e);
            }
        }
        try {
            return downloader.get((String)baseStreamingUrl);
        }
        catch (IOException | ExtractionException e) {
            throw new CreationException("Could not get the streaming URL response", e);
        }
    }

    private static Document newDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", (Object)"");
            documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", (Object)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return documentBuilderFactory.newDocumentBuilder().newDocument();
    }

    private static String documentToXml(@Nonnull Document doc) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", (Object)"");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", (Object)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("version", "1.0");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("standalone", "no");
        StringWriter result = new StringWriter();
        transformer.transform((Source)new DOMSource((Node)doc), (Result)new StreamResult((Writer)result));
        return result.toString();
    }

    @Nonnull
    private static String appendRnSqParamsIfNeeded(@Nonnull String baseStreamingUrl, @Nonnull DeliveryType deliveryType) {
        return baseStreamingUrl + (deliveryType == DeliveryType.PROGRESSIVE ? "" : SQ_0) + RN_0;
    }

    @Nonnull
    private static Response getStreamingWebUrlWithoutRedirects(@Nonnull Downloader downloader, @Nonnull String streamingUrl, @Nonnull String responseMimeTypeExpected, boolean isTvHtml5StreamingUrl) throws CreationException {
        try {
            int redirectsCount;
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>(YoutubeParsingHelper.getOriginReferrerHeaders("https://www.youtube.com"));
            if (isTvHtml5StreamingUrl) {
                headers.put("User-Agent", List.of(YoutubeParsingHelper.getTvHtml5UserAgent()));
            }
            String responseMimeType = "";
            for (redirectsCount = 0; !responseMimeType.equals(responseMimeTypeExpected) && redirectsCount < 20; ++redirectsCount) {
                byte[] html5Body = new byte[]{120, 0};
                Response response = downloader.post(streamingUrl, headers, html5Body);
                int responseCode = response.responseCode();
                if (responseCode != 200) {
                    throw new CreationException("Could not get the initialization URL: HTTP response code " + responseCode);
                }
                responseMimeType = Objects.requireNonNull(response.getHeader("Content-Type"), "Could not get the Content-Type header from the response headers");
                if (responseMimeType.equals("text/plain")) {
                    streamingUrl = response.responseBody();
                    continue;
                }
                return response;
            }
            if (redirectsCount >= 20) {
                throw new CreationException("Too many redirects when trying to get the the streaming URL response of a HTML5 client");
            }
            throw new CreationException("Could not get the streaming URL response of a HTML5 client: unreachable code reached!");
        }
        catch (IOException | ExtractionException e) {
            throw new CreationException("Could not get the streaming URL response of a HTML5 client", e);
        }
    }
}

