/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.linkHandler;

import java.io.IOException;
import java.util.List;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.SoundcloudParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.linkHandler.SoundcloudStreamLinkHandlerFactory;

public final class SoundcloudCommentsLinkHandlerFactory
extends ListLinkHandlerFactory {
    private static final SoundcloudCommentsLinkHandlerFactory INSTANCE = new SoundcloudCommentsLinkHandlerFactory();

    private SoundcloudCommentsLinkHandlerFactory() {
    }

    public static SoundcloudCommentsLinkHandlerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public String getUrl(String id2, List<String> contentFilter, String sortFilter) throws ParsingException, UnsupportedOperationException {
        try {
            return "https://api-v2.soundcloud.com/tracks/" + id2 + "/comments?client_id=" + SoundcloudParsingHelper.clientId() + "&threaded=0&filter_replies=1";
        }
        catch (IOException | ExtractionException e) {
            throw new ParsingException("Could not get comments");
        }
    }

    @Override
    public String getId(String url) throws ParsingException, UnsupportedOperationException {
        return SoundcloudStreamLinkHandlerFactory.getInstance().getId(url);
    }

    @Override
    public boolean onAcceptUrl(String url) {
        try {
            this.getId(url);
            return true;
        }
        catch (ParsingException e) {
            return false;
        }
    }
}

