/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.extractors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.ChannelInfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.ChannelInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.SoundcloudParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.SoundcloudService;
import org.watermedia.shaded.schabi.newpipe.extractor.subscription.SubscriptionExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.subscription.SubscriptionItem;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class SoundcloudSubscriptionExtractor
extends SubscriptionExtractor {
    public SoundcloudSubscriptionExtractor(SoundcloudService service) {
        super(service, Collections.singletonList(SubscriptionExtractor.ContentSource.CHANNEL_URL));
    }

    @Override
    public String getRelatedUrl() {
        return "https://soundcloud.com/you";
    }

    @Override
    public List<SubscriptionItem> fromChannelUrl(String channelUrl) throws IOException, ExtractionException {
        String id2;
        if (channelUrl == null) {
            throw new SubscriptionExtractor.InvalidSourceException("Channel url is null");
        }
        try {
            id2 = this.service.getChannelLHFactory().fromUrl(this.getUrlFrom(channelUrl)).getId();
        }
        catch (ExtractionException e) {
            throw new SubscriptionExtractor.InvalidSourceException(e);
        }
        String apiUrl = "https://api-v2.soundcloud.com/users/" + id2 + "/followings?client_id=" + SoundcloudParsingHelper.clientId() + "&limit=200";
        ChannelInfoItemsCollector collector = new ChannelInfoItemsCollector(this.service.getServiceId());
        SoundcloudParsingHelper.getUsersFromApiMinItems(2500, collector, apiUrl);
        return this.toSubscriptionItems(collector.getItems());
    }

    private String getUrlFrom(String channelUrl) {
        String fixedUrl = Utils.replaceHttpWithHttps(channelUrl);
        if (fixedUrl.startsWith("https://")) {
            return channelUrl;
        }
        if (!fixedUrl.contains("soundcloud.com/")) {
            return "https://soundcloud.com/" + fixedUrl;
        }
        return "https://" + fixedUrl;
    }

    private List<SubscriptionItem> toSubscriptionItems(List<ChannelInfoItem> items) {
        ArrayList<SubscriptionItem> result = new ArrayList<SubscriptionItem>(items.size());
        for (ChannelInfoItem item : items) {
            result.add(new SubscriptionItem(item.getServiceId(), item.getUrl(), item.getName()));
        }
        return result;
    }
}

