/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.extractors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.NewPipe;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.SoundcloudParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.extractors.SoundcloudStreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Description;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class SoundcloudPlaylistExtractor
extends PlaylistExtractor {
    private static final int STREAMS_PER_REQUESTED_PAGE = 15;
    private String playlistId;
    private JsonObject playlist;

    public SoundcloudPlaylistExtractor(StreamingService service, ListLinkHandler linkHandler) {
        super(service, linkHandler);
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        this.playlistId = this.getLinkHandler().getId();
        String apiUrl = "https://api-v2.soundcloud.com/playlists/" + this.playlistId + "?client_id=" + SoundcloudParsingHelper.clientId() + "&representation=compact";
        String response = downloader.get(apiUrl, this.getExtractorLocalization()).responseBody();
        try {
            this.playlist = JsonParser.object().from(response);
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse json response", e);
        }
    }

    @Override
    @Nonnull
    public String getId() {
        return this.playlistId;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.playlist.getString("title");
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() {
        String artworkUrl = this.playlist.getString("artwork_url");
        if (!Utils.isNullOrEmpty(artworkUrl)) {
            return SoundcloudParsingHelper.getAllImagesFromArtworkOrAvatarUrl(artworkUrl);
        }
        try {
            ListExtractor.InfoItemsPage<StreamInfoItem> infoItems = this.getInitialPage();
            for (StreamInfoItem item : infoItems.getItems()) {
                List<Image> thumbnails = item.getThumbnails();
                if (Utils.isNullOrEmpty(thumbnails)) continue;
                return thumbnails;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return List.of();
    }

    @Override
    public String getUploaderUrl() {
        return SoundcloudParsingHelper.getUploaderUrl(this.playlist);
    }

    @Override
    public String getUploaderName() {
        return SoundcloudParsingHelper.getUploaderName(this.playlist);
    }

    @Override
    @Nonnull
    public List<Image> getUploaderAvatars() {
        return SoundcloudParsingHelper.getAllImagesFromArtworkOrAvatarUrl(SoundcloudParsingHelper.getAvatarUrl(this.playlist));
    }

    @Override
    public boolean isUploaderVerified() throws ParsingException {
        return this.playlist.getObject("user").getBoolean("verified");
    }

    @Override
    public long getStreamCount() {
        return this.playlist.getLong("track_count");
    }

    @Override
    @Nonnull
    public Description getDescription() throws ParsingException {
        String description = this.playlist.getString("description");
        if (Utils.isNullOrEmpty(description)) {
            return Description.EMPTY_DESCRIPTION;
        }
        return new Description(description, 3);
    }

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage<StreamInfoItem> getInitialPage() {
        StreamInfoItemsCollector streamInfoItemsCollector = new StreamInfoItemsCollector(this.getServiceId());
        ArrayList<String> ids = new ArrayList<String>();
        this.playlist.getArray("tracks").stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).forEachOrdered(track -> {
            if (track.has("title")) {
                streamInfoItemsCollector.commit(new SoundcloudStreamInfoItemExtractor((JsonObject)track));
            } else {
                ids.add(String.format("%010d", track.getInt("id")));
            }
        });
        return new ListExtractor.InfoItemsPage<StreamInfoItem>(streamInfoItemsCollector, new Page(ids));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ListExtractor.InfoItemsPage<StreamInfoItem> getPage(Page page) throws IOException, ExtractionException {
        List<String> nextIds;
        List<String> currentIds;
        if (page == null || Utils.isNullOrEmpty(page.getIds())) {
            throw new IllegalArgumentException("Page doesn't contain IDs");
        }
        if (page.getIds().size() <= 15) {
            currentIds = page.getIds();
            nextIds = null;
        } else {
            currentIds = page.getIds().subList(0, 15);
            nextIds = page.getIds().subList(15, page.getIds().size());
        }
        String currentPageUrl = "https://api-v2.soundcloud.com/tracks?client_id=" + SoundcloudParsingHelper.clientId() + "&ids=" + String.join((CharSequence)",", currentIds);
        StreamInfoItemsCollector collector = new StreamInfoItemsCollector(this.getServiceId());
        String response = NewPipe.getDownloader().get(currentPageUrl, this.getExtractorLocalization()).responseBody();
        try {
            JsonArray tracks = JsonParser.array().from(response);
            HashMap<Integer, JsonObject> idToTrack = new HashMap<Integer, JsonObject>();
            for (Object track : tracks) {
                if (!(track instanceof JsonObject)) continue;
                JsonObject o = (JsonObject)track;
                idToTrack.put(o.getInt("id"), o);
            }
            for (String strId : currentIds) {
                int id2 = Integer.parseInt(strId);
                try {
                    collector.commit(new SoundcloudStreamInfoItemExtractor(Objects.requireNonNull((JsonObject)idToTrack.get(id2), "no track with id " + id2 + " in response")));
                }
                catch (NullPointerException e) {
                    throw new ParsingException("Could not parse json response", e);
                    return new ListExtractor.InfoItemsPage<StreamInfoItem>(collector, new Page(nextIds));
                }
            }
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse json response", e);
        }
    }
}

